/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.quarkus.runtime.TemplateHtmlBuilder;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.vertx.http.runtime.devmode.AdditionalRouteDescription;
import io.quarkus.vertx.http.runtime.devmode.RouteDescription;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.server.ServerExceptionMapper;
import org.jboss.resteasy.reactive.server.core.request.ServerDrivenNegotiation;
import org.jboss.resteasy.reactive.server.handlers.RestInitialHandler;
import org.jboss.resteasy.reactive.server.mapping.RequestMapper;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.util.RuntimeResourceVisitor;

public class NotFoundExceptionMapper {
    protected static final String META_INF_RESOURCES = "META-INF/resources";
    private static final Variant JSON_VARIANT = new Variant(MediaType.APPLICATION_JSON_TYPE, (String)null, null);
    private static final Variant HTML_VARIANT = new Variant(MediaType.TEXT_HTML_TYPE, (String)null, null);
    private static final List<Variant> VARIANTS = List.of(JSON_VARIANT, HTML_VARIANT);
    static volatile List<RequestMapper.RequestPath<RestInitialHandler.InitialMatch>> classMappers;
    private static volatile String httpRoot;
    private static volatile List<String> servletMappings;
    private static volatile Set<Path> staticResourceRoots;
    private static volatile List<AdditionalRouteDescription> additionalEndpoints;
    private static volatile List<RouteDescription> reactiveRoutes;
    private static final Logger LOG;

    public static void setHttpRoot(String rootPath) {
        httpRoot = rootPath;
    }

    @ServerExceptionMapper(value={NotFoundException.class}, priority=5001)
    public Response toResponse(HttpHeaders headers) {
        if (classMappers == null || classMappers.isEmpty()) {
            return this.respond(headers);
        }
        return this.respond(ResourceDescription.fromClassMappers(classMappers), headers);
    }

    private Response respond(HttpHeaders headers) {
        Variant variant = NotFoundExceptionMapper.selectVariant(headers);
        if (variant == JSON_VARIANT) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/json").build();
        }
        if (variant == HTML_VARIANT) {
            TemplateHtmlBuilder sb = new TemplateHtmlBuilder("404 - Resource Not Found", "", "No resources discovered");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)sb.toString()).type(MediaType.TEXT_HTML_TYPE).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private Response respond(List<ResourceDescription> descriptions, HttpHeaders headers) {
        Variant variant = NotFoundExceptionMapper.selectVariant(headers);
        if (variant == JSON_VARIANT) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/json").build();
        }
        if (variant == HTML_VARIANT) {
            List<String> resources;
            TemplateHtmlBuilder sb = new TemplateHtmlBuilder("404 - Resource Not Found", "", "Resources overview");
            sb.resourcesStart("REST resources");
            for (ResourceDescription resource : descriptions) {
                sb.resourcePath(TemplateHtmlBuilder.adjustRoot((String)httpRoot, (String)resource.basePath));
                for (MethodDescription method : resource.calls) {
                    sb.method(method.method, method.fullPath);
                    if (method.consumes != null) {
                        sb.consumes(method.consumes);
                    }
                    if (method.produces != null) {
                        sb.produces(method.produces);
                    }
                    sb.methodEnd();
                }
                sb.resourceEnd();
            }
            if (descriptions.isEmpty()) {
                sb.noResourcesFound();
            }
            sb.resourcesEnd();
            if (!servletMappings.isEmpty()) {
                sb.resourcesStart("Servlet mappings");
                for (String servletMapping : servletMappings) {
                    sb.servletMapping(TemplateHtmlBuilder.adjustRoot((String)httpRoot, (String)servletMapping));
                }
                sb.resourcesEnd();
            }
            if (!reactiveRoutes.isEmpty()) {
                sb.resourcesStart("Reactive Routes");
                sb.resourceStart();
                for (RouteDescription route : reactiveRoutes) {
                    sb.method(route.getHttpMethod(), route.getPath());
                    sb.listItem(route.getJavaMethod());
                    if (route.getConsumes() != null) {
                        sb.consumes(route.getConsumes());
                    }
                    if (route.getProduces() != null) {
                        sb.produces(route.getProduces());
                    }
                    sb.methodEnd();
                }
                sb.resourceEnd();
                sb.resourcesEnd();
            }
            if (!staticResourceRoots.isEmpty() && !(resources = this.findRealResources()).isEmpty()) {
                sb.resourcesStart("Static resources");
                for (String staticResource : resources) {
                    sb.staticResourcePath(TemplateHtmlBuilder.adjustRoot((String)httpRoot, (String)staticResource));
                }
                sb.resourcesEnd();
            }
            if (!additionalEndpoints.isEmpty()) {
                sb.resourcesStart("Additional endpoints");
                for (AdditionalRouteDescription additionalEndpoint : additionalEndpoints) {
                    sb.staticResourcePath(additionalEndpoint.getUri(), additionalEndpoint.getDescription());
                }
                sb.resourcesEnd();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)sb.toString()).type(MediaType.TEXT_HTML_TYPE).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private List<String> findRealResources() {
        final HashSet knownFiles = new HashSet();
        for (final Path resource : staticResourceRoots) {
            if (resource == null || !Files.exists(resource, new LinkOption[0])) continue;
            try {
                Stream<Path> fileTreeElements = Files.walk(resource, new FileVisitOption[0]);
                try {
                    fileTreeElements.forEach(new Consumer<Path>(){

                        @Override
                        public void accept(Path path) {
                            if (resource.equals(path)) {
                                return;
                            }
                            Path rel = resource.relativize(path);
                            if (!Files.isDirectory(path, new LinkOption[0])) {
                                knownFiles.add(rel.toString());
                            }
                        }
                    });
                }
                finally {
                    if (fileTreeElements == null) continue;
                    fileTreeElements.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to read static resources", (Throwable)e);
            }
        }
        try {
            ClassPathUtils.consumeAsPaths((String)META_INF_RESOURCES, p -> this.collectKnownPaths((Path)p, knownFiles));
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to read static resources", (Throwable)e);
        }
        return knownFiles.stream().filter(this::isHtmlFileName).limit(1000L).distinct().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }

    private void collectKnownPaths(final Path resource, final Set<String> knownPaths) {
        try {
            Files.walkFileTree(resource, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path p, BasicFileAttributes attrs) throws IOException {
                    String file = resource.relativize(p).toString();
                    file = file.replace('\\', '/');
                    knownPaths.add(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isHtmlFileName(String fileName) {
        return fileName.endsWith(".html") || fileName.endsWith(".htm");
    }

    private static Variant selectVariant(HttpHeaders headers) {
        ServerDrivenNegotiation negotiation = new ServerDrivenNegotiation();
        negotiation.setAcceptHeaders((List)headers.getRequestHeaders().get((Object)"Accept"));
        return negotiation.getBestMatch(VARIANTS);
    }

    public static void servlets(Map<String, List<String>> servletToMapping) {
        servletMappings = servletToMapping.values().stream().flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    public static void staticResources(Set<String> knownRoots) {
        staticResourceRoots = new HashSet<Path>();
        for (String i : knownRoots) {
            staticResourceRoots.add(Paths.get(i, new String[0]));
        }
    }

    public static void setAdditionalEndpoints(List<AdditionalRouteDescription> additionalEndpoints) {
        NotFoundExceptionMapper.additionalEndpoints = additionalEndpoints;
    }

    public static void setReactiveRoutes(List<RouteDescription> reactiveRoutes) {
        NotFoundExceptionMapper.reactiveRoutes = reactiveRoutes;
    }

    static {
        httpRoot = "";
        servletMappings = Collections.emptyList();
        staticResourceRoots = Collections.emptySet();
        additionalEndpoints = Collections.emptyList();
        reactiveRoutes = Collections.emptyList();
        LOG = Logger.getLogger(NotFoundExceptionMapper.class);
    }

    public static final class ResourceDescription {
        public final String basePath;
        public final List<MethodDescription> calls = new ArrayList<MethodDescription>();

        public ResourceDescription(String basePath) {
            this.basePath = basePath;
        }

        private static String mostPreferredOrNull(List<MediaType> mediaTypes) {
            if (mediaTypes == null || mediaTypes.isEmpty()) {
                return null;
            }
            return mediaTypes.get(0).toString();
        }

        public static List<ResourceDescription> fromClassMappers(List<RequestMapper.RequestPath<RestInitialHandler.InitialMatch>> classMappers) {
            final HashMap descriptions = new HashMap();
            RuntimeResourceVisitor.visitRuntimeResources(classMappers, (RuntimeResourceVisitor)new RuntimeResourceVisitor(){
                private ResourceDescription description;

                public void visitRuntimeResource(String httpMethod, String fullPath, RuntimeResource runtimeResource) {
                    ServerMediaType serverMediaType = runtimeResource.getProduces();
                    List<MediaType> produces = Collections.emptyList();
                    if (serverMediaType != null && serverMediaType.getSortedOriginalMediaTypes() != null && serverMediaType.getSortedOriginalMediaTypes().length >= 1) {
                        produces = Arrays.asList(serverMediaType.getSortedOriginalMediaTypes());
                    }
                    this.description.calls.add(new MethodDescription(httpMethod, fullPath, ResourceDescription.mostPreferredOrNull(produces), ResourceDescription.mostPreferredOrNull(runtimeResource.getConsumes())));
                }

                public void visitBasePath(String basePath) {
                    this.description = (ResourceDescription)descriptions.get(basePath);
                    if (this.description == null) {
                        this.description = new ResourceDescription(basePath);
                        descriptions.put(basePath, this.description);
                    }
                }
            });
            return new LinkedList<ResourceDescription>(descriptions.values());
        }
    }

    public static final class MethodDescription {
        public String method;
        public String fullPath;
        public String produces;
        public String consumes;

        public MethodDescription(String method, String fullPath, String produces, String consumes) {
            this.method = method;
            this.fullPath = fullPath;
            this.produces = produces;
            this.consumes = consumes;
        }
    }
}

