/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.exceptionmappers;

import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.AsyncExceptionMappingUtil;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.util.function.Function;
import javax.ws.rs.core.Response;

final class SecurityExceptionMapperUtil {
    private SecurityExceptionMapperUtil() {
    }

    static Uni<Response> handleWithAuthenticator(RoutingContext routingContext) {
        HttpAuthenticator authenticator = (HttpAuthenticator)routingContext.get(HttpAuthenticator.class.getName());
        if (authenticator != null) {
            Uni challenge = authenticator.getChallenge(routingContext);
            return challenge.map((Function)new Function<ChallengeData, Response>(){

                @Override
                public Response apply(ChallengeData challengeData) {
                    if (challengeData == null) {
                        return AsyncExceptionMappingUtil.DEFAULT_UNAUTHORIZED_RESPONSE;
                    }
                    Response.ResponseBuilder status = Response.status((int)challengeData.status);
                    if (challengeData.headerName != null) {
                        status.header(challengeData.headerName.toString(), (Object)challengeData.headerContent);
                    }
                    return status.build();
                }
            }).onFailure().recoverWithItem((Object)AsyncExceptionMappingUtil.DEFAULT_UNAUTHORIZED_RESPONSE);
        }
        return Uni.createFrom().item((Object)AsyncExceptionMappingUtil.DEFAULT_UNAUTHORIZED_RESPONSE);
    }
}

