/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.security;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class EagerSecurityHandler
implements ServerRestHandler {
    private static final SecurityCheck NULL_SENTINEL = new SecurityCheck(){

        public void apply(SecurityIdentity identity, Method method, Object[] parameters) {
        }

        public void apply(SecurityIdentity identity, MethodDescription method, Object[] parameters) {
        }
    };
    private volatile InjectableInstance<CurrentIdentityAssociation> currentIdentityAssociation;
    private volatile SecurityCheck check;
    private volatile AuthorizationController authorizationController;

    public void handle(final ResteasyReactiveRequestContext requestContext) throws Exception {
        if (this.check == NULL_SENTINEL) {
            return;
        }
        SecurityCheck check = this.check;
        ResteasyReactiveResourceInfo lazyMethod = requestContext.getTarget().getLazyMethod();
        final MethodDescription methodDescription = new MethodDescription(lazyMethod.getResourceClass().getName(), lazyMethod.getName(), MethodDescription.typesAsStrings((Class[])lazyMethod.getParameterTypes()));
        if (check == null) {
            check = ((SecurityCheckStorage)Arc.container().instance(SecurityCheckStorage.class, new Annotation[0]).get()).getSecurityCheck(methodDescription);
            if (check == null) {
                check = NULL_SENTINEL;
            }
            this.check = check;
        }
        if (check == NULL_SENTINEL) {
            return;
        }
        if (this.authorizationController == null) {
            this.authorizationController = (AuthorizationController)Arc.container().instance(AuthorizationController.class, new Annotation[0]).get();
        }
        if (!this.authorizationController.isAuthorizationEnabled()) {
            return;
        }
        requestContext.requireCDIRequestScope();
        requestContext.suspend();
        final SecurityCheck theCheck = check;
        ((CurrentIdentityAssociation)this.getCurrentIdentityAssociation().get()).getDeferredIdentity().map((Function)new Function<SecurityIdentity, Object>(){

            @Override
            public Object apply(SecurityIdentity securityIdentity) {
                theCheck.apply(securityIdentity, methodDescription, requestContext.getParameters());
                return null;
            }
        }).subscribe().withSubscriber((UniSubscriber)new UniSubscriber<Object>(){

            public void onSubscribe(UniSubscription subscription) {
            }

            public void onItem(Object item) {
                requestContext.resume();
            }

            public void onFailure(Throwable failure) {
                requestContext.resume(failure);
            }
        });
    }

    private InjectableInstance<CurrentIdentityAssociation> getCurrentIdentityAssociation() {
        InjectableInstance<CurrentIdentityAssociation> identityAssociation = this.currentIdentityAssociation;
        if (identityAssociation == null) {
            this.currentIdentityAssociation = Arc.container().select(CurrentIdentityAssociation.class, new Annotation[0]);
            return this.currentIdentityAssociation;
        }
        return identityAssociation;
    }

    public static class Customizer
    implements HandlerChainCustomizer {
        public List<ServerRestHandler> handlers(HandlerChainCustomizer.Phase phase, ResourceClass resourceClass, ServerResourceMethod serverResourceMethod) {
            if (phase == HandlerChainCustomizer.Phase.AFTER_MATCH) {
                return Collections.singletonList(new EagerSecurityHandler());
            }
            return Collections.emptyList();
        }
    }
}

