/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveSecurityContext;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.event.Event;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.jaxrs.ProvidersImpl;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.server.vertx.VertxResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class QuarkusResteasyReactiveRequestContext
extends VertxResteasyReactiveRequestContext {
    final CurrentIdentityAssociation association;
    boolean userSetup = false;

    public QuarkusResteasyReactiveRequestContext(Deployment deployment, ProvidersImpl providers, RoutingContext context, ThreadSetupAction requestContext, ServerRestHandler[] handlerChain, ServerRestHandler[] abortHandlerChain, ClassLoader devModeTccl, CurrentIdentityAssociation currentIdentityAssociation, List<String> vertxContextPropsToCopy) {
        super(deployment, providers, context, requestContext, handlerChain, abortHandlerChain, devModeTccl, vertxContextPropsToCopy);
        this.association = currentIdentityAssociation;
        VertxContextSafetyToggle.setCurrentContextSafe((boolean)true);
    }

    protected void handleRequestScopeActivation() {
        super.handleRequestScopeActivation();
        if (!this.userSetup && this.association != null) {
            this.userSetup = true;
            QuarkusHttpUser existing = (QuarkusHttpUser)this.context.user();
            if (existing != null) {
                SecurityIdentity identity = existing.getSecurityIdentity();
                this.association.setIdentity(identity);
            } else {
                this.association.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)this.context, null));
            }
        }
    }

    private static Event<SecurityIdentity> createEvent() {
        return Arc.container().beanManager().getEvent().select(SecurityIdentity.class, new Annotation[0]);
    }

    protected SecurityContext createSecurityContext() {
        return new ResteasyReactiveSecurityContext(this.context);
    }

    protected void handleUnrecoverableError(Throwable throwable) {
        this.context.fail(throwable);
        super.handleUnrecoverableError(throwable);
    }

    public boolean handlesUnmappedException() {
        return false;
    }

    public void handleUnmappedException(Throwable throwable) {
        throw this.sneakyThrow(throwable);
    }

    private <E extends Throwable> RuntimeException sneakyThrow(Throwable e) throws E {
        throw e;
    }
}

