/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.server.common.deployment;

import io.quarkus.arc.ArcUndeclaredThrowableException;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.BuildTimeConditionBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.jaxrs.spi.deployment.AdditionalJaxRsResourceMethodAnnotationsBuildItem;
import io.quarkus.resteasy.common.deployment.JaxrsProvidersToRegisterBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyCommonProcessor;
import io.quarkus.resteasy.common.runtime.QuarkusInjectorFactory;
import io.quarkus.resteasy.common.spi.ResteasyDotNames;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentBuildItem;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentCustomizerBuildItem;
import io.quarkus.resteasy.server.common.deployment.ResteasyServerConfigBuildItem;
import io.quarkus.resteasy.server.common.deployment.ResteasyServletMappingBuildItem;
import io.quarkus.resteasy.server.common.runtime.QuarkusResteasyDeployment;
import io.quarkus.resteasy.server.common.spi.AdditionalJaxRsResourceDefiningAnnotationBuildItem;
import io.quarkus.resteasy.server.common.spi.AdditionalJaxRsResourceMethodParamAnnotations;
import io.quarkus.resteasy.server.common.spi.AllowedJaxRsAnnotationPrefixBuildItem;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.annotations.ConvertWith;
import io.quarkus.runtime.configuration.NormalizeRootHttpPathConverter;
import jakarta.ws.rs.core.Application;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.ViolationReport;
import org.jboss.resteasy.microprofile.config.FilterConfigSource;
import org.jboss.resteasy.microprofile.config.ServletConfigSource;
import org.jboss.resteasy.microprofile.config.ServletContextConfigSource;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.util.Encode;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class ResteasyServerCommonProcessor {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.resteasy");
    private static final String JAX_RS_APPLICATION_PARAMETER_NAME = "jakarta.ws.rs.Application";
    private static final String MESSAGES_RESOURCE_BUNDLE = "messages";
    private static final DotName JSONB_ANNOTATION = DotName.createSimple((String)"jakarta.json.bind.annotation.JsonbAnnotation");
    private static final List<DotName> METHOD_ANNOTATIONS = List.of(ResteasyDotNames.GET, ResteasyDotNames.HEAD, ResteasyDotNames.DELETE, ResteasyDotNames.OPTIONS, ResteasyDotNames.PATCH, ResteasyDotNames.POST, ResteasyDotNames.PUT);
    private static final List<DotName> RESTEASY_PARAM_ANNOTATIONS = List.of(ResteasyDotNames.RESTEASY_QUERY_PARAM, ResteasyDotNames.RESTEASY_FORM_PARAM, ResteasyDotNames.RESTEASY_COOKIE_PARAM, ResteasyDotNames.RESTEASY_PATH_PARAM, ResteasyDotNames.RESTEASY_HEADER_PARAM, ResteasyDotNames.RESTEASY_MATRIX_PARAM);
    ResteasyConfig resteasyConfig;
    ResteasyCommonProcessor.ResteasyCommonConfig commonConfig;

    @BuildStep
    NativeImageResourceBundleBuildItem optionalResourceBundle() {
        if (QuarkusClassLoader.isResourcePresentAtRuntime((String)MESSAGES_RESOURCE_BUNDLE)) {
            return new NativeImageResourceBundleBuildItem(MESSAGES_RESOURCE_BUNDLE);
        }
        return null;
    }

    @BuildStep
    public void build(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinition, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ResteasyServerConfigBuildItem> resteasyServerConfig, BuildProducer<ResteasyDeploymentBuildItem> resteasyDeployment, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer, List<BuildTimeConditionBuildItem> buildTimeConditions, List<AutoInjectAnnotationBuildItem> autoInjectAnnotations, List<AdditionalJaxRsResourceDefiningAnnotationBuildItem> additionalJaxRsResourceDefiningAnnotations, List<AdditionalJaxRsResourceMethodAnnotationsBuildItem> additionalJaxRsResourceMethodAnnotations, List<AdditionalJaxRsResourceMethodParamAnnotations> additionalJaxRsResourceMethodParamAnnotations, List<AllowedJaxRsAnnotationPrefixBuildItem> friendlyJaxRsAnnotationPrefixes, List<ResteasyDeploymentCustomizerBuildItem> deploymentCustomizers, JaxrsProvidersToRegisterBuildItem jaxrsProvidersToRegisterBuildItem, CombinedIndexBuildItem combinedIndexBuildItem, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, Optional<ResteasyServletMappingBuildItem> resteasyServletMappingBuildItem, final CustomScopeAnnotationsBuildItem scopes) throws Exception {
        String className;
        Collection implementors;
        String path;
        String rootPath;
        boolean filterClasses;
        String appClass;
        Set<String> allowedClasses;
        IndexView index = combinedIndexBuildItem.getIndex();
        Collection<Object> applicationPaths = Collections.emptySet();
        Set<Object> excludedClasses = this.resteasyConfig.buildTimeConditionAware ? ResteasyServerCommonProcessor.getExcludedClasses(buildTimeConditions) : Collections.emptySet();
        if (this.resteasyConfig.ignoreApplicationClasses) {
            allowedClasses = Collections.emptySet();
            appClass = null;
        } else {
            applicationPaths = index.getAnnotations(ResteasyDotNames.APPLICATION_PATH);
            allowedClasses = ResteasyServerCommonProcessor.getAllowedClasses(index);
            jaxrsProvidersToRegisterBuildItem = ResteasyServerCommonProcessor.getFilteredJaxrsProvidersToRegisterBuildItem(jaxrsProvidersToRegisterBuildItem, allowedClasses, excludedClasses);
            Collection knownApplications = index.getAllKnownSubclasses(ResteasyDotNames.APPLICATION);
            appClass = knownApplications.size() == 1 ? ((ClassInfo)knownApplications.iterator().next()).name().toString() : null;
        }
        boolean bl = filterClasses = !allowedClasses.isEmpty() || !excludedClasses.isEmpty();
        if (applicationPaths.size() > 1) {
            throw ResteasyServerCommonProcessor.createMultipleApplicationsException(applicationPaths);
        }
        HashSet additionalPaths = new HashSet();
        for (AdditionalJaxRsResourceDefiningAnnotationBuildItem annotation : additionalJaxRsResourceDefiningAnnotations) {
            additionalPaths.addAll(beanArchiveIndexBuildItem.getIndex().getAnnotations(annotation.getAnnotationClass()));
        }
        Collection paths = beanArchiveIndexBuildItem.getIndex().getAnnotations(ResteasyDotNames.PATH);
        Collection allPaths = filterClasses ? (Collection)paths.stream().filter(annotationInstance -> ResteasyServerCommonProcessor.keepAnnotation(beanArchiveIndexBuildItem.getIndex(), allowedClasses, excludedClasses, annotationInstance)).collect(Collectors.toList()) : new ArrayList(paths);
        allPaths.addAll(additionalPaths);
        if (allPaths.isEmpty()) {
            return;
        }
        if (!applicationPaths.isEmpty()) {
            AnnotationInstance applicationPath = (AnnotationInstance)applicationPaths.iterator().next();
            rootPath = "/";
            path = Encode.decode((String)applicationPath.value().asString());
        } else if (resteasyServletMappingBuildItem.isPresent()) {
            rootPath = resteasyServletMappingBuildItem.get().getPath().endsWith("/*") ? resteasyServletMappingBuildItem.get().getPath().substring(0, resteasyServletMappingBuildItem.get().getPath().length() - 1) : resteasyServletMappingBuildItem.get().getPath();
            path = rootPath;
        } else {
            rootPath = this.resteasyConfig.path;
            path = this.resteasyConfig.path;
        }
        HashMap<DotName, ClassInfo> scannedResources = new HashMap<DotName, ClassInfo>();
        HashSet<DotName> pathInterfaces = new HashSet<DotName>();
        HashSet<DotName> pathAbstract = new HashSet<DotName>();
        HashMap<DotName, ClassInfo> withoutDefaultCtor = new HashMap<DotName, ClassInfo>();
        for (AnnotationInstance annotationInstance2 : allPaths) {
            if (annotationInstance2.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo clazz = annotationInstance2.target().asClass();
            if (!Modifier.isInterface(clazz.flags())) {
                if (withoutDefaultCtor.containsKey(clazz.name())) continue;
                Iterator<ResteasyDeploymentCustomizerBuildItem> className2 = clazz.name().toString();
                if (!additionalPaths.contains(annotationInstance2)) {
                    if (Modifier.isAbstract(clazz.flags())) {
                        pathAbstract.add(clazz.name());
                    } else {
                        scannedResources.putIfAbsent(clazz.name(), clazz);
                    }
                }
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className2}).methods().fields().build());
                if (clazz.hasNoArgsConstructor()) continue;
                withoutDefaultCtor.put(clazz.name(), clazz);
                continue;
            }
            pathInterfaces.add(clazz.name());
        }
        for (DotName dotName : pathInterfaces) {
            implementors = index.getAllKnownImplementors(dotName);
            for (ClassInfo implementor : implementors) {
                className = implementor.name().toString();
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className}).methods().fields().build());
                scannedResources.putIfAbsent(implementor.name(), implementor);
                if (implementor.hasNoArgsConstructor()) continue;
                withoutDefaultCtor.put(implementor.name(), implementor);
            }
        }
        for (DotName dotName : pathAbstract) {
            implementors = index.getAllKnownSubclasses(dotName);
            for (ClassInfo implementor : implementors) {
                className = implementor.name().toString();
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className}).methods().fields().build());
                if (!Modifier.isAbstract(implementor.flags())) {
                    scannedResources.putIfAbsent(implementor.name(), implementor);
                }
                if (implementor.hasNoArgsConstructor()) continue;
                withoutDefaultCtor.put(implementor.name(), implementor);
            }
        }
        for (String string : jaxrsProvidersToRegisterBuildItem.getAnnotatedProviders()) {
            ClassInfo info = index.getClassByName(DotName.createSimple((String)string));
            if (info == null || info.hasNoArgsConstructor()) continue;
            withoutDefaultCtor.put(info.name(), info);
        }
        final Set<DotName> subresources = this.findSubresources(beanArchiveIndexBuildItem.getIndex(), scannedResources);
        if (!subresources.isEmpty()) {
            for (DotName locator : subresources) {
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{locator.toString()}).methods().fields().build());
            }
            unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNamesExclusion(subresources.stream().map(Object::toString).collect(Collectors.toSet()))));
        }
        ResteasyServerCommonProcessor.generateDefaultConstructors(transformers, withoutDefaultCtor, additionalJaxRsResourceDefiningAnnotations, friendlyJaxRsAnnotationPrefixes);
        ResteasyServerCommonProcessor.checkParameterNames(beanArchiveIndexBuildItem.getIndex(), additionalJaxRsResourceMethodParamAnnotations);
        ResteasyServerCommonProcessor.registerContextProxyDefinitions(beanArchiveIndexBuildItem.getIndex(), proxyDefinition);
        ResteasyServerCommonProcessor.registerReflectionForSerialization(reflectiveClass, reflectiveHierarchy, combinedIndexBuildItem, beanArchiveIndexBuildItem, additionalJaxRsResourceMethodAnnotations);
        for (ClassInfo implementation : index.getAllKnownImplementors(ResteasyDotNames.DYNAMIC_FEATURE)) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{implementation.name().toString()}).build());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        QuarkusResteasyDeployment deployment = new QuarkusResteasyDeployment();
        ResteasyServerCommonProcessor.registerProviders((ResteasyDeployment)deployment, hashMap, reflectiveClass, unremovableBeans, jaxrsProvidersToRegisterBuildItem, index);
        if (!scannedResources.isEmpty()) {
            deployment.getScannedResourceClasses().addAll(scannedResources.keySet().stream().map(Object::toString).collect(Collectors.toList()));
            hashMap.put("resteasy.scanned.resources", scannedResources.keySet().stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        hashMap.put("resteasy.servlet.mapping.prefix", path);
        if (appClass != null) {
            deployment.setApplicationClass(appClass);
            hashMap.put(JAX_RS_APPLICATION_PARAMETER_NAME, appClass);
        }
        hashMap.put("resteasy.injector.factory", QuarkusInjectorFactory.class.getName());
        deployment.setInjectorFactoryClass(QuarkusInjectorFactory.class.getName());
        for (ResteasyDeploymentCustomizerBuildItem deploymentCustomizer : deploymentCustomizers) {
            deploymentCustomizer.getConsumer().accept((ResteasyDeployment)deployment);
        }
        if (this.commonConfig.gzip.enabled) {
            hashMap.put("resteasy.gzip.max.input", Long.toString(this.commonConfig.gzip.maxInput.asLongValue()));
        }
        hashMap.put("resteasy.unwrapped.exceptions", ArcUndeclaredThrowableException.class.getName());
        resteasyServerConfig.produce((BuildItem)new ResteasyServerConfigBuildItem(rootPath, path, hashMap));
        final Set<DotName> restConstructorAnnotations = Set.of(ResteasyDotNames.CONTEXT, ResteasyDotNames.PATH_PARAM, ResteasyDotNames.QUERY_PARAM, ResteasyDotNames.HEADER_PARAM, ResteasyDotNames.FORM_PARAM, ResteasyDotNames.MATRIX_PARAM, ResteasyDotNames.COOKIE_PARAM);
        final Set autoInjectAnnotationNames = autoInjectAnnotations.stream().flatMap(a -> a.getAnnotationNames().stream()).collect(Collectors.toSet());
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo clazz = context.getTarget().asClass();
                if (clazz.declaredAnnotation(ResteasyDotNames.PATH) != null) {
                    Transformation transformation = context.transform();
                    if (clazz.declaredAnnotation(DotNames.TYPED) == null) {
                        transformation.add(ResteasyServerCommonProcessor.this.createTypedAnnotationInstance(clazz));
                    }
                    boolean restConstructorFound = false;
                    block0: for (MethodInfo constructor : clazz.constructors()) {
                        for (MethodParameterInfo parameter : constructor.parameters()) {
                            for (DotName paramAnnotation : restConstructorAnnotations) {
                                if (!parameter.hasAnnotation(paramAnnotation)) continue;
                                restConstructorFound = true;
                                break block0;
                            }
                        }
                    }
                    if (restConstructorFound) {
                        log.debug((Object)("Resource " + clazz.name() + " will not be considered a CDI bean because it has Jakarta REST annotations on its constructor parameters"));
                        transformation.add(DotNames.VETOED, new AnnotationValue[0]);
                    }
                    transformation.done();
                    return;
                }
                if (scopes.isScopeIn(context.getAnnotations())) {
                    return;
                }
                if (clazz.declaredAnnotation(ResteasyDotNames.PROVIDER) != null) {
                    Transformation transformation = null;
                    if (clazz.annotationsMap().containsKey(DotNames.INJECT) || ResteasyServerCommonProcessor.this.hasAutoInjectAnnotation(autoInjectAnnotationNames, clazz)) {
                        transformation = (Transformation)context.transform().add(BuiltinScope.SINGLETON.getName(), new AnnotationValue[0]);
                    }
                    if (clazz.declaredAnnotation(DotNames.TYPED) == null) {
                        if (transformation == null) {
                            transformation = context.transform();
                        }
                        transformation.add(ResteasyServerCommonProcessor.this.createTypedAnnotationInstance(clazz));
                    }
                    if (transformation != null) {
                        transformation.done();
                    }
                } else if (subresources.contains(clazz.name())) {
                    Transformation transformation = (Transformation)context.transform().add(ResteasyServerCommonProcessor.this.resteasyConfig.singletonResources ? BuiltinScope.SINGLETON.getName() : BuiltinScope.DEPENDENT.getName(), new AnnotationValue[0]);
                    if (clazz.declaredAnnotation(DotNames.TYPED) == null) {
                        transformation.add(ResteasyServerCommonProcessor.this.createTypedAnnotationInstance(clazz));
                    }
                    if (!clazz.hasNoArgsConstructor()) {
                        boolean hasInject = false;
                        for (MethodInfo constructor : clazz.constructors()) {
                            if (!constructor.hasAnnotation(DotNames.INJECT)) continue;
                            hasInject = true;
                            break;
                        }
                        if (!hasInject) {
                            transformation.add(DotNames.VETOED, new AnnotationValue[0]);
                        }
                    }
                    transformation.done();
                }
            }
        }));
        resteasyDeployment.produce((BuildItem)new ResteasyDeploymentBuildItem(path, (ResteasyDeployment)deployment));
    }

    @BuildStep
    List<AllowedJaxRsAnnotationPrefixBuildItem> registerCompatibleAnnotationPrefixes() {
        ArrayList<AllowedJaxRsAnnotationPrefixBuildItem> prefixes = new ArrayList<AllowedJaxRsAnnotationPrefixBuildItem>();
        prefixes.add(new AllowedJaxRsAnnotationPrefixBuildItem(ResteasyServerCommonProcessor.packageName(ResteasyDotNames.PATH)));
        prefixes.add(new AllowedJaxRsAnnotationPrefixBuildItem("kotlin"));
        prefixes.add(new AllowedJaxRsAnnotationPrefixBuildItem("lombok"));
        prefixes.add(new AllowedJaxRsAnnotationPrefixBuildItem("io.quarkus.security"));
        prefixes.add(new AllowedJaxRsAnnotationPrefixBuildItem("jakarta.annotation.security"));
        prefixes.add(new AllowedJaxRsAnnotationPrefixBuildItem("jakarta.annotation.security"));
        prefixes.add(new AllowedJaxRsAnnotationPrefixBuildItem("java.lang"));
        prefixes.add(new AllowedJaxRsAnnotationPrefixBuildItem("jakarta.inject"));
        return prefixes;
    }

    @BuildStep
    void processPathInterfaceImplementors(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<AdditionalBeanBuildItem> additionalBeans, CustomScopeAnnotationsBuildItem scopes) {
        IndexView index = combinedIndexBuildItem.getIndex();
        HashSet<DotName> pathInterfaces = new HashSet<DotName>();
        for (Object annotation : index.getAnnotations(ResteasyDotNames.PATH)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS || !Modifier.isInterface(annotation.target().asClass().flags())) continue;
            pathInterfaces.add(annotation.target().asClass().name());
        }
        if (pathInterfaces.isEmpty()) {
            return;
        }
        HashMap<DotName, ClassInfo> pathInterfaceImplementors = new HashMap<DotName, ClassInfo>();
        for (DotName iface : pathInterfaces) {
            for (ClassInfo implementor : index.getAllKnownImplementors(iface)) {
                if (pathInterfaceImplementors.containsKey(implementor.name())) continue;
                pathInterfaceImplementors.put(implementor.name(), implementor);
            }
        }
        if (!pathInterfaceImplementors.isEmpty()) {
            AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setDefaultScope(this.resteasyConfig.singletonResources ? BuiltinScope.SINGLETON.getName() : null).setUnremovable();
            for (Map.Entry implementor : pathInterfaceImplementors.entrySet()) {
                if (scopes.isScopeDeclaredOn((ClassInfo)implementor.getValue())) {
                    unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNameExclusion(((DotName)implementor.getKey()).toString())));
                    continue;
                }
                builder.addBeanClass(((DotName)implementor.getKey()).toString());
            }
            additionalBeans.produce((BuildItem)builder.build());
        }
    }

    @BuildStep
    void beanDefiningAnnotations(BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ResteasyDotNames.PATH, this.resteasyConfig.singletonResources ? BuiltinScope.SINGLETON.getName() : null));
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ResteasyDotNames.APPLICATION_PATH, BuiltinScope.SINGLETON.getName()));
    }

    private boolean hasAutoInjectAnnotation(Set<DotName> autoInjectAnnotationNames, ClassInfo clazz) {
        for (DotName name : autoInjectAnnotationNames) {
            List instances = (List)clazz.annotationsMap().get(name);
            if (instances == null) continue;
            for (AnnotationInstance instance : instances) {
                if (instance.target().kind() != AnnotationTarget.Kind.FIELD) continue;
                return true;
            }
        }
        return false;
    }

    private AnnotationInstance createTypedAnnotationInstance(ClassInfo clazz) {
        return AnnotationInstance.create((DotName)DotNames.TYPED, (AnnotationTarget)clazz, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createClassValue((String)"value", (Type)Type.create((DotName)clazz.name(), (Type.Kind)Type.Kind.CLASS))})});
    }

    private Set<DotName> findSubresources(IndexView index, Map<DotName, ClassInfo> scannedResources) {
        HashSet<DotName> subresources = new HashSet<DotName>();
        for (DotName dotName : METHOD_ANNOTATIONS) {
            Collection annotationInstances = index.getAnnotations(dotName);
            for (Object annotationInstance : annotationInstances) {
                DotName declaringClassName = annotationInstance.target().asMethod().declaringClass().name();
                if (scannedResources.containsKey(declaringClassName)) continue;
                subresources.add(declaringClassName);
            }
        }
        if (!subresources.isEmpty()) {
            HashSet<DotName> subresourceLocatorTypes = new HashSet<DotName>();
            Iterator<ClassInfo> iterator = scannedResources.values().iterator();
            while (iterator.hasNext()) {
                ClassInfo resourceClass;
                ClassInfo clazz = resourceClass = iterator.next();
                while (clazz != null) {
                    for (MethodInfo method : clazz.methods()) {
                        if (!method.hasAnnotation(ResteasyDotNames.PATH)) continue;
                        subresourceLocatorTypes.add(method.returnType().name());
                    }
                    if (clazz.superName().equals((Object)DotNames.OBJECT)) {
                        clazz = null;
                        continue;
                    }
                    clazz = index.getClassByName(clazz.superName());
                }
            }
            Iterator iterator2 = subresources.iterator();
            block5: while (iterator2.hasNext()) {
                DotName subresource = (DotName)iterator2.next();
                for (DotName type : subresourceLocatorTypes) {
                    if (subresource.equals((Object)type) || !index.getAllKnownSubclasses(type).stream().noneMatch(c -> c.name().equals((Object)subresource))) continue;
                    iterator2.remove();
                    continue block5;
                }
            }
        }
        log.trace((Object)("Sub-resources found: " + subresources));
        return subresources;
    }

    private static void registerProviders(ResteasyDeployment deployment, Map<String, String> resteasyInitParameters, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, JaxrsProvidersToRegisterBuildItem jaxrsProvidersToRegisterBuildItem, IndexView index) {
        if (jaxrsProvidersToRegisterBuildItem.useBuiltIn()) {
            resteasyInitParameters.put("resteasy.use.builtin.providers", "true");
            deployment.setRegisterBuiltin(true);
            if (!jaxrsProvidersToRegisterBuildItem.getContributedProviders().isEmpty()) {
                deployment.getProviderClasses().addAll(jaxrsProvidersToRegisterBuildItem.getContributedProviders());
                resteasyInitParameters.put("resteasy.providers", String.join((CharSequence)",", jaxrsProvidersToRegisterBuildItem.getContributedProviders()));
            }
        } else {
            deployment.setRegisterBuiltin(false);
            deployment.getProviderClasses().addAll(jaxrsProvidersToRegisterBuildItem.getProviders());
            resteasyInitParameters.put("resteasy.use.builtin.providers", "false");
            resteasyInitParameters.put("resteasy.providers", String.join((CharSequence)",", jaxrsProvidersToRegisterBuildItem.getProviders()));
        }
        for (String providerToRegister : jaxrsProvidersToRegisterBuildItem.getProviders()) {
            ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)providerToRegister));
            boolean includeFields = false;
            if (classInfo != null) {
                includeFields = classInfo.annotationsMap().containsKey(ResteasyDotNames.CONTEXT);
            }
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, includeFields, new String[]{providerToRegister}));
        }
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{ServletConfigSource.class, ServletContextConfigSource.class, FilterConfigSource.class}).build());
    }

    private static void generateDefaultConstructors(BuildProducer<BytecodeTransformerBuildItem> transformers, Map<DotName, ClassInfo> withoutDefaultCtor, List<AdditionalJaxRsResourceDefiningAnnotationBuildItem> additionalJaxRsResourceDefiningAnnotations, List<AllowedJaxRsAnnotationPrefixBuildItem> friendlyJaxRsAnnotationPrefixes) {
        HashSet<String> allowedAnnotationPrefixes = new HashSet<String>(1 + additionalJaxRsResourceDefiningAnnotations.size());
        friendlyJaxRsAnnotationPrefixes.stream().map(prefix -> prefix.getAnnotationPrefix()).forEachOrdered(allowedAnnotationPrefixes::add);
        for (AdditionalJaxRsResourceDefiningAnnotationBuildItem additionalJaxRsResourceDefiningAnnotationBuildItem : additionalJaxRsResourceDefiningAnnotations) {
            String packageName = ResteasyServerCommonProcessor.packageName(additionalJaxRsResourceDefiningAnnotationBuildItem.getAnnotationClass());
            if (packageName == null) continue;
            allowedAnnotationPrefixes.add(packageName);
        }
        for (Map.Entry entry : withoutDefaultCtor.entrySet()) {
            ClassInfo classInfo = (ClassInfo)entry.getValue();
            if (classInfo.superClassType() == null || !classInfo.superClassType().name().equals((Object)DotNames.OBJECT)) {
                return;
            }
            boolean hasNonJaxRSAnnotations = false;
            for (AnnotationInstance instance : classInfo.declaredAnnotations()) {
                DotName name = instance.name();
                String packageName = ResteasyServerCommonProcessor.packageName(name);
                if (packageName != null && ResteasyServerCommonProcessor.isPackageAllowed(allowedAnnotationPrefixes, packageName)) continue;
                log.debug((Object)("Annotation " + name + " results in Quarkus not being able to generate a default constructor for " + classInfo.name()));
                hasNonJaxRSAnnotations = true;
                break;
            }
            if (hasNonJaxRSAnnotations) continue;
            String name = classInfo.name().toString();
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(name, (BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

                @Override
                public ClassVisitor apply(String className, ClassVisitor classVisitor) {
                    ClassVisitor cv = new ClassVisitor(589824, classVisitor){

                        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                            super.visit(version, access, name, signature, superName, interfaces);
                            MethodVisitor ctor = this.visitMethod(4097, "<init>", "()V", null, null);
                            ctor.visitCode();
                            ctor.visitVarInsn(25, 0);
                            ctor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
                            ctor.visitInsn(177);
                            ctor.visitMaxs(1, 1);
                            ctor.visitEnd();
                        }
                    };
                    return cv;
                }
            }));
        }
    }

    private static boolean isPackageAllowed(Set<String> allowedAnnotationPrefixes, String packageName) {
        return allowedAnnotationPrefixes.stream().anyMatch(prefix -> packageName.startsWith((String)prefix));
    }

    private static String packageName(DotName dotName) {
        String className = dotName.toString();
        int index = className.lastIndexOf(46);
        if (index > 0 && index < className.length() - 1) {
            return className.substring(0, index);
        }
        return null;
    }

    private static void checkParameterNames(IndexView index, List<AdditionalJaxRsResourceMethodParamAnnotations> additionalJaxRsResourceMethodParamAnnotations) {
        ArrayList<DotName> methodParameterAnnotations = new ArrayList<DotName>(RESTEASY_PARAM_ANNOTATIONS.size() + additionalJaxRsResourceMethodParamAnnotations.size());
        methodParameterAnnotations.addAll(RESTEASY_PARAM_ANNOTATIONS);
        for (AdditionalJaxRsResourceMethodParamAnnotations annotations : additionalJaxRsResourceMethodParamAnnotations) {
            methodParameterAnnotations.addAll(annotations.getAnnotationClasses());
        }
        block1: for (DotName annotationType : methodParameterAnnotations) {
            Collection instances = index.getAnnotations(annotationType);
            for (AnnotationInstance instance : instances) {
                MethodParameterInfo param;
                if (instance.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || (param = instance.target().asMethodParameter()).name() != null) continue;
                log.warnv("Detected RESTEasy annotation {0} on method parameter {1}.{2} with no name. Either specify its name, or tell your compiler to enable debug info (-g) or parameter names (-parameters). This message is only logged for the first such parameter.", (Object)instance.name(), (Object)param.method().declaringClass(), (Object)param.method().name());
                break block1;
            }
        }
    }

    private static void registerContextProxyDefinitions(IndexView index, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinition) {
        for (AnnotationInstance annotation : index.getAnnotations(ResteasyDotNames.CONTEXT)) {
            Type annotatedType = null;
            if (annotation.target().kind() == AnnotationTarget.Kind.METHOD) {
                MethodInfo method = annotation.target().asMethod();
                if (method.parametersCount() == 1) {
                    annotatedType = method.parameterType(0);
                }
            } else if (annotation.target().kind() == AnnotationTarget.Kind.FIELD) {
                annotatedType = annotation.target().asField().type();
            } else if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                short pos = annotation.target().asMethodParameter().position();
                annotatedType = annotation.target().asMethodParameter().method().parameterType((int)pos);
            }
            if (annotatedType == null || annotatedType.kind() == Type.Kind.PRIMITIVE) continue;
            ClassInfo type = index.getClassByName(annotatedType.name());
            if (type != null) {
                if (!Modifier.isInterface(type.flags())) continue;
                proxyDefinition.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{type.toString()}));
                continue;
            }
            try {
                Class<?> typeClass = Class.forName(annotatedType.name().toString(), false, Thread.currentThread().getContextClassLoader());
                if (!typeClass.isInterface()) continue;
                proxyDefinition.produce((BuildItem)new NativeImageProxyDefinitionBuildItem(new String[]{annotatedType.name().toString()}));
            }
            catch (Exception exception) {}
        }
    }

    private static void registerReflectionForSerialization(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, CombinedIndexBuildItem combinedIndexBuildItem, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, List<AdditionalJaxRsResourceMethodAnnotationsBuildItem> additionalJaxRsResourceMethodAnnotations) {
        IndexView index = combinedIndexBuildItem.getIndex();
        IndexView beanArchiveIndex = beanArchiveIndexBuildItem.getIndex();
        for (AnnotationInstance annotation : index.getAnnotations(JSONB_ANNOTATION)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{annotation.target().asClass().name().toString()}).methods().fields().build());
        }
        ArrayList<DotName> annotations = new ArrayList<DotName>(METHOD_ANNOTATIONS.size() + additionalJaxRsResourceMethodAnnotations.size());
        annotations.addAll(METHOD_ANNOTATIONS);
        for (AdditionalJaxRsResourceMethodAnnotationsBuildItem additionalJaxRsResourceMethodAnnotation : additionalJaxRsResourceMethodAnnotations) {
            annotations.addAll(additionalJaxRsResourceMethodAnnotation.getAnnotationClasses());
        }
        for (DotName annotationType : annotations) {
            HashSet<AnnotationInstance> processedAnnotations = new HashSet<AnnotationInstance>();
            ResteasyServerCommonProcessor.scanMethods(annotationType, reflectiveHierarchy, beanArchiveIndex, processedAnnotations);
            ResteasyServerCommonProcessor.scanMethods(annotationType, reflectiveHierarchy, index, processedAnnotations);
        }
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{ViolationReport.class.getName()}).methods().fields().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{ResteasyConstraintViolation.class.getName()}).methods().fields().build());
    }

    private static void scanMethods(DotName annotationType, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, IndexView index, Set<AnnotationInstance> processedAnnotations) {
        Collection instances = index.getAnnotations(annotationType);
        for (AnnotationInstance instance : instances) {
            if (instance.target().kind() != AnnotationTarget.Kind.METHOD || processedAnnotations.contains(instance)) continue;
            processedAnnotations.add(instance);
            MethodInfo method = instance.target().asMethod();
            String source = ResteasyServerCommonProcessor.class.getSimpleName() + " > " + method.declaringClass() + "[" + method + "]";
            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(method.returnType()).index(index).ignoreTypePredicate((Predicate)ResteasyDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)ResteasyDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)ResteasyDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
            for (short i = 0; i < method.parametersCount(); i = (short)(i + 1)) {
                Type parameterType = method.parameterType((int)i);
                if (ResteasyServerCommonProcessor.hasAnnotation(method, i, ResteasyDotNames.CONTEXT)) continue;
                reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(parameterType).index(index).ignoreTypePredicate((Predicate)ResteasyDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)ResteasyDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)ResteasyDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
            }
        }
    }

    private static boolean hasAnnotation(MethodInfo method, short paramPosition, DotName annotation) {
        for (AnnotationInstance annotationInstance : method.annotations()) {
            AnnotationTarget target = annotationInstance.target();
            if (target == null || target.kind() != AnnotationTarget.Kind.METHOD_PARAMETER || target.asMethodParameter().position() != paramPosition || !annotationInstance.name().equals((Object)annotation)) continue;
            return true;
        }
        return false;
    }

    private static RuntimeException createMultipleApplicationsException(Collection<AnnotationInstance> applicationPaths) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (AnnotationInstance annotationInstance : applicationPaths) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(annotationInstance.target().asClass().name().toString());
        }
        return new RuntimeException("Multiple classes ( " + sb.toString() + ") have been annotated with @ApplicationPath which is currently not supported");
    }

    private static Set<String> getExcludedClasses(List<BuildTimeConditionBuildItem> buildTimeConditions) {
        return buildTimeConditions.stream().filter(item -> !item.isEnabled()).map(BuildTimeConditionBuildItem::getTarget).filter(target -> target.kind() == AnnotationTarget.Kind.CLASS).map(target -> target.asClass().toString()).collect(Collectors.toSet());
    }

    private static boolean keepAnnotation(IndexView index, Set<String> allowedClasses, Set<String> excludedClasses, AnnotationInstance annotationInstance) {
        ClassInfo classInfo = JandexUtil.getEnclosingClass((AnnotationInstance)annotationInstance);
        String className = classInfo.toString();
        if (allowedClasses.isEmpty()) {
            return !excludedClasses.contains(className);
        }
        if (Modifier.isAbstract(classInfo.flags())) {
            return (Modifier.isInterface(classInfo.flags()) ? index.getAllKnownImplementors(classInfo.name()) : index.getAllKnownSubclasses(classInfo.name())).stream().filter(clazz -> !Modifier.isAbstract(clazz.flags())).map(Objects::toString).anyMatch(allowedClasses::contains);
        }
        return allowedClasses.contains(className);
    }

    private static JaxrsProvidersToRegisterBuildItem getFilteredJaxrsProvidersToRegisterBuildItem(JaxrsProvidersToRegisterBuildItem jaxrsProvidersToRegisterBuildItem, Set<String> allowedClasses, Set<String> excludedClasses) {
        if (allowedClasses.isEmpty() && excludedClasses.isEmpty()) {
            return jaxrsProvidersToRegisterBuildItem;
        }
        HashSet providers = new HashSet(jaxrsProvidersToRegisterBuildItem.getProviders());
        HashSet contributedProviders = new HashSet(jaxrsProvidersToRegisterBuildItem.getContributedProviders());
        HashSet annotatedProviders = new HashSet(jaxrsProvidersToRegisterBuildItem.getAnnotatedProviders());
        providers.removeAll(annotatedProviders);
        contributedProviders.removeAll(annotatedProviders);
        if (allowedClasses.isEmpty()) {
            annotatedProviders.removeAll(excludedClasses);
        } else {
            annotatedProviders.retainAll(allowedClasses);
        }
        providers.addAll(annotatedProviders);
        contributedProviders.addAll(annotatedProviders);
        return new JaxrsProvidersToRegisterBuildItem(providers, contributedProviders, annotatedProviders, jaxrsProvidersToRegisterBuildItem.useBuiltIn());
    }

    private static Set<String> getAllowedClasses(IndexView index) {
        Collection applications = index.getAllKnownSubclasses(ResteasyDotNames.APPLICATION);
        HashSet<String> allowedClasses = new HashSet<String>();
        ClassInfo selectedAppClass = null;
        for (ClassInfo applicationClassInfo : applications) {
            if (Modifier.isAbstract(applicationClassInfo.flags())) continue;
            if (selectedAppClass != null) {
                throw new RuntimeException("More than one Application class: " + applications);
            }
            selectedAppClass = applicationClassInfo;
            if (selectedAppClass.annotationsMap().containsKey(ResteasyDotNames.CDI_INJECT)) {
                throw new RuntimeException("Usage of '@Inject' is not allowed in 'jakarta.ws.rs.core.Application' classes. Offending class is '" + selectedAppClass.name() + "'");
            }
            String applicationClass = applicationClassInfo.name().toString();
            try {
                Class<?> appClass = Thread.currentThread().getContextClassLoader().loadClass(applicationClass);
                Application application = (Application)appClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Set classes = application.getClasses();
                if (!classes.isEmpty()) {
                    for (Class klass : classes) {
                        allowedClasses.add(klass.getName());
                    }
                }
                if ((classes = application.getSingletons().stream().map(Object::getClass).collect(Collectors.toSet())).isEmpty()) continue;
                for (Class klass : classes) {
                    allowedClasses.add(klass.getName());
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Unable to handle class: " + applicationClass, e);
            }
        }
        return allowedClasses;
    }

    @ConfigRoot(phase=ConfigPhase.BUILD_TIME)
    static final class ResteasyConfig {
        @ConfigItem(defaultValue="true")
        boolean singletonResources;
        @ConfigItem(defaultValue="/")
        @ConvertWith(value=NormalizeRootHttpPathConverter.class)
        String path;
        @Deprecated(forRemoval=true)
        @ConfigItem(name="metrics.enabled")
        public Optional<Boolean> metricsEnabled;
        @ConfigItem(defaultValue="false")
        boolean ignoreApplicationClasses;
        @ConfigItem(defaultValue="true")
        boolean buildTimeConditionAware;

        ResteasyConfig() {
        }
    }
}

