/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ProxyUnwrapperBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateConfigBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.resteasy.deployment.ResteasyJaxrsConfig;
import io.quarkus.resteasy.deployment.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.runtime.QuarkusInjectorFactory;
import io.quarkus.resteasy.runtime.ResteasyFilter;
import io.quarkus.resteasy.runtime.ResteasyTemplate;
import io.quarkus.resteasy.runtime.RolesFilterRegistrar;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.undertow.deployment.FilterBuildItem;
import io.quarkus.undertow.deployment.ServletBuildItem;
import io.quarkus.undertow.deployment.ServletInitParamBuildItem;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.servlet.DispatcherType;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.jboss.builder.item.BuildItem;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.jaxrs.CookieParam;
import org.jboss.resteasy.annotations.jaxrs.FormParam;
import org.jboss.resteasy.annotations.jaxrs.HeaderParam;
import org.jboss.resteasy.annotations.jaxrs.MatrixParam;
import org.jboss.resteasy.annotations.jaxrs.PathParam;
import org.jboss.resteasy.annotations.jaxrs.QueryParam;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.ViolationReport;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.plugins.interceptors.AcceptEncodingGZIPFilter;
import org.jboss.resteasy.plugins.interceptors.GZIPDecodingInterceptor;
import org.jboss.resteasy.plugins.interceptors.GZIPEncodingInterceptor;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;

public class ResteasyScanningProcessor {
    private static final String JAVAX_WS_RS_APPLICATION = "javax.ws.rs.Application";
    private static final String JAX_RS_FILTER_NAME = "javax.ws.rs.Application";
    private static final String JAX_RS_SERVLET_NAME = "javax.ws.rs.Application";
    private static final String JAX_RS_APPLICATION_PARAMETER_NAME = "javax.ws.rs.Application";
    private static final DotName APPLICATION_PATH = DotName.createSimple((String)ApplicationPath.class.getName());
    private static final DotName PATH = DotName.createSimple((String)Path.class.getName());
    private static final DotName PROVIDER = DotName.createSimple((String)Provider.class.getName());
    private static final DotName DYNAMIC_FEATURE = DotName.createSimple((String)DynamicFeature.class.getName());
    private static final DotName CONTEXT = DotName.createSimple((String)Context.class.getName());
    private static final DotName GET = DotName.createSimple((String)GET.class.getName());
    private static final DotName HEAD = DotName.createSimple((String)HEAD.class.getName());
    private static final DotName DELETE = DotName.createSimple((String)DELETE.class.getName());
    private static final DotName OPTIONS = DotName.createSimple((String)OPTIONS.class.getName());
    private static final DotName PATCH = DotName.createSimple((String)PATCH.class.getName());
    private static final DotName POST = DotName.createSimple((String)POST.class.getName());
    private static final DotName PUT = DotName.createSimple((String)PUT.class.getName());
    private static final DotName CONSUMES = DotName.createSimple((String)Consumes.class.getName());
    private static final DotName PRODUCES = DotName.createSimple((String)Produces.class.getName());
    private static final DotName RESTEASY_QUERY_PARAM = DotName.createSimple((String)QueryParam.class.getName());
    private static final DotName RESTEASY_FORM_PARAM = DotName.createSimple((String)FormParam.class.getName());
    private static final DotName RESTEASY_COOKIE_PARAM = DotName.createSimple((String)CookieParam.class.getName());
    private static final DotName RESTEASY_PATH_PARAM = DotName.createSimple((String)PathParam.class.getName());
    private static final DotName RESTEASY_HEADER_PARAM = DotName.createSimple((String)HeaderParam.class.getName());
    private static final DotName RESTEASY_MATRIX_PARAM = DotName.createSimple((String)MatrixParam.class.getName());
    private static final DotName JSONB_ANNOTATION = DotName.createSimple((String)"javax.json.bind.annotation.JsonbAnnotation");
    private static final Set<DotName> TYPES_IGNORED_FOR_REFLECTION = new HashSet<DotName>(Arrays.asList(DotName.createSimple((String)"javax.json.JsonObject"), DotName.createSimple((String)"javax.json.JsonArray"), DotName.createSimple((String)"javax.ws.rs.core.Response")));
    private static final DotName[] METHOD_ANNOTATIONS = new DotName[]{GET, HEAD, DELETE, OPTIONS, PATCH, POST, PUT};
    private static final DotName[] RESTEASY_PARAM_ANNOTATIONS = new DotName[]{RESTEASY_QUERY_PARAM, RESTEASY_FORM_PARAM, RESTEASY_COOKIE_PARAM, RESTEASY_PATH_PARAM, RESTEASY_HEADER_PARAM, RESTEASY_MATRIX_PARAM};
    private static final ProviderDiscoverer[] PROVIDER_DISCOVERERS = new ProviderDiscoverer[]{new ProviderDiscoverer(GET, false, true), new ProviderDiscoverer(HEAD, false, false), new ProviderDiscoverer(DELETE, true, false), new ProviderDiscoverer(OPTIONS, false, true), new ProviderDiscoverer(PATCH, true, false), new ProviderDiscoverer(POST, true, true), new ProviderDiscoverer(PUT, true, false)};
    private static final DotName SINGLETON_SCOPE = DotName.createSimple((String)Singleton.class.getName());
    ResteasyConfig resteasyConfig;
    private static final Logger log = Logger.getLogger((String)"io.quarkus.resteasy");

    @BuildStep
    ResteasyJaxrsConfig exportConfig() {
        return new ResteasyJaxrsConfig(this.resteasyConfig.path);
    }

    @BuildStep
    SubstrateConfigBuildItem config() {
        return SubstrateConfigBuildItem.builder().addResourceBundle("messages").build();
    }

    @BuildStep
    void scanForProviders(BuildProducer<ResteasyJaxrsProviderBuildItem> providers, CombinedIndexBuildItem indexBuildItem) {
        for (AnnotationInstance i : indexBuildItem.getIndex().getAnnotations(PROVIDER)) {
            if (i.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(i.target().asClass().name().toString()));
        }
    }

    @BuildStep
    public void build(BuildProducer<FeatureBuildItem> feature, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<SubstrateProxyDefinitionBuildItem> proxyDefinition, BuildProducer<SubstrateResourceBuildItem> resource, BuildProducer<RuntimeInitializedClassBuildItem> runtimeClasses, BuildProducer<FilterBuildItem> filterProducer, BuildProducer<ServletBuildItem> servletProducer, BuildProducer<ServletInitParamBuildItem> servletContextParams, CombinedIndexBuildItem combinedIndexBuildItem) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem("resteasy"));
        IndexView index = combinedIndexBuildItem.getIndex();
        resource.produce((BuildItem)new SubstrateResourceBuildItem(new String[]{"META-INF/services/javax.ws.rs.client.ClientBuilder"}));
        Collection app = index.getAnnotations(APPLICATION_PATH);
        for (AnnotationInstance annotation : index.getAnnotations(CONTEXT)) {
            DotName typeName = null;
            if (annotation.target().kind() == AnnotationTarget.Kind.METHOD) {
                MethodInfo method = annotation.target().asMethod();
                if (method.parameters().size() == 1) {
                    typeName = ((Type)method.parameters().get(0)).name();
                }
            } else if (annotation.target().kind() == AnnotationTarget.Kind.FIELD) {
                typeName = annotation.target().asField().type().name();
            } else if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                short pos = annotation.target().asMethodParameter().position();
                typeName = ((Type)annotation.target().asMethodParameter().method().parameters().get(pos)).name();
            }
            if (typeName == null) continue;
            ClassInfo type = index.getClassByName(typeName);
            if (type != null) {
                if (!Modifier.isInterface(type.flags())) continue;
                proxyDefinition.produce((BuildItem)new SubstrateProxyDefinitionBuildItem(new String[]{type.toString()}));
                continue;
            }
            try {
                Class<?> typeClass = Class.forName(typeName.toString());
                if (!typeClass.isInterface()) continue;
                proxyDefinition.produce((BuildItem)new SubstrateProxyDefinitionBuildItem(new String[]{typeName.toString()}));
            }
            catch (Exception typeClass) {}
        }
        for (ClassInfo implementation : index.getAllKnownImplementors(DYNAMIC_FEATURE)) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{implementation.name().toString()}));
        }
        if (app.size() > 1) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (AnnotationInstance annotationInstance : app) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(annotationInstance.target().asClass().name().toString());
            }
            throw new RuntimeException("Multiple classes ( " + sb.toString() + ") have been annotated with @ApplicationPath which is currently not supported");
        }
        String path = null;
        String appClass = null;
        if (!app.isEmpty()) {
            AnnotationInstance appPath = (AnnotationInstance)app.iterator().next();
            path = appPath.value().asString();
            appClass = appPath.target().asClass().name().toString();
        } else {
            path = this.resteasyConfig.path;
        }
        String mappingPath = path.endsWith("/") ? path + "*" : path + "/*";
        Collection paths = index.getAnnotations(PATH);
        if (paths != null && !paths.isEmpty()) {
            if (path.equals("/")) {
                filterProducer.produce((BuildItem)FilterBuildItem.builder((String)"javax.ws.rs.Application", (String)ResteasyFilter.class.getName()).setLoadOnStartup(1).addFilterServletNameMapping("default", DispatcherType.REQUEST).setAsyncSupported(true).build());
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ResteasyFilter.class.getName()}));
            } else {
                servletProducer.produce((BuildItem)ServletBuildItem.builder((String)"javax.ws.rs.Application", (String)HttpServlet30Dispatcher.class.getName()).setLoadOnStartup(1).addMapping(mappingPath).setAsyncSupported(true).build());
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{HttpServlet30Dispatcher.class.getName()}));
            }
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (AnnotationInstance annotation : paths) {
                ClassInfo clazz;
                if (annotation.target().kind() != AnnotationTarget.Kind.CLASS || Modifier.isInterface((clazz = annotation.target().asClass()).flags())) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                String className = clazz.name().toString();
                sb.append(className);
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{className}));
            }
            if (sb.length() > 0) {
                servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.scanned.resources", sb.toString()));
            }
            servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.servlet.mapping.prefix", path));
            if (appClass != null) {
                servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("javax.ws.rs.Application", appClass));
            }
        } else {
            return;
        }
        block6: for (DotName annotationType : RESTEASY_PARAM_ANNOTATIONS) {
            Collection instances = index.getAnnotations(annotationType);
            for (AnnotationInstance instance : instances) {
                MethodParameterInfo param = instance.target().asMethodParameter();
                if (param.name() != null) continue;
                log.warnv("Detected RESTEasy annotation {0} on method parameter {1}.{2} with no name. Either specify its name, or tell your compiler to enable debug info (-g) or parameter names (-parameters). This message is only logged for the first such parameter.", (Object)instance.name(), (Object)param.method().declaringClass(), (Object)param.method().name());
                break block6;
            }
        }
        this.registerReflectionForSerialization(reflectiveClass, reflectiveHierarchy, combinedIndexBuildItem);
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void registerProviders(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServletInitParamBuildItem> servletContextParams, CombinedIndexBuildItem combinedIndexBuildItem, List<ResteasyJaxrsProviderBuildItem> contributedProviderBuildItems) throws Exception {
        IndexView index = combinedIndexBuildItem.getIndex();
        HashSet<String> contributedProviders = new HashSet<String>();
        for (ResteasyJaxrsProviderBuildItem contributedProviderBuildItem : contributedProviderBuildItems) {
            contributedProviders.add(contributedProviderBuildItem.getName());
        }
        Set availableProviders = ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)("META-INF/services/" + Providers.class.getName()));
        MediaTypeMap categorizedReaders = new MediaTypeMap();
        MediaTypeMap categorizedWriters = new MediaTypeMap();
        MediaTypeMap categorizedContextResolvers = new MediaTypeMap();
        HashSet<String> otherProviders = new HashSet<String>();
        ResteasyScanningProcessor.categorizeProviders(availableProviders, (MediaTypeMap<String>)categorizedReaders, (MediaTypeMap<String>)categorizedWriters, (MediaTypeMap<String>)categorizedContextResolvers, otherProviders);
        HashSet<String> providersToRegister = new HashSet<String>();
        providersToRegister.addAll(otherProviders);
        boolean useBuiltinProviders = ResteasyScanningProcessor.collectDeclaredProviders(providersToRegister, (MediaTypeMap<String>)categorizedReaders, (MediaTypeMap<String>)categorizedWriters, (MediaTypeMap<String>)categorizedContextResolvers, index);
        if (this.resteasyConfig.enableGzip) {
            providersToRegister.add(AcceptEncodingGZIPFilter.class.getName());
            providersToRegister.add(GZIPDecodingInterceptor.class.getName());
            providersToRegister.add(GZIPEncodingInterceptor.class.getName());
        }
        if (useBuiltinProviders) {
            servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.use.builtin.providers", "true"));
            if (!contributedProviders.isEmpty()) {
                servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.providers", contributedProviders.stream().collect(Collectors.joining(","))));
            }
            providersToRegister = new HashSet(contributedProviders);
            providersToRegister.addAll(availableProviders);
        } else {
            providersToRegister.addAll(contributedProviders);
            servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.use.builtin.providers", "false"));
            servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.providers", providersToRegister.stream().collect(Collectors.joining(","))));
        }
        for (String providerToRegister : providersToRegister) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{providerToRegister}));
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void setupInjection(ResteasyTemplate template, BuildProducer<ServletInitParamBuildItem> servletContextParams, BeanContainerBuildItem beanContainerBuildItem, List<ProxyUnwrapperBuildItem> proxyUnwrappers) {
        ArrayList<Function> unwrappers = new ArrayList<Function>();
        for (ProxyUnwrapperBuildItem i : proxyUnwrappers) {
            unwrappers.add(i.getUnwrapper());
        }
        template.setupIntegration(beanContainerBuildItem.getValue(), unwrappers);
        servletContextParams.produce((BuildItem)new ServletInitParamBuildItem("resteasy.injector.factory", QuarkusInjectorFactory.class.getName()));
    }

    @BuildStep
    List<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations() {
        return Collections.singletonList(new BeanDefiningAnnotationBuildItem(PATH, (DotName)(this.resteasyConfig.singletonResources ? SINGLETON_SCOPE : null)));
    }

    @BuildStep
    void setupFilter(BuildProducer<ResteasyJaxrsProviderBuildItem> providers) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(RolesFilterRegistrar.class.getName()));
    }

    private void registerReflectionForSerialization(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, CombinedIndexBuildItem combinedIndexBuildItem) {
        IndexView index = combinedIndexBuildItem.getIndex();
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"org.glassfish.json.JsonProviderImpl"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector", "com.fasterxml.jackson.databind.ser.std.SqlDateSerializer"}));
        for (AnnotationInstance annotation : index.getAnnotations(JSONB_ANNOTATION)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{annotation.target().asClass().name().toString()}));
        }
        for (DotName annotationType : METHOD_ANNOTATIONS) {
            Collection instances = index.getAnnotations(annotationType);
            for (AnnotationInstance instance : instances) {
                MethodInfo method = instance.target().asMethod();
                if (ResteasyScanningProcessor.isReflectionDeclarationRequiredFor(method.returnType())) {
                    reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem(method.returnType()));
                }
                for (Type param : method.parameters()) {
                    if (!ResteasyScanningProcessor.isReflectionDeclarationRequiredFor(param)) continue;
                    reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem(param));
                }
            }
        }
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{ViolationReport.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{ResteasyConstraintViolation.class.getName()}));
    }

    private static void categorizeProviders(Set<String> availableProviders, MediaTypeMap<String> categorizedReaders, MediaTypeMap<String> categorizedWriters, MediaTypeMap<String> categorizedContextResolvers, Set<String> otherProviders) {
        for (String availableProvider : availableProviders) {
            try {
                Produces produces;
                Class<?> providerClass = Class.forName(availableProvider);
                if (MessageBodyReader.class.isAssignableFrom(providerClass) || MessageBodyWriter.class.isAssignableFrom(providerClass)) {
                    if (MessageBodyReader.class.isAssignableFrom(providerClass)) {
                        Consumes consumes = providerClass.getAnnotation(Consumes.class);
                        if (consumes != null) {
                            for (String consumesMediaType : consumes.value()) {
                                categorizedReaders.add(MediaType.valueOf((String)consumesMediaType), (Object)providerClass.getName());
                            }
                        } else {
                            categorizedReaders.add(MediaType.WILDCARD_TYPE, (Object)providerClass.getName());
                        }
                    }
                    if (!MessageBodyWriter.class.isAssignableFrom(providerClass)) continue;
                    produces = providerClass.getAnnotation(Produces.class);
                    if (produces != null) {
                        for (String producesMediaType : produces.value()) {
                            categorizedWriters.add(MediaType.valueOf((String)producesMediaType), (Object)providerClass.getName());
                        }
                        continue;
                    }
                    categorizedWriters.add(MediaType.WILDCARD_TYPE, (Object)providerClass.getName());
                    continue;
                }
                if (ContextResolver.class.isAssignableFrom(providerClass)) {
                    produces = providerClass.getAnnotation(Produces.class);
                    if (produces != null) {
                        for (String producesMediaType : produces.value()) {
                            categorizedContextResolvers.add(MediaType.valueOf((String)producesMediaType), (Object)providerClass.getName());
                        }
                        continue;
                    }
                    categorizedContextResolvers.add(MediaType.WILDCARD_TYPE, (Object)providerClass.getName());
                    continue;
                }
                otherProviders.add(providerClass.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    private static boolean collectDeclaredProviders(Set<String> providersToRegister, MediaTypeMap<String> categorizedReaders, MediaTypeMap<String> categorizedWriters, MediaTypeMap<String> categorizedContextResolvers, IndexView index) {
        for (ProviderDiscoverer providerDiscoverer : PROVIDER_DISCOVERERS) {
            Collection getMethods = index.getAnnotations(providerDiscoverer.getMethodAnnotation());
            for (AnnotationInstance getMethod : getMethods) {
                MethodInfo methodTarget = getMethod.target().asMethod();
                if (ResteasyScanningProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedReaders, methodTarget, CONSUMES, providerDiscoverer.noConsumesDefaultsToAll())) {
                    return true;
                }
                if (ResteasyScanningProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedWriters, methodTarget, PRODUCES, providerDiscoverer.noProducesDefaultsToAll())) {
                    return true;
                }
                if (!ResteasyScanningProcessor.collectDeclaredProvidersForMethodAndMediaTypeAnnotation(providersToRegister, categorizedContextResolvers, methodTarget, PRODUCES, providerDiscoverer.noProducesDefaultsToAll())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean collectDeclaredProvidersForMethodAndMediaTypeAnnotation(Set<String> providersToRegister, MediaTypeMap<String> categorizedProviders, MethodInfo methodTarget, DotName mediaTypeAnnotation, boolean defaultsToAll) {
        AnnotationInstance mediaTypeAnnotationInstance = methodTarget.annotation(mediaTypeAnnotation);
        if (mediaTypeAnnotationInstance == null) {
            Collection classAnnotations = methodTarget.declaringClass().classAnnotations();
            for (AnnotationInstance classAnnotation : classAnnotations) {
                if (!mediaTypeAnnotation.equals((Object)classAnnotation.name())) continue;
                return ResteasyScanningProcessor.collectDeclaredProvidersForMediaTypeAnnotationInstance(providersToRegister, categorizedProviders, classAnnotation);
            }
            return defaultsToAll;
        }
        return ResteasyScanningProcessor.collectDeclaredProvidersForMediaTypeAnnotationInstance(providersToRegister, categorizedProviders, mediaTypeAnnotationInstance);
    }

    private static boolean collectDeclaredProvidersForMediaTypeAnnotationInstance(Set<String> providersToRegister, MediaTypeMap<String> categorizedProviders, AnnotationInstance mediaTypeAnnotationInstance) {
        for (String media : mediaTypeAnnotationInstance.value().asStringArray()) {
            MediaType mediaType = MediaType.valueOf((String)media);
            if (MediaType.WILDCARD_TYPE.equals((Object)mediaType)) {
                return true;
            }
            providersToRegister.addAll(categorizedProviders.getPossible(mediaType));
        }
        return false;
    }

    private static boolean isReflectionDeclarationRequiredFor(Type type) {
        DotName className = ResteasyScanningProcessor.getClassName(type);
        return className != null && !TYPES_IGNORED_FOR_REFLECTION.contains(className);
    }

    private static DotName getClassName(Type type) {
        switch (type.kind()) {
            case CLASS: 
            case PARAMETERIZED_TYPE: {
                return type.name();
            }
            case ARRAY: {
                return ResteasyScanningProcessor.getClassName(type.asArrayType().component());
            }
        }
        return null;
    }

    private static class ProviderDiscoverer {
        private final DotName methodAnnotation;
        private final boolean noConsumesDefaultsToAll;
        private final boolean noProducesDefaultsToAll;

        private ProviderDiscoverer(DotName methodAnnotation, boolean noConsumesDefaultsToAll, boolean noProducesDefaultsToAll) {
            this.methodAnnotation = methodAnnotation;
            this.noConsumesDefaultsToAll = noConsumesDefaultsToAll;
            this.noProducesDefaultsToAll = noProducesDefaultsToAll;
        }

        public DotName getMethodAnnotation() {
            return this.methodAnnotation;
        }

        public boolean noConsumesDefaultsToAll() {
            return this.noConsumesDefaultsToAll;
        }

        public boolean noProducesDefaultsToAll() {
            return this.noProducesDefaultsToAll;
        }
    }

    @ConfigRoot
    static final class ResteasyConfig {
        @ConfigItem(defaultValue="true")
        boolean singletonResources;
        @ConfigItem
        boolean enableGzip;
        @ConfigItem(defaultValue="/")
        String path;

        ResteasyConfig() {
        }
    }
}

