/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.runtime.TemplateHtmlBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.request.ServerDrivenNegotiation;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceInvoker;

@Provider
@Priority(value=5001)
public class NotFoundExceptionMapper
implements ExceptionMapper<NotFoundException> {
    private static final Variant JSON_VARIANT = new Variant(MediaType.APPLICATION_JSON_TYPE, (String)null, null);
    private static final Variant HTML_VARIANT = new Variant(MediaType.TEXT_HTML_TYPE, (String)null, null);
    private static final List<Variant> VARIANTS = Arrays.asList(JSON_VARIANT, HTML_VARIANT);
    private static volatile List<String> servletMappings = Collections.EMPTY_LIST;
    private static volatile List<String> staticResources = Collections.EMPTY_LIST;
    @Context
    private Registry registry = null;
    @Context
    private HttpHeaders headers;

    public Response toResponse(NotFoundException exception) {
        if (this.registry == null) {
            return this.respond();
        }
        Map bounded = null;
        if (this.registry instanceof ResourceMethodRegistry) {
            bounded = ((ResourceMethodRegistry)this.registry).getBounded();
        } else if (Proxy.isProxyClass(this.registry.getClass()) && this.registry.toString().startsWith(ResourceMethodRegistry.class.getName())) {
            try {
                bounded = (Map)Proxy.getInvocationHandler(this.registry).invoke(this.registry, ResourceMethodRegistry.class.getMethod("getBounded", new Class[0]), new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (bounded == null) {
            return this.respond();
        }
        List<ResourceDescription> descriptions = ResourceDescription.fromBoundResourceInvokers(bounded.entrySet());
        return this.respond(descriptions);
    }

    private Response respond() {
        Variant variant = NotFoundExceptionMapper.selectVariant(this.headers);
        if (variant == JSON_VARIANT) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/json").build();
        }
        if (variant == HTML_VARIANT) {
            TemplateHtmlBuilder sb = new TemplateHtmlBuilder("404 - Resource Not Found", "", "No resources discovered");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)sb.toString()).type(MediaType.TEXT_HTML_TYPE).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private Response respond(List<ResourceDescription> descriptions) {
        Variant variant = NotFoundExceptionMapper.selectVariant(this.headers);
        if (variant == JSON_VARIANT) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/json").build();
        }
        if (variant == HTML_VARIANT) {
            TemplateHtmlBuilder sb = new TemplateHtmlBuilder("404 - Resource Not Found", "", "Resources overview");
            sb.resourcesStart("REST resources");
            for (ResourceDescription resource : descriptions) {
                sb.resourcePath(resource.basePath);
                for (MethodDescription method : resource.calls) {
                    sb.method(method.method, method.fullPath);
                    if (method.consumes != null) {
                        sb.consumes(method.consumes);
                    }
                    if (method.produces != null) {
                        sb.produces(method.produces);
                    }
                    sb.methodEnd();
                }
                sb.resourceEnd();
            }
            if (descriptions.isEmpty()) {
                sb.noResourcesFound();
            }
            sb.resourcesEnd();
            if (!servletMappings.isEmpty()) {
                sb.resourcesStart("Servlet mappings");
                for (String servletMapping : servletMappings) {
                    sb.servletMapping(servletMapping);
                }
                sb.resourcesEnd();
            }
            if (!staticResources.isEmpty()) {
                sb.resourcesStart("Static resources");
                for (String staticResource : staticResources) {
                    sb.staticResourcePath(staticResource);
                }
                sb.resourcesEnd();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)sb.toString()).type(MediaType.TEXT_HTML_TYPE).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private static Variant selectVariant(HttpHeaders headers) {
        ServerDrivenNegotiation negotiation = new ServerDrivenNegotiation();
        negotiation.setAcceptHeaders((List)headers.getRequestHeaders().get((Object)"Accept"));
        return negotiation.getBestMatch(VARIANTS);
    }

    public static void servlets(Map<String, List<String>> servletToMapping) {
        servletMappings = servletToMapping.values().stream().flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    public static void staticResources(Set<String> knownFiles) {
        staticResources = knownFiles.stream().sorted().collect(Collectors.toList());
    }

    public static final class ResourceDescription {
        public final String basePath;
        public final List<MethodDescription> calls;

        public ResourceDescription(String basePath) {
            this.basePath = basePath;
            this.calls = new ArrayList<MethodDescription>();
        }

        public void addMethod(String path, ResourceMethodInvoker method) {
            String produces = ResourceDescription.mostPreferredOrNull(method.getProduces());
            String consumes = ResourceDescription.mostPreferredOrNull(method.getConsumes());
            for (String verb : method.getHttpMethods()) {
                this.calls.add(new MethodDescription(verb, path, produces, consumes));
            }
        }

        private static String mostPreferredOrNull(MediaType[] mediaTypes) {
            if (mediaTypes == null || mediaTypes.length < 1) {
                return null;
            }
            return mediaTypes[0].toString();
        }

        public static List<ResourceDescription> fromBoundResourceInvokers(Set<Map.Entry<String, List<ResourceInvoker>>> bound) {
            HashMap<String, ResourceDescription> descriptions = new HashMap<String, ResourceDescription>();
            for (Map.Entry<String, List<ResourceInvoker>> entry : bound) {
                for (ResourceInvoker invoker : entry.getValue()) {
                    ResourceMethodInvoker method;
                    Class resourceClass;
                    Path path;
                    if (!(invoker instanceof ResourceMethodInvoker) || (path = (resourceClass = (method = (ResourceMethodInvoker)invoker).getResourceClass()).getAnnotation(Path.class)) == null) continue;
                    String basePath = path.value();
                    if (!descriptions.containsKey(basePath)) {
                        descriptions.put(basePath, new ResourceDescription(basePath));
                    }
                    String subPath = "";
                    for (Annotation annotation : method.getMethodAnnotations()) {
                        if (!annotation.annotationType().equals(Path.class)) continue;
                        subPath = ((Path)annotation).value();
                        break;
                    }
                    ((ResourceDescription)descriptions.get(basePath)).addMethod(basePath + subPath, method);
                }
            }
            return new LinkedList<ResourceDescription>(descriptions.values());
        }
    }

    public static final class MethodDescription {
        public String method;
        public String fullPath;
        public String produces;
        public String consumes;

        public MethodDescription(String method, String fullPath, String produces, String consumes) {
            this.method = method;
            this.fullPath = fullPath;
            this.produces = produces;
            this.consumes = consumes;
        }
    }
}

