/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.Method;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.ResteasyContext;

public class RequestFailer {
    private static final Class<?> HTTP_SERVLET_REQUEST;
    private static final Class<?> HTTP_SERVLET_RESPONSE;
    private static final Method AUTHENTICATE;

    public static void fail(ContainerRequestContext requestContext) {
        if (requestContext.getSecurityContext().getUserPrincipal() == null) {
            Object httpServletRequest;
            SecurityIdentity identity = CurrentIdentityAssociation.current();
            if (HTTP_SERVLET_REQUEST != null && (httpServletRequest = ResteasyContext.getContextData(HTTP_SERVLET_REQUEST)) != null) {
                Object httpServletResponse = ResteasyContext.getContextData(HTTP_SERVLET_RESPONSE);
                try {
                    AUTHENTICATE.invoke(httpServletRequest, httpServletResponse);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return;
            }
            HttpAuthenticator authenticator = (HttpAuthenticator)identity.getAttribute(HttpAuthenticator.class.getName());
            RoutingContext context = (RoutingContext)ResteasyContext.getContextData(RoutingContext.class);
            if (authenticator != null && context != null) {
                authenticator.sendChallenge(context, null);
            } else {
                RequestFailer.respond(requestContext, 401, "Not authorized");
            }
        } else {
            RequestFailer.respond(requestContext, 403, "Access forbidden: role not allowed");
        }
    }

    private static void respond(ContainerRequestContext context, int status, String message) {
        Response response = Response.status((int)status).entity((Object)message).type("text/html;charset=UTF-8").build();
        context.abortWith(response);
    }

    static {
        Class<?> httpServletReq = null;
        Class<?> httpServletResp = null;
        Method auth = null;
        try {
            httpServletReq = Class.forName("javax.servlet.http.HttpServletRequest");
            httpServletResp = Class.forName("javax.servlet.http.HttpServletResponse");
            auth = httpServletReq.getMethod("authenticate", httpServletResp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        AUTHENTICATE = auth;
        HTTP_SERVLET_REQUEST = httpServletReq;
        HTTP_SERVLET_RESPONSE = httpServletResp;
    }
}

