/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.resteasy.runtime.DenyAllFilter;
import io.quarkus.resteasy.runtime.RolesAllowedFilter;
import io.quarkus.security.Authenticated;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;

@Provider
public class RolesFilterRegistrar
implements DynamicFeature {
    private static final DenyAllFilter denyAllFilter = new DenyAllFilter();
    private final Set<Class<? extends Annotation>> securityAnnotations = new HashSet<Class>(Arrays.asList(DenyAll.class, PermitAll.class, RolesAllowed.class, Authenticated.class));

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Annotation securityAnnotation = this.getSecurityAnnotation(resourceInfo);
        if (securityAnnotation != null) {
            if (securityAnnotation instanceof DenyAll) {
                this.configureDenyAll(context);
            } else if (securityAnnotation instanceof RolesAllowed) {
                this.configureRolesAllowed((RolesAllowed)securityAnnotation, context);
            } else if (securityAnnotation instanceof Authenticated) {
                this.configureAuthenticated(context);
            }
        } else if (this.hasSecurityAnnotations(resourceInfo) && this.shouldNonAnnotatedMethodsBeDenied()) {
            this.configureDenyAll(context);
        }
    }

    private void configureRolesAllowed(RolesAllowed rolesAllowed, FeatureContext context) {
        context.register((Object)new RolesAllowedFilter(rolesAllowed.value()));
    }

    private void configureAuthenticated(FeatureContext context) {
        context.register((Object)new RolesAllowedFilter("*"));
    }

    private void configureDenyAll(FeatureContext context) {
        context.register((Object)denyAllFilter);
    }

    private Annotation getSecurityAnnotation(ResourceInfo resourceInfo) {
        Annotation annotation = this.getSecurityAnnotation(resourceInfo.getResourceMethod().getDeclaredAnnotations(), () -> resourceInfo.getResourceClass().getCanonicalName() + ":" + resourceInfo.getResourceMethod().getName());
        if (annotation == null) {
            annotation = this.getSecurityAnnotation(resourceInfo.getResourceMethod().getDeclaringClass().getDeclaredAnnotations(), () -> resourceInfo.getResourceClass().getCanonicalName());
        }
        return annotation;
    }

    private Annotation getSecurityAnnotation(Annotation[] declaredAnnotations, Supplier<String> annotationPlacementDescriptor) {
        List annotations = Stream.of(declaredAnnotations).filter(annotation -> this.securityAnnotations.contains(annotation.annotationType())).collect(Collectors.toList());
        switch (annotations.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Annotation)annotations.iterator().next();
            }
        }
        throw new RuntimeException("Duplicate MicroProfile JWT annotations found on " + annotationPlacementDescriptor.get() + ". Expected at most 1 annotation, found: " + annotations);
    }

    private boolean hasSecurityAnnotations(ResourceInfo resource) {
        return Stream.of(resource.getResourceClass().getMethods()).filter(this::isResourceMethod).anyMatch(this::hasSecurityAnnotations);
    }

    private boolean hasSecurityAnnotations(Method method) {
        return Stream.of(method.getAnnotations()).anyMatch(annotation -> this.securityAnnotations.contains(annotation.annotationType()));
    }

    private boolean isResourceMethod(Method method) {
        return Stream.of(method.getAnnotations()).anyMatch(annotation -> annotation.annotationType().getAnnotation(HttpMethod.class) != null);
    }

    private boolean shouldNonAnnotatedMethodsBeDenied() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL resource = loader.getResource("/META-INF/MP-JWT-DENY-NONANNOTATED-METHODS");
        return resource != null;
    }
}

