/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import javax.annotation.Priority;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.ResteasyContext;

@Provider
@Priority(value=5001)
public class UnauthorizedExceptionMapper
implements ExceptionMapper<UnauthorizedException> {
    private static final Logger log = Logger.getLogger((String)UnauthorizedExceptionMapper.class.getName());
    private static final Class<?> HTTP_SERVLET_REQUEST;
    private static final Class<?> HTTP_SERVLET_RESPONSE;
    private static final Method AUTHENTICATE;

    public Response toResponse(UnauthorizedException exception) {
        HttpAuthenticator authenticator;
        RoutingContext context;
        Object httpServletRequest;
        SecurityIdentity identity = CurrentIdentityAssociation.current();
        if (HTTP_SERVLET_REQUEST != null && (httpServletRequest = ResteasyContext.getContextData(HTTP_SERVLET_REQUEST)) != null) {
            Object httpServletResponse = ResteasyContext.getContextData(HTTP_SERVLET_RESPONSE);
            try {
                AUTHENTICATE.invoke(httpServletRequest, httpServletResponse);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((context = (RoutingContext)ResteasyContext.getContextData(RoutingContext.class)) != null && (authenticator = (HttpAuthenticator)context.get(HttpAuthenticator.class.getName())) != null) {
            try {
                ChallengeData challengeData = (ChallengeData)authenticator.getChallenge(context).toCompletableFuture().get();
                Response.ResponseBuilder status = Response.status((int)challengeData.status);
                if (challengeData.headerName != null) {
                    status.header(challengeData.headerName.toString(), (Object)challengeData.headerContent);
                }
                return status.build();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error((Object)"Failed to read challenge data for unauthorized response", (Throwable)e);
                return Response.status((int)401).entity((Object)"Not authorized").build();
            }
        }
        return Response.status((int)401).entity((Object)"Not authorized").build();
    }

    static {
        Class<?> httpServletReq = null;
        Class<?> httpServletResp = null;
        Method auth = null;
        try {
            httpServletReq = Class.forName("javax.servlet.http.HttpServletRequest");
            httpServletResp = Class.forName("javax.servlet.http.HttpServletResponse");
            auth = httpServletReq.getMethod("authenticate", httpServletResp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        AUTHENTICATE = auth;
        HTTP_SERVLET_REQUEST = httpServletReq;
        HTTP_SERVLET_RESPONSE = httpServletResp;
    }
}

