/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime.standalone;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import java.util.Objects;
import org.jboss.logging.Logger;

final class LazyHostSupplier {
    private static final Logger logger = Logger.getLogger((String)LazyHostSupplier.class.getName());
    private final HttpServerRequest request;
    private String remoteHost = null;
    private boolean initialized = false;

    public LazyHostSupplier(HttpServerRequest request) {
        Objects.requireNonNull(request);
        this.request = request;
    }

    public String getRemoteHost() {
        if (this.initialized) {
            return this.remoteHost;
        }
        SocketAddress socketAddress = null;
        try {
            socketAddress = this.request.remoteAddress();
        }
        catch (NullPointerException npe) {
            logger.debug((Object)("Ignoring exception that occurred when obtaining remote address of request " + this.request), (Throwable)npe);
        }
        this.remoteHost = socketAddress != null ? socketAddress.host() : null;
        this.initialized = true;
        return this.remoteHost;
    }
}

