/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime.standalone;

import io.quarkus.runtime.configuration.MemorySize;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.resteasy.spi.ResteasyConfiguration;

public class ResteasyConfigurationMPConfig
implements ResteasyConfiguration {
    private static final Map<String, Function<Config, Optional<String>>> RESTEASY_QUARKUS_MAPPING_PARAMS = Map.of("resteasy.gzip.max.input", ResteasyConfigurationMPConfig::getGzipMaxInput);

    public String getParameter(String name) {
        Config config = ConfigProvider.getConfig();
        if (config == null) {
            return null;
        }
        Optional<Object> value = Optional.empty();
        Function<Config, Optional<String>> mappingFunction = RESTEASY_QUARKUS_MAPPING_PARAMS.get(name);
        if (mappingFunction != null) {
            value = mappingFunction.apply(config);
        }
        return value.or(() -> config.getOptionalValue(name, String.class)).orElse(null);
    }

    public Set<String> getParameterNames() {
        Config config = ConfigProvider.getConfig();
        if (config == null) {
            return Set.of();
        }
        HashSet<String> set = new HashSet<String>();
        for (String name : config.getPropertyNames()) {
            set.add(name);
        }
        set.addAll(RESTEASY_QUARKUS_MAPPING_PARAMS.keySet());
        return set;
    }

    public String getInitParameter(String name) {
        return this.getParameter(name);
    }

    public Set<String> getInitParameterNames() {
        return this.getParameterNames();
    }

    private static Optional<String> getGzipMaxInput(Config config) {
        Optional rawValue = config.getOptionalValue("quarkus.resteasy.gzip.max-input", MemorySize.class);
        if (rawValue.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Long.toString(((MemorySize)rawValue.get()).asLongValue()));
    }
}

