/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.security.spi.runtime.SecurityEventHelper;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.PolicyMappingConfig;
import io.quarkus.vertx.http.runtime.security.AbstractPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Map;

@ApplicationScoped
public class JaxRsPermissionChecker {
    private final AbstractPathMatchingHttpSecurityPolicy jaxRsPathMatchingPolicy;
    private final HttpSecurityPolicy.AuthorizationRequestContext authorizationRequestContext;
    @Inject
    RoutingContext routingContext;
    @Inject
    CurrentIdentityAssociation identityAssociation;

    JaxRsPermissionChecker(HttpConfiguration httpConfig, Instance<HttpSecurityPolicy> installedPolicies, HttpBuildTimeConfig httpBuildTimeConfig, BlockingSecurityExecutor blockingSecurityExecutor) {
        AbstractPathMatchingHttpSecurityPolicy jaxRsPathMatchingPolicy = new AbstractPathMatchingHttpSecurityPolicy(httpConfig.auth.permissions, httpConfig.auth.rolePolicy, httpBuildTimeConfig.rootPath, installedPolicies, PolicyMappingConfig.AppliesTo.JAXRS);
        if (jaxRsPathMatchingPolicy.hasNoPermissions()) {
            this.jaxRsPathMatchingPolicy = null;
            this.authorizationRequestContext = null;
        } else {
            this.jaxRsPathMatchingPolicy = jaxRsPathMatchingPolicy;
            this.authorizationRequestContext = new HttpSecurityPolicy.DefaultAuthorizationRequestContext(blockingSecurityExecutor);
        }
    }

    boolean shouldRunPermissionChecks() {
        return this.jaxRsPathMatchingPolicy != null;
    }

    void applyPermissionChecks(SecurityEventHelper<AuthorizationSuccessEvent, AuthorizationFailureEvent> eventHelper) {
        SecurityIdentity newIdentity;
        HttpSecurityPolicy.CheckResult checkResult = (HttpSecurityPolicy.CheckResult)this.jaxRsPathMatchingPolicy.checkPermission(this.routingContext, this.identityAssociation.getDeferredIdentity(), this.authorizationRequestContext).await().indefinitely();
        if (checkResult.getAugmentedIdentity() == null) {
            newIdentity = checkResult.isPermitted() ? null : this.identityAssociation.getIdentity();
        } else if (checkResult.getAugmentedIdentity() != this.identityAssociation.getIdentity()) {
            newIdentity = checkResult.getAugmentedIdentity();
            this.routingContext.setUser((User)new QuarkusHttpUser(newIdentity));
            this.identityAssociation.setIdentity(newIdentity);
        } else {
            newIdentity = checkResult.getAugmentedIdentity();
        }
        if (checkResult.isPermitted()) {
            if (eventHelper.fireEventOnSuccess()) {
                eventHelper.fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(newIdentity, AbstractPathMatchingHttpSecurityPolicy.class.getName(), Map.of(RoutingContext.class.getName(), this.routingContext)));
            }
            return;
        }
        Object exception = newIdentity.isAnonymous() ? new UnauthorizedException() : new ForbiddenException();
        if (eventHelper.fireEventOnFailure()) {
            eventHelper.fireFailureEvent((SecurityEvent)new AuthorizationFailureEvent(newIdentity, (Throwable)exception, AbstractPathMatchingHttpSecurityPolicy.class.getName(), Map.of(RoutingContext.class.getName(), this.routingContext)));
        }
        throw exception;
    }
}

