/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.resteasy.runtime.EagerSecurityFilter;
import io.quarkus.security.Authenticated;
import io.quarkus.security.PermissionsAllowed;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.Priority;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;

public abstract class StandardSecurityCheckInterceptor {
    @Inject
    AuthorizationController controller;
    @Inject
    CurrentVertxRequest currentVertxRequest;

    @AroundInvoke
    public Object intercept(InvocationContext ic) throws Exception {
        RoutingContext routingContext = this.currentVertxRequest.getCurrent();
        if (this.controller.isAuthorizationEnabled() && routingContext != null) {
            Method method = (Method)routingContext.get(EagerSecurityFilter.class.getName());
            if (method == null) {
                routingContext.put("io.quarkus.resteasy.runtime.EagerSecurityFilter#SKIP_DEFAULT_CHECK", (Object)true);
            } else if (method.equals(ic.getMethod())) {
                ic.getContextData().put("io.quarkus.security.securityHandler", "executed");
            }
        }
        return ic.proceed();
    }

    @Interceptor
    @Authenticated
    @Priority(value=900)
    public static final class AuthenticatedInterceptor
    extends StandardSecurityCheckInterceptor {
    }

    @Interceptor
    @PermitAll
    @Priority(value=900)
    public static final class PermitAllInterceptor
    extends StandardSecurityCheckInterceptor {
    }

    @Interceptor
    @PermissionsAllowed(value={""})
    @Priority(value=900)
    public static final class PermissionsAllowedInterceptor
    extends StandardSecurityCheckInterceptor {
    }

    @Interceptor
    @RolesAllowed(value={""})
    @Priority(value=900)
    public static final class RolesAllowedInterceptor
    extends StandardSecurityCheckInterceptor {
    }
}

