/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.reflect.Method;

@Priority(value=1000)
@Provider
public class EagerSecurityFilter
implements ContainerRequestFilter {
    @Context
    ResourceInfo resourceInfo;
    @Inject
    RoutingContext routingContext;
    @Inject
    SecurityCheckStorage securityCheckStorage;
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    AuthorizationController authorizationController;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!this.authorizationController.isAuthorizationEnabled()) {
            return;
        }
        Method method = this.resourceInfo.getResourceMethod();
        SecurityCheck check = this.securityCheckStorage.getSecurityCheck(method);
        if (check != null) {
            if (!check.isPermitAll()) {
                if (check.requiresMethodArguments()) {
                    if (this.securityIdentity.isAnonymous()) {
                        throw new UnauthorizedException();
                    }
                    return;
                }
                check.apply(this.securityIdentity, method, null);
            }
            this.routingContext.put(EagerSecurityFilter.class.getName(), (Object)method);
        }
    }
}

