/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import io.quarkus.vertx.http.runtime.security.EagerSecurityInterceptorStorage;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

@Priority(value=1000)
@Provider
public class EagerSecurityFilter
implements ContainerRequestFilter {
    private static final Consumer<RoutingContext> NULL_SENTINEL = new Consumer<RoutingContext>(){

        @Override
        public void accept(RoutingContext routingContext) {
        }
    };
    private final Map<MethodDescription, Consumer<RoutingContext>> cache = new HashMap<MethodDescription, Consumer<RoutingContext>>();
    private final EagerSecurityInterceptorStorage interceptorStorage;
    @Context
    ResourceInfo resourceInfo;
    @Inject
    RoutingContext routingContext;
    @Inject
    SecurityCheckStorage securityCheckStorage;
    @Inject
    CurrentIdentityAssociation identityAssociation;
    @Inject
    AuthorizationController authorizationController;

    public EagerSecurityFilter() {
        InstanceHandle interceptorStorageHandle = Arc.container().instance(EagerSecurityInterceptorStorage.class, new Annotation[0]);
        this.interceptorStorage = interceptorStorageHandle.isAvailable() ? (EagerSecurityInterceptorStorage)interceptorStorageHandle.get() : null;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.authorizationController.isAuthorizationEnabled()) {
            MethodDescription description = MethodDescription.ofMethod((Method)this.resourceInfo.getResourceMethod());
            if (this.interceptorStorage != null) {
                this.applyEagerSecurityInterceptors(description);
            }
            this.applySecurityChecks(description);
        }
    }

    private void applySecurityChecks(MethodDescription description) {
        SecurityCheck check = this.securityCheckStorage.getSecurityCheck(description);
        if (check != null) {
            if (!check.isPermitAll()) {
                if (check.requiresMethodArguments()) {
                    if (this.identityAssociation.getIdentity().isAnonymous()) {
                        UnauthorizedException exception = new UnauthorizedException();
                        throw exception;
                    }
                    return;
                }
                check.apply(this.identityAssociation.getIdentity(), description, null);
            }
            this.routingContext.put(EagerSecurityFilter.class.getName(), (Object)this.resourceInfo.getResourceMethod());
        }
    }

    private void applyEagerSecurityInterceptors(MethodDescription description) {
        Consumer interceptor = this.cache.get(description);
        if (interceptor != NULL_SENTINEL) {
            if (interceptor != null) {
                interceptor.accept((RoutingContext)this.routingContext);
            } else {
                interceptor = this.interceptorStorage.getInterceptor(description);
                if (interceptor == null) {
                    this.cache.put(description, NULL_SENTINEL);
                } else {
                    this.cache.put(description, interceptor);
                    interceptor.accept(this.routingContext);
                }
            }
        }
    }
}

