/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.SkippedExecution;
import io.quarkus.scheduler.common.runtime.DelegateInvoker;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import jakarta.enterprise.event.Event;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;

public final class SkipConcurrentExecutionInvoker
extends DelegateInvoker {
    private static final Logger LOG = Logger.getLogger(SkipConcurrentExecutionInvoker.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Event<SkippedExecution> event;

    public SkipConcurrentExecutionInvoker(ScheduledInvoker delegate, Event<SkippedExecution> event) {
        super(delegate);
        this.event = event;
    }

    @Override
    public CompletionStage<Void> invoke(ScheduledExecution execution) throws Exception {
        if (this.running.compareAndSet(false, true)) {
            return this.invokeDelegate(execution).whenComplete((r, t) -> this.running.set(false));
        }
        LOG.debugf("Skipped scheduled invoker execution: %s", (Object)this.delegate.getClass().getName());
        SkippedExecution payload = new SkippedExecution(execution, "The scheduled method should not be executed concurrently");
        this.event.fire((Object)payload);
        this.event.fireAsync((Object)payload);
        return CompletableFuture.completedStage(null);
    }
}

