/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import io.quarkus.scheduler.DelayedExecution;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.common.runtime.DelegateInvoker;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import jakarta.enterprise.event.Event;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class DelayedExecutionInvoker
extends DelegateInvoker {
    private static final Logger LOG = Logger.getLogger(DelayedExecutionInvoker.class);
    private final long maxDelay;
    private final ScheduledExecutorService executor;
    private final Event<DelayedExecution> event;

    public DelayedExecutionInvoker(ScheduledInvoker delegate, long maxDelay, ScheduledExecutorService executor, Event<DelayedExecution> event) {
        super(delegate);
        this.maxDelay = maxDelay;
        this.executor = executor;
        this.event = event;
    }

    @Override
    public CompletionStage<Void> invoke(final ScheduledExecution execution) throws Exception {
        long delay = ThreadLocalRandom.current().nextLong(this.maxDelay);
        DelayedExecution delayedExecution = new DelayedExecution(execution, delay);
        try {
            this.event.fire((Object)delayedExecution);
            this.event.fireAsync((Object)delayedExecution);
        }
        catch (Exception e) {
            LOG.errorf("Error while firing DelayedExecution event", (Object)e);
        }
        final CompletableFuture<Void> ret = new CompletableFuture<Void>();
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    DelayedExecutionInvoker.this.delegate.invoke(execution);
                    ret.complete(null);
                }
                catch (Exception e) {
                    ret.completeExceptionally(e);
                }
            }
        }, delay, TimeUnit.MILLISECONDS);
        return ret;
    }
}

