/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.Scheduler;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractJobDefinition
implements Scheduler.JobDefinition {
    protected final String identity;
    protected String cron = "";
    protected String every = "";
    protected String delayed = "";
    protected String overdueGracePeriod = "";
    protected Scheduled.ConcurrentExecution concurrentExecution = Scheduled.ConcurrentExecution.PROCEED;
    protected Scheduled.SkipPredicate skipPredicate = null;
    protected Consumer<ScheduledExecution> task;
    protected Function<ScheduledExecution, Uni<Void>> asyncTask;
    protected boolean scheduled = false;
    protected String timeZone = "<<default timezone>>";

    public AbstractJobDefinition(String identity) {
        this.identity = identity;
    }

    public Scheduler.JobDefinition setCron(String cron) {
        this.checkScheduled();
        this.cron = cron;
        return this;
    }

    public Scheduler.JobDefinition setInterval(String every) {
        this.checkScheduled();
        this.every = every;
        return this;
    }

    public Scheduler.JobDefinition setDelayed(String period) {
        this.checkScheduled();
        this.delayed = period;
        return this;
    }

    public Scheduler.JobDefinition setConcurrentExecution(Scheduled.ConcurrentExecution concurrentExecution) {
        this.checkScheduled();
        this.concurrentExecution = concurrentExecution;
        return this;
    }

    public Scheduler.JobDefinition setSkipPredicate(Scheduled.SkipPredicate skipPredicate) {
        this.checkScheduled();
        this.skipPredicate = skipPredicate;
        return this;
    }

    public Scheduler.JobDefinition setOverdueGracePeriod(String period) {
        this.checkScheduled();
        this.overdueGracePeriod = period;
        return this;
    }

    public Scheduler.JobDefinition setTimeZone(String timeZone) {
        this.checkScheduled();
        this.timeZone = timeZone;
        return this;
    }

    public Scheduler.JobDefinition setTask(Consumer<ScheduledExecution> task) {
        this.checkScheduled();
        if (this.asyncTask != null) {
            throw new IllegalStateException("Async task was already set");
        }
        this.task = task;
        return this;
    }

    public Scheduler.JobDefinition setAsyncTask(Function<ScheduledExecution, Uni<Void>> asyncTask) {
        this.checkScheduled();
        if (this.task != null) {
            throw new IllegalStateException("Sync task was already set");
        }
        this.asyncTask = asyncTask;
        return this;
    }

    protected void checkScheduled() {
        if (this.scheduled) {
            throw new IllegalStateException("Cannot modify a job that was already scheduled");
        }
    }
}

