/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AnnotationProxyBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.logging.LogCleanupFilterBuildItem;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.deployment.ScheduledBusinessMethodItem;
import io.quarkus.scheduler.runtime.QuartzScheduler;
import io.quarkus.scheduler.runtime.ScheduledInvoker;
import io.quarkus.scheduler.runtime.SchedulerConfiguration;
import io.quarkus.scheduler.runtime.SchedulerDeploymentRecorder;
import java.text.ParseException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.quartz.CronExpression;
import org.quartz.simpl.CascadingClassLoadHelper;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;

public class SchedulerProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)"io.quarkus.scheduler.deployment.processor");
    static final DotName SCHEDULED_NAME = DotName.createSimple((String)Scheduled.class.getName());
    static final DotName SCHEDULES_NAME = DotName.createSimple((String)Scheduled.Schedules.class.getName());
    static final Type SCHEDULED_EXECUTION_TYPE = Type.create((DotName)DotName.createSimple((String)ScheduledExecution.class.getName()), (Type.Kind)Type.Kind.CLASS);
    static final String INVOKER_SUFFIX = "_ScheduledInvoker";

    @BuildStep
    AdditionalBeanBuildItem beans() {
        return new AdditionalBeanBuildItem(new Class[]{SchedulerConfiguration.class, QuartzScheduler.class});
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationTransformer() {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS || kind == AnnotationTarget.Kind.METHOD;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                MethodInfo method;
                if (context.isClass() && context.getAnnotations().isEmpty()) {
                    if (context.getTarget().asClass().annotations().containsKey(SCHEDULED_NAME) || context.getTarget().asClass().annotations().containsKey(SCHEDULES_NAME)) {
                        LOGGER.debugf("Found scheduled business methods on a class %s with no annotations - adding @Singleton", (Object)context.getTarget());
                        context.transform().add(Singleton.class, new AnnotationValue[0]).done();
                    }
                } else if (context.isMethod() && ((method = context.getTarget().asMethod()).hasAnnotation(SCHEDULED_NAME) || method.hasAnnotation(SCHEDULES_NAME)) && !method.hasAnnotation(DotNames.ACTIVATE_REQUEST_CONTEXT)) {
                    context.transform().add(DotNames.ACTIVATE_REQUEST_CONTEXT, new AnnotationValue[0]).done();
                }
            }
        });
    }

    @BuildStep
    List<ReflectiveClassBuildItem> reflectiveClasses() {
        ArrayList<ReflectiveClassBuildItem> reflectiveClasses = new ArrayList<ReflectiveClassBuildItem>();
        reflectiveClasses.add(new ReflectiveClassBuildItem(false, false, new String[]{CascadingClassLoadHelper.class.getName()}));
        reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{SimpleThreadPool.class.getName()}));
        reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{RAMJobStore.class.getName()}));
        return reflectiveClasses;
    }

    @BuildStep
    void validateBeanDeployment(ValidationPhaseBuildItem validationPhase, BuildProducer<ScheduledBusinessMethodItem> scheduledBusinessMethods, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        AnnotationStore annotationStore = (AnnotationStore)validationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : (List)validationPhase.getContext().get(BuildExtension.Key.BEANS)) {
            if (!bean.isClassBean()) continue;
            for (MethodInfo method : ((AnnotationTarget)bean.getTarget().get()).asClass().methods()) {
                List<AnnotationInstance> schedules;
                AnnotationInstance scheduledAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, SCHEDULED_NAME);
                if (scheduledAnnotation != null) {
                    schedules = Collections.singletonList(scheduledAnnotation);
                } else {
                    AnnotationInstance scheduledsAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, SCHEDULES_NAME);
                    if (scheduledsAnnotation != null) {
                        schedules = new ArrayList<AnnotationInstance>();
                        for (AnnotationInstance scheduledInstance : scheduledsAnnotation.value().asNestedArray()) {
                            schedules.add(scheduledInstance);
                        }
                    } else {
                        schedules = null;
                    }
                }
                if (schedules == null) continue;
                List params = method.parameters();
                if (params.size() > 1 || params.size() == 1 && !((Type)params.get(0)).equals((Object)SCHEDULED_EXECUTION_TYPE)) {
                    throw new IllegalStateException(String.format("Invalid scheduled business method parameters %s [method: %s, bean: %s]", params, method, bean));
                }
                if (!method.returnType().kind().equals((Object)Type.Kind.VOID)) {
                    throw new IllegalStateException(String.format("Scheduled business method must return void [method: %s, bean: %s]", method, bean));
                }
                for (AnnotationInstance scheduled : schedules) {
                    Throwable error = this.validateScheduled(scheduled);
                    if (error == null) continue;
                    errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{error}));
                }
                scheduledBusinessMethods.produce((BuildItem)new ScheduledBusinessMethodItem(bean, method, schedules));
                LOGGER.debugf("Found scheduled business method %s declared on %s", (Object)method, (Object)bean);
            }
        }
    }

    @BuildStep
    public List<UnremovableBeanBuildItem> unremovableBeans() {
        return Arrays.asList(new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(SCHEDULED_NAME)), new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(SCHEDULES_NAME)));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(SchedulerDeploymentRecorder recorder, BeanContainerBuildItem beanContainer, List<ScheduledBusinessMethodItem> scheduledBusinessMethods, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<FeatureBuildItem> feature, AnnotationProxyBuildItem annotationProxy) {
        feature.produce((BuildItem)new FeatureBuildItem("scheduler"));
        ArrayList scheduleConfigurations = new ArrayList();
        GizmoAdaptor classOutput = new GizmoAdaptor(generatedClass, true);
        for (ScheduledBusinessMethodItem businessMethod : scheduledBusinessMethods) {
            HashMap<String, Object> config = new HashMap<String, Object>();
            String invokerClass = this.generateInvoker(businessMethod.getBean(), businessMethod.getMethod(), (ClassOutput)classOutput);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{invokerClass}));
            config.put("invoker", invokerClass);
            ArrayList<Object> schedules = new ArrayList<Object>();
            for (AnnotationInstance scheduled : businessMethod.getSchedules()) {
                schedules.add(annotationProxy.builder(scheduled, Scheduled.class).build((ClassOutput)classOutput));
            }
            config.put("schedules", schedules);
            config.put("desc", businessMethod.getMethod().declaringClass() + "#" + businessMethod.getMethod().name());
            scheduleConfigurations.add(config);
        }
        recorder.registerSchedules(scheduleConfigurations, beanContainer.getValue());
    }

    @BuildStep
    public void logCleanup(BuildProducer<LogCleanupFilterBuildItem> logCleanupFilter) {
        logCleanupFilter.produce((BuildItem)new LogCleanupFilterBuildItem("org.quartz.impl.StdSchedulerFactory", new String[]{"Quartz scheduler version:", "Using default implementation for", "Quartz scheduler 'DefaultQuartzScheduler'"}));
        logCleanupFilter.produce((BuildItem)new LogCleanupFilterBuildItem("org.quartz.core.QuartzScheduler", new String[]{"Quartz Scheduler v", "JobFactory set to:", "Scheduler meta-data:", "Scheduler DefaultQuartzScheduler"}));
        logCleanupFilter.produce((BuildItem)new LogCleanupFilterBuildItem("org.quartz.simpl.RAMJobStore", new String[]{"RAMJobStore initialized."}));
        logCleanupFilter.produce((BuildItem)new LogCleanupFilterBuildItem("org.quartz.core.SchedulerSignalerImpl", new String[]{"Initialized Scheduler Signaller of type"}));
    }

    private String generateInvoker(BeanInfo bean, MethodInfo method, ClassOutput classOutput) {
        String baseName = bean.getImplClazz().enclosingClass() != null ? DotNames.simpleName((DotName)bean.getImplClazz().enclosingClass()) + "_" + DotNames.simpleName((DotName)bean.getImplClazz().name()) : DotNames.simpleName((DotName)bean.getImplClazz().name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameters()) {
            sigBuilder.append(i.name().toString());
        }
        String targetPackage = DotNames.packageName((DotName)bean.getImplClazz().name());
        String generatedName = targetPackage.replace('.', '/') + "/" + baseName + INVOKER_SUFFIX + "_" + method.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        ClassCreator invokerCreator = ClassCreator.builder().classOutput(classOutput).className(generatedName).interfaces(new Class[]{ScheduledInvoker.class}).build();
        MethodCreator invoke = invokerCreator.getMethodCreator("invoke", Void.TYPE, new Class[]{ScheduledExecution.class});
        ResultHandle containerHandle = invoke.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle beanHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class}), containerHandle, new ResultHandle[]{invoke.load(bean.getIdentifier())});
        ResultHandle instanceHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{InjectableBean.class}), containerHandle, new ResultHandle[]{beanHandle});
        ResultHandle beanInstanceHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        if (method.parameters().isEmpty()) {
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[0]), beanInstanceHandle, new ResultHandle[0]);
        } else {
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{ScheduledExecution.class}), beanInstanceHandle, new ResultHandle[]{invoke.getMethodParam(0)});
        }
        if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
            invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"destroy", Void.TYPE, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        }
        invoke.returnValue(null);
        invokerCreator.close();
        return generatedName.replace('/', '.');
    }

    private Throwable validateScheduled(AnnotationInstance schedule) {
        AnnotationValue cronValue = schedule.value("cron");
        if (cronValue != null && !cronValue.asString().trim().isEmpty()) {
            String cron = cronValue.asString().trim();
            if (SchedulerConfiguration.isConfigValue((String)cron)) {
                return null;
            }
            try {
                new CronExpression(cron);
            }
            catch (ParseException e) {
                return new IllegalStateException("Invalid cron() expression on: " + schedule, e);
            }
        } else {
            AnnotationValue everyValue = schedule.value("every");
            if (everyValue != null && !everyValue.asString().trim().isEmpty()) {
                String every = everyValue.asString().trim();
                if (SchedulerConfiguration.isConfigValue((String)every)) {
                    return null;
                }
                if (Character.isDigit(every.charAt(0))) {
                    every = "PT" + every;
                }
                try {
                    Duration.parse(every);
                }
                catch (Exception e) {
                    return new IllegalStateException("Invalid every() expression on: " + schedule, e);
                }
            } else {
                return new IllegalStateException("@Scheduled must declare either cron() or every(): " + schedule);
            }
        }
        return null;
    }
}

