/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanDeploymentValidatorBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AnnotationProxyBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.deployment.ScheduledBusinessMethodItem;
import io.quarkus.scheduler.runtime.QuartzScheduler;
import io.quarkus.scheduler.runtime.ScheduledInvoker;
import io.quarkus.scheduler.runtime.SchedulerConfiguration;
import io.quarkus.scheduler.runtime.SchedulerDeploymentTemplate;
import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.inject.Singleton;
import org.jboss.builder.item.BuildItem;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.quartz.CronExpression;
import org.quartz.simpl.CascadingClassLoadHelper;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;

public class SchedulerProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)"io.quarkus.scheduler.deployment.processor");
    static final DotName SCHEDULED_NAME = DotName.createSimple((String)Scheduled.class.getName());
    static final DotName SCHEDULES_NAME = DotName.createSimple((String)Scheduled.Schedules.class.getName());
    static final Type SCHEDULED_EXECUTION_TYPE = Type.create((DotName)DotName.createSimple((String)ScheduledExecution.class.getName()), (Type.Kind)Type.Kind.CLASS);
    static final String INVOKER_SUFFIX = "_ScheduledInvoker";

    @BuildStep
    List<AdditionalBeanBuildItem> beans() {
        ArrayList<AdditionalBeanBuildItem> beans = new ArrayList<AdditionalBeanBuildItem>();
        beans.add(new AdditionalBeanBuildItem(new Class[]{SchedulerConfiguration.class}));
        beans.add(new AdditionalBeanBuildItem(new Class[]{QuartzScheduler.class}));
        return beans;
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationTransformer() {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (context.getAnnotations().isEmpty() && (context.getTarget().asClass().annotations().containsKey(SCHEDULED_NAME) || context.getTarget().asClass().annotations().containsKey(SCHEDULES_NAME))) {
                    LOGGER.debugf("Found scheduled business methods on a class %s with no annotations - adding @Singleton", (Object)context.getTarget());
                    context.transform().add(Singleton.class, new AnnotationValue[0]).done();
                }
            }
        });
    }

    @BuildStep
    List<ReflectiveClassBuildItem> reflectiveClasses() {
        ArrayList<ReflectiveClassBuildItem> reflectiveClasses = new ArrayList<ReflectiveClassBuildItem>();
        reflectiveClasses.add(new ReflectiveClassBuildItem(false, false, new String[]{CascadingClassLoadHelper.class.getName()}));
        reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{SimpleThreadPool.class.getName()}));
        reflectiveClasses.add(new ReflectiveClassBuildItem(true, false, new String[]{RAMJobStore.class.getName()}));
        return reflectiveClasses;
    }

    @BuildStep
    BeanDeploymentValidatorBuildItem beanDeploymentValidator(final BuildProducer<ScheduledBusinessMethodItem> scheduledBusinessMethods) {
        return new BeanDeploymentValidatorBuildItem(new BeanDeploymentValidator(){

            public void validate(BeanDeploymentValidator.ValidationContext validationContext) {
                AnnotationStore annotationStore = (AnnotationStore)validationContext.get(BuildExtension.Key.ANNOTATION_STORE);
                for (BeanInfo bean : (List)validationContext.get(BuildExtension.Key.BEANS)) {
                    if (!bean.isClassBean()) continue;
                    for (MethodInfo method : ((AnnotationTarget)bean.getTarget().get()).asClass().methods()) {
                        List<AnnotationInstance> schedules;
                        AnnotationInstance scheduledAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, SCHEDULED_NAME);
                        if (scheduledAnnotation != null) {
                            schedules = Collections.singletonList(scheduledAnnotation);
                        } else {
                            AnnotationInstance scheduledsAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, SCHEDULES_NAME);
                            if (scheduledsAnnotation != null) {
                                schedules = new ArrayList<AnnotationInstance>();
                                for (AnnotationInstance scheduledInstance : scheduledsAnnotation.value().asNestedArray()) {
                                    schedules.add(scheduledInstance);
                                }
                            } else {
                                schedules = null;
                            }
                        }
                        if (schedules == null) continue;
                        List params = method.parameters();
                        if (params.size() > 1 || params.size() == 1 && !((Type)params.get(0)).equals((Object)SCHEDULED_EXECUTION_TYPE)) {
                            throw new IllegalStateException(String.format("Invalid scheduled business method parameters %s [method: %s, bean:%s", params, method, bean));
                        }
                        if (!method.returnType().kind().equals((Object)Type.Kind.VOID)) {
                            throw new IllegalStateException(String.format("Scheduled business method must return void [method: %s, bean:%s", method.returnType(), method, bean));
                        }
                        for (AnnotationInstance scheduled : schedules) {
                            SchedulerProcessor.this.validateScheduled(validationContext, scheduled);
                        }
                        scheduledBusinessMethods.produce((BuildItem)new ScheduledBusinessMethodItem(bean, method, schedules));
                        LOGGER.debugf("Found scheduled business method %s declared on %s", (Object)method, (Object)bean);
                    }
                }
            }
        });
    }

    @BuildStep
    public List<UnremovableBeanBuildItem> unremovableBeans() {
        return Arrays.asList(new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(SCHEDULED_NAME)), new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(SCHEDULES_NAME)));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void build(SchedulerDeploymentTemplate template, BeanContainerBuildItem beanContainer, List<ScheduledBusinessMethodItem> scheduledBusinessMethods, final BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<FeatureBuildItem> feature, AnnotationProxyBuildItem annotationProxy) {
        feature.produce((BuildItem)new FeatureBuildItem("scheduler"));
        ArrayList scheduleConfigurations = new ArrayList();
        ClassOutput classOutput = new ClassOutput(){

            public void write(String name, byte[] data) {
                generatedClass.produce((BuildItem)new GeneratedClassBuildItem(true, name, data));
            }
        };
        for (ScheduledBusinessMethodItem businessMethod : scheduledBusinessMethods) {
            HashMap<String, Object> config = new HashMap<String, Object>();
            String invokerClass = this.generateInvoker(businessMethod.getBean(), businessMethod.getMethod(), classOutput);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{invokerClass}));
            config.put("invoker", invokerClass);
            ArrayList<Annotation> schedules = new ArrayList<Annotation>();
            for (AnnotationInstance scheduled : businessMethod.getSchedules()) {
                schedules.add(annotationProxy.from(scheduled, Scheduled.class));
            }
            config.put("schedules", schedules);
            config.put("desc", businessMethod.getMethod().declaringClass() + "#" + businessMethod.getMethod().name());
            scheduleConfigurations.add(config);
        }
        template.registerSchedules(scheduleConfigurations, beanContainer.getValue());
    }

    private String generateInvoker(BeanInfo bean, MethodInfo method, ClassOutput classOutput) {
        String baseName = bean.getImplClazz().enclosingClass() != null ? DotNames.simpleName((DotName)bean.getImplClazz().enclosingClass()) + "_" + DotNames.simpleName((DotName)bean.getImplClazz().name()) : DotNames.simpleName((DotName)bean.getImplClazz().name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameters()) {
            sigBuilder.append(i.name().toString());
        }
        String targetPackage = DotNames.packageName((DotName)bean.getImplClazz().name());
        String generatedName = targetPackage.replace('.', '/') + "/" + baseName + INVOKER_SUFFIX + "_" + method.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        ClassCreator invokerCreator = ClassCreator.builder().classOutput(classOutput).className(generatedName).interfaces(new Class[]{ScheduledInvoker.class}).build();
        MethodCreator invoke = invokerCreator.getMethodCreator("invoke", Void.TYPE, new Class[]{ScheduledExecution.class});
        ResultHandle containerHandle = invoke.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle beanHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class}), containerHandle, new ResultHandle[]{invoke.load(bean.getIdentifier())});
        ResultHandle instanceHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{InjectableBean.class}), containerHandle, new ResultHandle[]{beanHandle});
        ResultHandle beanInstanceHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        if (method.parameters().isEmpty()) {
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[0]), beanInstanceHandle, new ResultHandle[0]);
        } else {
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{ScheduledExecution.class}), beanInstanceHandle, new ResultHandle[]{invoke.getMethodParam(0)});
        }
        if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
            invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"destroy", Void.TYPE, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        }
        invoke.returnValue(null);
        invokerCreator.close();
        return generatedName.replace('/', '.');
    }

    private void validateScheduled(BeanDeploymentValidator.ValidationContext validationContext, AnnotationInstance schedule) {
        AnnotationValue cronValue = schedule.value("cron");
        if (cronValue != null && !cronValue.asString().trim().isEmpty()) {
            String cron = cronValue.asString().trim();
            if (SchedulerConfiguration.isConfigValue((String)cron)) {
                return;
            }
            try {
                new CronExpression(cron);
            }
            catch (ParseException e) {
                validationContext.addDeploymentProblem((Throwable)new IllegalStateException("Invalid cron() expression on: " + schedule, e));
            }
        } else {
            AnnotationValue everyValue = schedule.value("every");
            if (everyValue != null && !everyValue.asString().trim().isEmpty()) {
                String every = everyValue.asString().trim();
                if (SchedulerConfiguration.isConfigValue((String)every)) {
                    return;
                }
                if (Character.isDigit(every.charAt(0))) {
                    every = "PT" + every;
                }
                try {
                    Duration.parse(every);
                }
                catch (Exception e) {
                    validationContext.addDeploymentProblem((Throwable)new IllegalStateException("Invalid every() expression on: " + schedule, e));
                }
            } else {
                validationContext.addDeploymentProblem((Throwable)new IllegalStateException("@Scheduled must declare either cron() or every(): " + schedule));
            }
        }
    }
}

