/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.runtime;

import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.runtime.ScheduledInvoker;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class SchedulerConfiguration {
    private final Map<String, List<Scheduled>> schedules = new ConcurrentHashMap<String, List<Scheduled>>();
    private final Map<String, String> descriptions = new ConcurrentHashMap<String, String>();

    void register(String invokerClassName, String description, List<Scheduled> schedules) {
        this.schedules.put(invokerClassName, schedules);
        this.descriptions.put(invokerClassName, description);
    }

    Map<String, List<Scheduled>> getSchedules() {
        return this.schedules;
    }

    String getDescription(String invokerClassName) {
        return this.descriptions.get(invokerClassName);
    }

    ScheduledInvoker createInvoker(String invokerClassName) {
        try {
            Class<?> invokerClazz = Thread.currentThread().getContextClassLoader().loadClass(invokerClassName);
            return (ScheduledInvoker)invokerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create invoker: " + invokerClassName, e);
        }
    }

    public static String getConfigProperty(String val) {
        return val.substring(1, val.length() - 1);
    }

    public static boolean isConfigValue(String val) {
        return (val = val.trim()).startsWith("{") && val.endsWith("}");
    }
}

