/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.runtime;

import io.quarkus.runtime.StartupEvent;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.Scheduler;
import io.quarkus.scheduler.Trigger;
import io.quarkus.scheduler.runtime.ScheduledInvoker;
import io.quarkus.scheduler.runtime.SchedulerConfiguration;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

@Typed(value={Scheduler.class})
@ApplicationScoped
public class QuartzScheduler
implements Scheduler {
    private static final Logger LOGGER = Logger.getLogger((String)QuartzScheduler.class.getName());
    @Inject
    SchedulerConfiguration schedulerConfig;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private org.quartz.Scheduler scheduler;
    private final Map<String, ScheduledInvoker> invokers = new ConcurrentHashMap<String, ScheduledInvoker>();
    private final AtomicInteger timerIdx = new AtomicInteger();
    private final Map<String, Runnable> timers = new ConcurrentHashMap<String, Runnable>();

    @Override
    public void pause() {
        if (this.running.get()) {
            try {
                this.scheduler.pauseAll();
            }
            catch (SchedulerException e) {
                LOGGER.warn((Object)"Unable to pause scheduler", (Throwable)e);
            }
        }
    }

    @Override
    public void resume() {
        if (this.running.get()) {
            try {
                this.scheduler.resumeAll();
            }
            catch (SchedulerException e) {
                LOGGER.warn((Object)"Unable to resume scheduler", (Throwable)e);
            }
        }
    }

    @Override
    public void startTimer(long delay, Runnable action) {
        if (this.running.get()) {
            int idx = this.timerIdx.incrementAndGet();
            String name = "timer_" + idx;
            this.timers.put(name, action);
            JobDetail job = JobBuilder.newJob(TimerJob.class).withIdentity(name, Scheduler.class.getName()).build();
            org.quartz.Trigger trigger = TriggerBuilder.newTrigger().withIdentity(name + "_trigger", Scheduler.class.getName()).startAt(new Date(Instant.now().plusMillis(delay).toEpochMilli())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule()).build();
            try {
                this.scheduler.scheduleJob(job, trigger);
            }
            catch (SchedulerException e) {
                this.timers.remove(name);
                throw new IllegalStateException("Unable to schedule timer", e);
            }
        } else {
            LOGGER.warn((Object)"Scheduler not running");
        }
    }

    void start(@Observes StartupEvent startupEvent) {
        if (this.schedulerConfig.getSchedules().isEmpty()) {
            LOGGER.warn((Object)"No @Scheduled methods found, scheduler will not be started.");
            return;
        }
        if (this.running.compareAndSet(false, true)) {
            try {
                Properties props = new Properties();
                props.put("org.quartz.scheduler.instanceName", "DefaultQuartzScheduler");
                props.put("org.quartz.scheduler.rmi.export", (Object)false);
                props.put("org.quartz.scheduler.rmi.proxy", (Object)false);
                props.put("org.quartz.scheduler.wrapJobExecutionInUserTransaction", (Object)false);
                props.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
                props.put("org.quartz.threadPool.threadCount", "10");
                props.put("org.quartz.threadPool.threadPriority", "5");
                props.put("org.quartz.threadPool.threadsInheritContextClassLoaderOfInitializingThread", (Object)true);
                props.put("org.quartz.jobStore.misfireThreshold", "60000");
                props.put("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
                StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(props);
                this.scheduler = schedulerFactory.getScheduler();
                this.scheduler.setJobFactory(new JobFactory(){

                    public Job newJob(TriggerFiredBundle bundle, org.quartz.Scheduler scheduler) throws SchedulerException {
                        Class jobClass = bundle.getJobDetail().getJobClass();
                        if (jobClass.equals(InvokerJob.class)) {
                            return new InvokerJob();
                        }
                        if (jobClass.equals(TimerJob.class)) {
                            return new TimerJob();
                        }
                        throw new IllegalStateException("Unsupported job class: " + jobClass);
                    }
                });
                for (Map.Entry<String, List<Scheduled>> entry : this.schedulerConfig.getSchedules().entrySet()) {
                    Config config = ConfigProvider.getConfig();
                    int idx = 1;
                    for (Scheduled scheduled : entry.getValue()) {
                        CronScheduleBuilder scheduleBuilder;
                        String name = idx++ + "_" + entry.getKey();
                        JobBuilder jobBuilder = JobBuilder.newJob(InvokerJob.class).withIdentity(name, Scheduler.class.getName()).usingJobData("invoker", entry.getKey());
                        String cron = scheduled.cron().trim();
                        if (!cron.isEmpty()) {
                            try {
                                if (SchedulerConfiguration.isConfigValue(cron)) {
                                    cron = (String)config.getValue(SchedulerConfiguration.getConfigProperty(cron), String.class);
                                }
                                scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cron);
                            }
                            catch (RuntimeException e) {
                                throw new IllegalStateException("Invalid cron() expression on: " + scheduled, e);
                            }
                        }
                        if (!scheduled.every().isEmpty()) {
                            Duration duration;
                            String every = scheduled.every().trim();
                            if (SchedulerConfiguration.isConfigValue(every)) {
                                every = (String)config.getValue(SchedulerConfiguration.getConfigProperty(every), String.class);
                            }
                            if (Character.isDigit(every.charAt(0))) {
                                every = "PT" + every;
                            }
                            try {
                                duration = Duration.parse(every);
                            }
                            catch (Exception e) {
                                throw new IllegalStateException("Invalid every() expression on: " + scheduled, e);
                            }
                            scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(duration.toMillis()).repeatForever();
                        } else {
                            throw new IllegalArgumentException("Invalid schedule configuration: " + scheduled);
                        }
                        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(name + "_trigger", Scheduler.class.getName()).withSchedule((ScheduleBuilder)scheduleBuilder);
                        if (scheduled.delay() > 0L) {
                            triggerBuilder.startAt(new Date(Instant.now().plusMillis(scheduled.delayUnit().toMillis(scheduled.delay())).toEpochMilli()));
                        }
                        this.scheduler.scheduleJob(jobBuilder.build(), triggerBuilder.build());
                        LOGGER.debugf("Scheduled business method %s with config %s", (Object)this.schedulerConfig.getDescription(entry.getKey()), (Object)scheduled);
                    }
                }
                this.scheduler.start();
            }
            catch (SchedulerException e) {
                throw new IllegalStateException("Unable to start Scheduler", e);
            }
        }
        LOGGER.warnf("Unable to start scheduler - already started", new Object[0]);
    }

    @PreDestroy
    void destroy() {
        if (this.running.compareAndSet(true, false) && this.scheduler != null) {
            try {
                this.scheduler.shutdown();
            }
            catch (SchedulerException e) {
                LOGGER.warnf("Unable to shutdown scheduler", (Object)e);
            }
        }
    }

    class TimerJob
    implements Job {
        TimerJob() {
        }

        public void execute(JobExecutionContext context) throws JobExecutionException {
            Runnable action = (Runnable)QuartzScheduler.this.timers.remove(context.getJobDetail().getKey().getName());
            if (action != null) {
                action.run();
            } else {
                LOGGER.warnf("No timer action found for key: %s", (Object)context.getJobDetail().getKey());
            }
            try {
                QuartzScheduler.this.scheduler.deleteJob(context.getJobDetail().getKey());
            }
            catch (SchedulerException e) {
                LOGGER.warnf((Throwable)e, "Unable to delete timer job for key: %s", (Object)context.getJobDetail().getKey());
            }
        }
    }

    class InvokerJob
    implements Job {
        InvokerJob() {
        }

        public void execute(final JobExecutionContext context) throws JobExecutionException {
            final Trigger trigger = new Trigger(){

                @Override
                public Instant getNextFireTime() {
                    Date nextFireTime = context.getTrigger().getNextFireTime();
                    return nextFireTime != null ? nextFireTime.toInstant() : null;
                }

                @Override
                public Instant getPreviousFireTime() {
                    Date previousFireTime = context.getTrigger().getPreviousFireTime();
                    return previousFireTime != null ? previousFireTime.toInstant() : null;
                }
            };
            String invokerClass = context.getJobDetail().getJobDataMap().getString("invoker");
            QuartzScheduler.this.invokers.computeIfAbsent(invokerClass, QuartzScheduler.this.schedulerConfig::createInvoker).invoke(new ScheduledExecution(){

                @Override
                public Trigger getTrigger() {
                    return trigger;
                }

                @Override
                public Instant getScheduledFireTime() {
                    return context.getScheduledFireTime().toInstant();
                }

                @Override
                public Instant getFireTime() {
                    return context.getFireTime().toInstant();
                }
            });
        }
    }
}

