/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.runtime;

import com.cronutils.model.CronType;
import io.quarkus.scheduler.runtime.ScheduledInvoker;
import io.quarkus.scheduler.runtime.ScheduledMethodMetadata;
import io.quarkus.scheduler.runtime.SchedulerConfig;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.inject.Singleton;

@Singleton
public class SchedulerSupport {
    private volatile ExecutorService executor;
    private volatile CronType cronType;
    private volatile List<ScheduledMethodMetadata> scheduledMethods;

    void initialize(SchedulerConfig config, List<ScheduledMethodMetadata> scheduledMethods, ExecutorService executor) {
        this.cronType = config.cronType;
        this.scheduledMethods = scheduledMethods;
        this.executor = executor;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public CronType getCronType() {
        return this.cronType;
    }

    public List<ScheduledMethodMetadata> getScheduledMethods() {
        return this.scheduledMethods;
    }

    public ScheduledInvoker createInvoker(String invokerClassName) {
        try {
            Class<?> invokerClazz = Thread.currentThread().getContextClassLoader().loadClass(invokerClassName);
            return (ScheduledInvoker)invokerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create invoker: " + invokerClassName, e);
        }
    }

    public static String getConfigProperty(String val) {
        return val.substring(1, val.length() - 1);
    }

    public static boolean isConfigValue(String val) {
        return (val = val.trim()).startsWith("{") && val.endsWith("}");
    }
}

