/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.runtime;

import io.quarkus.scheduler.FailedExecution;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.SuccessfulExecution;
import io.quarkus.scheduler.runtime.ScheduledInvoker;
import javax.enterprise.event.Event;
import org.jboss.logging.Logger;

public final class StatusEmitterInvoker
implements ScheduledInvoker {
    private static final Logger LOGGER = Logger.getLogger(StatusEmitterInvoker.class);
    private final ScheduledInvoker delegate;
    private final Event<SuccessfulExecution> successfulExecutionEvent;
    private final Event<FailedExecution> failedExecutionEvent;

    public StatusEmitterInvoker(ScheduledInvoker delegate, Event<SuccessfulExecution> successfulExecutionEvent, Event<FailedExecution> failedExecutionEvent) {
        this.delegate = delegate;
        this.successfulExecutionEvent = successfulExecutionEvent;
        this.failedExecutionEvent = failedExecutionEvent;
    }

    public void invoke(ScheduledExecution execution) throws Exception {
        try {
            this.delegate.invoke(execution);
            SuccessfulExecution successExecution = new SuccessfulExecution(execution);
            this.successfulExecutionEvent.fireAsync((Object)successExecution);
            this.successfulExecutionEvent.fire((Object)successExecution);
        }
        catch (Throwable t) {
            LOGGER.errorf(t, "Error occured while executing task for trigger %s", (Object)execution.getTrigger());
            FailedExecution failedExecution = new FailedExecution(execution, t);
            this.failedExecutionEvent.fireAsync((Object)failedExecution);
            this.failedExecutionEvent.fire((Object)failedExecution);
            throw t;
        }
    }

    public void invokeBean(ScheduledExecution param) {
        throw new UnsupportedOperationException();
    }
}

