/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.runtime.devconsole;

import io.quarkus.arc.Arc;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.runtime.spi.FlashScopeUtil;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.Scheduler;
import io.quarkus.scheduler.Trigger;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import io.quarkus.scheduler.common.runtime.ScheduledMethod;
import io.quarkus.scheduler.common.runtime.SchedulerContext;
import io.quarkus.scheduler.common.runtime.util.SchedulerUtils;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class SchedulerDevConsoleRecorder {
    private static final Logger LOG = Logger.getLogger(SchedulerDevConsoleRecorder.class);

    public Supplier<Function<String, String>> getConfigLookup() {
        return new Supplier<Function<String, String>>(){

            @Override
            public Function<String, String> get() {
                return SchedulerUtils::lookUpPropertyValue;
            }
        };
    }

    public Handler<RoutingContext> invokeHandler() {
        ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
        return new DevConsolePostHandler(){

            protected void handlePost(RoutingContext ctx, MultiMap form) throws Exception {
                String action = form.get("action");
                if ("pause".equals(action)) {
                    Scheduler scheduler = (Scheduler)Arc.container().instance(Scheduler.class, new Annotation[0]).get();
                    if (scheduler.isRunning()) {
                        scheduler.pause();
                        LOG.info((Object)"Scheduler paused via Dev UI");
                        this.flashMessage(ctx, "Scheduler paused");
                    }
                } else if ("resume".equals(action)) {
                    Scheduler scheduler = (Scheduler)Arc.container().instance(Scheduler.class, new Annotation[0]).get();
                    if (!scheduler.isRunning()) {
                        scheduler.resume();
                        LOG.info((Object)"Scheduler resumed via Dev UI");
                        this.flashMessage(ctx, "Scheduler resumed");
                    }
                } else if ("pauseJob".equals(action)) {
                    Scheduler scheduler = (Scheduler)Arc.container().instance(Scheduler.class, new Annotation[0]).get();
                    String identity = form.get("identity");
                    if (identity != null && !scheduler.isPaused(identity)) {
                        scheduler.pause(identity);
                        LOG.infof("Scheduler paused job with identity '%s' via Dev UI", (Object)identity);
                        this.flashMessage(ctx, "Job with identity " + identity + " paused");
                    }
                } else if ("resumeJob".equals(action)) {
                    Scheduler scheduler = (Scheduler)Arc.container().instance(Scheduler.class, new Annotation[0]).get();
                    String identity = form.get("identity");
                    if (identity != null && scheduler.isPaused(identity)) {
                        scheduler.resume(identity);
                        LOG.infof("Scheduler resumed job with identity '%s'via Dev UI", (Object)identity);
                        this.flashMessage(ctx, "Job with identity " + identity + " resumed");
                    }
                } else {
                    String name = form.get("name");
                    SchedulerContext context = (SchedulerContext)Arc.container().instance(SchedulerContext.class, new Annotation[0]).get();
                    for (ScheduledMethod metadata : context.getScheduledMethods()) {
                        if (!metadata.getMethodDescription().equals(name)) continue;
                        Vertx vertx = (Vertx)Arc.container().instance(Vertx.class, new Annotation[0]).get();
                        Context vdc = VertxContext.getOrCreateDuplicatedContext((Vertx)vertx);
                        VertxContextSafetyToggle.setContextSafe((Context)vdc, (boolean)true);
                        try {
                            ScheduledInvoker invoker = context.createInvoker(metadata.getInvokerClassName());
                            if (invoker.isBlocking()) {
                                vdc.executeBlocking(p -> {
                                    try {
                                        invoker.invoke((ScheduledExecution)new DevModeScheduledExecution());
                                    }
                                    catch (Exception exception) {
                                    }
                                    finally {
                                        p.complete();
                                    }
                                }, false);
                            } else {
                                vdc.runOnContext(x -> {
                                    try {
                                        invoker.invoke((ScheduledExecution)new DevModeScheduledExecution());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                });
                            }
                            LOG.infof("Invoked scheduled method %s via Dev UI", (Object)name);
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Unable to invoke a @Scheduled method: " + metadata.getMethodDescription()), (Throwable)e);
                        }
                        this.flashMessage(ctx, "Action invoked");
                        return;
                    }
                    this.flashMessage(ctx, "Action not found: " + name, FlashScopeUtil.FlashMessageStatus.ERROR);
                }
            }
        };
    }

    private static class DevModeScheduledExecution
    implements ScheduledExecution {
        private final Instant now = Instant.now();

        DevModeScheduledExecution() {
        }

        public Trigger getTrigger() {
            return new Trigger(){

                public String getId() {
                    return "dev-console";
                }

                public Instant getNextFireTime() {
                    return null;
                }

                public Instant getPreviousFireTime() {
                    return now;
                }

                public boolean isOverdue() {
                    return false;
                }
            };
        }

        public Instant getFireTime() {
            return this.now;
        }

        public Instant getScheduledFireTime() {
            return this.now;
        }
    }
}

