/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.runtime;

import com.cronutils.model.CronType;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.common.runtime.ImmutableScheduledMethod;
import io.quarkus.scheduler.common.runtime.MutableScheduledMethod;
import io.quarkus.scheduler.common.runtime.ScheduledMethod;
import io.quarkus.scheduler.common.runtime.SchedulerContext;
import io.quarkus.scheduler.runtime.SchedulerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

@Recorder
public class SchedulerRecorder {
    public Supplier<Object> createContext(final SchedulerConfig config, List<MutableScheduledMethod> scheduledMethods, final boolean forceSchedulerStart, final String autoImplementation) {
        final List<ScheduledMethod> metadata = this.immutableCopy(scheduledMethods);
        return new Supplier<Object>(){

            @Override
            public Object get() {
                return new SchedulerContext(){

                    public CronType getCronType() {
                        return config.cronType;
                    }

                    public List<ScheduledMethod> getScheduledMethods() {
                        return metadata;
                    }

                    public boolean forceSchedulerStart() {
                        return forceSchedulerStart;
                    }

                    public List<ScheduledMethod> getScheduledMethods(String implementation) {
                        ArrayList<ScheduledMethod> ret = new ArrayList<ScheduledMethod>(metadata.size());
                        for (ScheduledMethod method : metadata) {
                            for (Scheduled scheduled : method.getSchedules()) {
                                if (!this.matchesImplementation(scheduled, implementation)) continue;
                                ret.add(method);
                            }
                        }
                        return ret;
                    }

                    public boolean matchesImplementation(Scheduled scheduled, String implementation) {
                        return scheduled.executeWith().equals(implementation) || autoImplementation.equals(implementation) && scheduled.executeWith().equals("<<auto>>");
                    }

                    public String autoImplementation() {
                        return autoImplementation;
                    }
                };
            }
        };
    }

    private List<ScheduledMethod> immutableCopy(List<MutableScheduledMethod> scheduledMethods) {
        ArrayList<ImmutableScheduledMethod> metadata = new ArrayList<ImmutableScheduledMethod>(scheduledMethods.size());
        for (ScheduledMethod scheduledMethod : scheduledMethods) {
            metadata.add(new ImmutableScheduledMethod(scheduledMethod.getInvokerClassName(), scheduledMethod.getDeclaringClassName(), scheduledMethod.getMethodName(), scheduledMethod.getSchedules()));
        }
        return List.copyOf(metadata);
    }
}

