/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.runtime;

import io.quarkus.arc.All;
import io.quarkus.scheduler.Scheduler;
import io.quarkus.scheduler.Trigger;
import io.quarkus.scheduler.common.runtime.AbstractJobDefinition;
import io.quarkus.scheduler.common.runtime.SchedulerContext;
import io.quarkus.scheduler.runtime.Constituent;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Typed(value={Scheduler.class})
@Singleton
public class CompositeScheduler
implements Scheduler {
    private final List<Scheduler> schedulers;
    private final SchedulerContext schedulerContext;

    CompositeScheduler(@All @Constituent List<Scheduler> schedulers, SchedulerContext schedulerContext) {
        this.schedulers = schedulers;
        this.schedulerContext = schedulerContext;
    }

    public boolean isStarted() {
        for (Scheduler scheduler : this.schedulers) {
            if (!scheduler.isStarted()) continue;
            return true;
        }
        return false;
    }

    public void pause() {
        for (Scheduler scheduler : this.schedulers) {
            scheduler.pause();
        }
    }

    public void pause(String identity) {
        for (Scheduler scheduler : this.schedulers) {
            scheduler.pause(identity);
        }
    }

    public void resume() {
        for (Scheduler scheduler : this.schedulers) {
            scheduler.resume();
        }
    }

    public void resume(String identity) {
        for (Scheduler scheduler : this.schedulers) {
            scheduler.resume(identity);
        }
    }

    public boolean isPaused(String identity) {
        for (Scheduler scheduler : this.schedulers) {
            if (!scheduler.isPaused(identity)) continue;
            return true;
        }
        return false;
    }

    public boolean isRunning() {
        for (Scheduler scheduler : this.schedulers) {
            if (!scheduler.isRunning()) continue;
            return true;
        }
        return false;
    }

    public List<Trigger> getScheduledJobs() {
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        for (Scheduler scheduler : this.schedulers) {
            triggers.addAll(scheduler.getScheduledJobs());
        }
        return triggers;
    }

    public Trigger getScheduledJob(String identity) {
        for (Scheduler scheduler : this.schedulers) {
            Trigger trigger = scheduler.getScheduledJob(identity);
            if (trigger == null) continue;
            return trigger;
        }
        return null;
    }

    public CompositeJobDefinition newJob(String identity) {
        return new CompositeJobDefinition(identity);
    }

    public Trigger unscheduleJob(String identity) {
        for (Scheduler scheduler : this.schedulers) {
            Trigger trigger = scheduler.unscheduleJob(identity);
            if (trigger == null) continue;
            return trigger;
        }
        return null;
    }

    public String implementation() {
        return "<<auto>>";
    }

    public class CompositeJobDefinition
    extends AbstractJobDefinition<CompositeJobDefinition> {
        public CompositeJobDefinition(String identity) {
            super(identity);
        }

        public CompositeJobDefinition setExecuteWith(String implementation) {
            Objects.requireNonNull(implementation);
            if (!"<<auto>>".equals(implementation)) {
                if (CompositeScheduler.this.schedulers.stream().map(Scheduler::implementation).noneMatch(implementation::equals)) {
                    throw new IllegalArgumentException("Scheduler implementation not available: " + implementation);
                }
            }
            return (CompositeJobDefinition)super.setExecuteWith(implementation);
        }

        public Trigger schedule() {
            String impl = this.implementation;
            if ("<<auto>>".equals(impl)) {
                impl = CompositeScheduler.this.schedulerContext.autoImplementation();
            }
            for (Scheduler scheduler : CompositeScheduler.this.schedulers) {
                if (!scheduler.implementation().equals(impl)) continue;
                return this.copy(scheduler.newJob(this.identity)).schedule();
            }
            throw new IllegalStateException("Matching scheduler implementation not found: " + this.implementation);
        }

        private Scheduler.JobDefinition<?> copy(Scheduler.JobDefinition<?> to) {
            to.setCron(this.cron);
            to.setInterval(this.every);
            to.setDelayed(this.delayed);
            to.setOverdueGracePeriod(this.overdueGracePeriod);
            to.setConcurrentExecution(this.concurrentExecution);
            to.setTimeZone(this.timeZone);
            to.setExecuteWith(this.implementation);
            if (this.skipPredicateClass != null) {
                to.setSkipPredicate(this.skipPredicateClass);
            } else if (this.skipPredicate != null) {
                to.setSkipPredicate(this.skipPredicate);
            }
            if (this.taskClass != null) {
                if (this.runOnVirtualThread) {
                    to.setTask(this.taskClass, this.runOnVirtualThread);
                } else {
                    to.setTask(this.taskClass);
                }
            } else if (this.task != null) {
                if (this.runOnVirtualThread) {
                    to.setTask(this.task, this.runOnVirtualThread);
                } else {
                    to.setTask(this.task);
                }
            }
            if (this.asyncTaskClass != null) {
                to.setAsyncTask(this.asyncTaskClass);
            } else if (this.asyncTask != null) {
                to.setAsyncTask(this.asyncTask);
            }
            return to;
        }
    }
}

