/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanRegistrarBuildItem;
import io.quarkus.arc.deployment.InterceptorBindingRegistrarBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.security.deployment.DenyingUnannotatedTransformer;
import io.quarkus.security.deployment.JCAProviderBuildItem;
import io.quarkus.security.deployment.SecurityAnnotationsRegistrar;
import io.quarkus.security.deployment.SecurityConfig;
import io.quarkus.security.runtime.IdentityProviderManagerCreator;
import io.quarkus.security.runtime.SecurityBuildTimeConfig;
import io.quarkus.security.runtime.SecurityIdentityAssociation;
import io.quarkus.security.runtime.SecurityIdentityProxy;
import io.quarkus.security.runtime.interceptor.AuthenticatedInterceptor;
import io.quarkus.security.runtime.interceptor.DenyAllInterceptor;
import io.quarkus.security.runtime.interceptor.PermitAllInterceptor;
import io.quarkus.security.runtime.interceptor.RolesAllowedInterceptor;
import io.quarkus.security.runtime.interceptor.SecurityCheckStorage;
import io.quarkus.security.runtime.interceptor.SecurityCheckStorageBuilder;
import io.quarkus.security.runtime.interceptor.SecurityConstrainer;
import io.quarkus.security.runtime.interceptor.SecurityHandler;
import io.quarkus.security.spi.AdditionalSecuredClassesBuildIem;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SecurityProcessor {
    private static final Logger log = Logger.getLogger(SecurityProcessor.class);
    SecurityConfig security;

    @BuildStep
    void services(BuildProducer<JCAProviderBuildItem> jcaProviders) {
        if (this.security.securityProviders != null) {
            for (String providerName : this.security.securityProviders) {
                jcaProviders.produce((BuildItem)new JCAProviderBuildItem(providerName));
                log.debugf("Added providerName: %s", (Object)providerName);
            }
        }
    }

    @BuildStep
    void registerJCAProviders(BuildProducer<ReflectiveClassBuildItem> classes, List<JCAProviderBuildItem> jcaProviders) {
        for (JCAProviderBuildItem provider : jcaProviders) {
            List<String> providerClasses = this.registerProvider(provider.getProviderName());
            for (String className : providerClasses) {
                classes.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{className}));
                log.debugf("Register JCA class: %s", (Object)className);
            }
        }
    }

    @BuildStep
    void transformSecurityAnnotations(BuildProducer<AnnotationsTransformerBuildItem> transformers, SecurityBuildTimeConfig config) {
        if (config.denyUnannotated) {
            transformers.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new DenyingUnannotatedTransformer()));
        }
    }

    @BuildStep
    void registerSecurityInterceptors(BuildProducer<InterceptorBindingRegistrarBuildItem> registrars, BuildProducer<AdditionalBeanBuildItem> beans) {
        registrars.produce((BuildItem)new InterceptorBindingRegistrarBuildItem((InterceptorBindingRegistrar)new SecurityAnnotationsRegistrar()));
        Class[] interceptors = new Class[]{AuthenticatedInterceptor.class, DenyAllInterceptor.class, PermitAllInterceptor.class, RolesAllowedInterceptor.class};
        beans.produce((BuildItem)new AdditionalBeanBuildItem(interceptors));
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SecurityHandler.class, SecurityConstrainer.class}));
    }

    @BuildStep
    void gatherSecurityChecks(BuildProducer<BeanRegistrarBuildItem> beanRegistrars, final BeanArchiveIndexBuildItem beanArchiveBuildItem, BuildProducer<ApplicationClassPredicateBuildItem> classPredicate, List<AdditionalSecuredClassesBuildIem> additionalSecuredClasses) {
        classPredicate.produce((BuildItem)new ApplicationClassPredicateBuildItem((Predicate)new SecurityCheckStorage.AppPredicate()));
        final HashSet additionalSecured = new HashSet();
        if (additionalSecuredClasses != null) {
            for (AdditionalSecuredClassesBuildIem securedClasses : additionalSecuredClasses) {
                additionalSecured.addAll(securedClasses.additionalSecuredClasses);
            }
        }
        beanRegistrars.produce((BuildItem)new BeanRegistrarBuildItem(new BeanRegistrar(){

            public void register(BeanRegistrar.RegistrationContext registrationContext) {
                Map methodAnnotations = SecurityProcessor.this.gatherSecurityAnnotationsByLooping(beanArchiveBuildItem.getIndex(), registrationContext, additionalSecured);
                DotName name = DotName.createSimple((String)SecurityCheckStorage.class.getName());
                BeanConfigurator configurator = registrationContext.configure(name);
                configurator.addType(name);
                configurator.scope(BuiltinScope.APPLICATION.getInfo());
                configurator.creator(m -> {
                    ResultHandle storageBuilder = m.newInstance(MethodDescriptor.ofConstructor(SecurityCheckStorageBuilder.class, (Class[])new Class[0]), new ResultHandle[0]);
                    for (Map.Entry methodEntry : methodAnnotations.entrySet()) {
                        SecurityProcessor.this.registerSecuredMethod(storageBuilder, m, methodEntry);
                    }
                    ResultHandle ret = m.invokeVirtualMethod(MethodDescriptor.ofMethod(SecurityCheckStorageBuilder.class, (String)"create", SecurityCheckStorage.class, (Class[])new Class[0]), storageBuilder, new ResultHandle[0]);
                    m.returnValue(ret);
                });
                configurator.done();
            }
        }));
    }

    private void registerSecuredMethod(ResultHandle checkStorage, MethodCreator methodCreator, Map.Entry<MethodInfo, AnnotationInstance> methodEntry) {
        try {
            MethodInfo method = methodEntry.getKey();
            ResultHandle aClass = methodCreator.load(method.declaringClass().name().toString());
            ResultHandle methodName = methodCreator.load(method.name());
            ResultHandle params = this.paramTypes(methodCreator, method.parameters());
            AnnotationInstance instance = methodEntry.getValue();
            ResultHandle securityAnnotation = methodCreator.load(instance.name().toString());
            ResultHandle annotationParameters = this.annotationValues(methodCreator, instance);
            Method registerAnnotation = SecurityCheckStorageBuilder.class.getDeclaredMethod("registerAnnotation", String.class, String.class, String[].class, String.class, String[].class);
            methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Method)registerAnnotation), checkStorage, new ResultHandle[]{aClass, methodName, params, securityAnnotation, annotationParameters});
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("registerAnnotation method not found on on SecurityCheckStorage", e);
        }
    }

    private ResultHandle annotationValues(MethodCreator methodCreator, AnnotationInstance instance) {
        AnnotationValue value = instance.value();
        if (value != null && value.asStringArray() != null) {
            String[] values = value.asStringArray();
            ResultHandle result = methodCreator.newArray(String.class, methodCreator.load(values.length));
            int i = 0;
            for (String val : values) {
                methodCreator.writeArrayValue(result, i++, methodCreator.load(val));
            }
            return result;
        }
        return methodCreator.loadNull();
    }

    private ResultHandle paramTypes(MethodCreator ctor, List<Type> parameters) {
        ResultHandle result = ctor.newArray(String.class, ctor.load(parameters.size()));
        for (int i = 0; i < parameters.size(); ++i) {
            ctor.writeArrayValue(result, i, ctor.load(parameters.get(i).name().toString()));
        }
        return result;
    }

    private Map<MethodInfo, AnnotationInstance> gatherSecurityAnnotationsByLooping(IndexView index, BeanRegistrar.RegistrationContext registrationContext, Set<ClassInfo> additionalSecuredClasses) {
        Set<DotName> securityAnnotations = SecurityAnnotationsRegistrar.SECURITY_BINDINGS.keySet();
        AnnotationStore annotationStore = (AnnotationStore)registrationContext.get(BuildExtension.Key.ANNOTATION_STORE);
        HashSet<ClassInfo> classesWithSecurity = new HashSet<ClassInfo>(additionalSecuredClasses);
        for (DotName securityAnno : SecurityAnnotationsRegistrar.SECURITY_BINDINGS.keySet()) {
            block5: for (AnnotationInstance annotation : index.getAnnotations(securityAnno)) {
                AnnotationTarget target = annotation.target();
                switch (target.kind()) {
                    case CLASS: {
                        classesWithSecurity.add(target.asClass());
                        continue block5;
                    }
                    case METHOD: {
                        classesWithSecurity.add(target.asMethod().declaringClass());
                        continue block5;
                    }
                }
                throw new IllegalStateException("Security annotation discovered on unsupported target: " + target);
            }
        }
        return this.gatherSecurityAnnotations(securityAnnotations, classesWithSecurity, annotationStore);
    }

    private Map<MethodInfo, AnnotationInstance> gatherSecurityAnnotations(Set<DotName> securityAnnotations, Set<ClassInfo> classesWithSecurity, AnnotationStore annotationStore) {
        HashMap<MethodInfo, AnnotationInstance> methodAnnotations = new HashMap<MethodInfo, AnnotationInstance>();
        for (ClassInfo classInfo : classesWithSecurity) {
            Collection classAnnotations = annotationStore.getAnnotations((AnnotationTarget)classInfo);
            AnnotationInstance classLevelAnnotation = this.getSingle(classAnnotations, securityAnnotations);
            for (MethodInfo method : classInfo.methods()) {
                AnnotationInstance methodAnnotation = this.getSingle(annotationStore.getAnnotations((AnnotationTarget)method), securityAnnotations);
                methodAnnotation = methodAnnotation == null ? classLevelAnnotation : methodAnnotation;
                if (methodAnnotation == null) continue;
                methodAnnotations.put(method, methodAnnotation);
            }
        }
        return methodAnnotations;
    }

    private AnnotationInstance getSingle(Collection<AnnotationInstance> classAnnotations, Set<DotName> securityAnnotations) {
        AnnotationInstance result = null;
        for (AnnotationInstance annotation : classAnnotations) {
            if (!securityAnnotations.contains(annotation.name())) continue;
            if (result != null) {
                throw new IllegalStateException("Multiple security annotations on target: " + annotation.target());
            }
            result = annotation;
        }
        return result;
    }

    private List<String> registerProvider(String providerName) {
        ArrayList<String> providerClasses = new ArrayList<String>();
        Provider provider = Security.getProvider(providerName);
        providerClasses.add(provider.getClass().getName());
        Set<Provider.Service> services = provider.getServices();
        for (Provider.Service service : services) {
            String serviceClass = service.getClassName();
            providerClasses.add(serviceClass);
            String supportedKeyClasses = service.getAttribute("SupportedKeyClasses");
            if (supportedKeyClasses == null) continue;
            String[] keyClasses = supportedKeyClasses.split("\\|");
            providerClasses.addAll(Arrays.asList(keyClasses));
        }
        return providerClasses;
    }

    @BuildStep(providesCapabilities={"io.quarkus.security"})
    FeatureBuildItem feature() {
        return new FeatureBuildItem("security");
    }

    @BuildStep
    void registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> beans) {
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SecurityIdentityAssociation.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(IdentityProviderManagerCreator.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SecurityIdentityProxy.class));
    }
}

