/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.security.runtime.interceptor.check.AuthenticatedCheck;
import io.quarkus.security.runtime.interceptor.check.DenyAllCheck;
import io.quarkus.security.runtime.interceptor.check.PermitAllCheck;
import io.quarkus.security.runtime.interceptor.check.RolesAllowedCheck;
import java.util.function.Function;

public class SecurityCheckInstantiationUtil {
    private SecurityCheckInstantiationUtil() {
    }

    public static Function<BytecodeCreator, ResultHandle> rolesAllowedSecurityCheck(final String ... rolesAllowed) {
        return new Function<BytecodeCreator, ResultHandle>(){

            @Override
            public ResultHandle apply(BytecodeCreator creator) {
                if (rolesAllowed == null) {
                    throw new IllegalStateException("Cannot use a null array to create an instance of " + RolesAllowedCheck.class.getName());
                }
                ResultHandle rolesAllowedArgs = creator.newArray(String.class, creator.load(rolesAllowed.length));
                int i = 0;
                for (String val : rolesAllowed) {
                    creator.writeArrayValue(rolesAllowedArgs, i++, creator.load(val));
                }
                return creator.invokeStaticMethod(MethodDescriptor.ofMethod(RolesAllowedCheck.class, (String)"of", RolesAllowedCheck.class, (Class[])new Class[]{String[].class}), new ResultHandle[]{rolesAllowedArgs});
            }
        };
    }

    public static Function<BytecodeCreator, ResultHandle> denyAllSecurityCheck() {
        return new Function<BytecodeCreator, ResultHandle>(){

            @Override
            public ResultHandle apply(BytecodeCreator creator) {
                return creator.readStaticField(FieldDescriptor.of(DenyAllCheck.class, (String)"INSTANCE", DenyAllCheck.class));
            }
        };
    }

    public static Function<BytecodeCreator, ResultHandle> permitAllSecurityCheck() {
        return new Function<BytecodeCreator, ResultHandle>(){

            @Override
            public ResultHandle apply(BytecodeCreator creator) {
                return creator.readStaticField(FieldDescriptor.of(PermitAllCheck.class, (String)"INSTANCE", PermitAllCheck.class));
            }
        };
    }

    public static Function<BytecodeCreator, ResultHandle> authenticatedSecurityCheck() {
        return new Function<BytecodeCreator, ResultHandle>(){

            @Override
            public ResultHandle apply(BytecodeCreator creator) {
                return creator.readStaticField(FieldDescriptor.of(AuthenticatedCheck.class, (String)"INSTANCE", AuthenticatedCheck.class));
            }
        };
    }
}

