/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanRegistrarBuildItem;
import io.quarkus.arc.deployment.InterceptorBindingRegistrarBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BeanRegistrar;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.security.deployment.AdditionalDenyingUnannotatedTransformer;
import io.quarkus.security.deployment.AdditionalSecurityCheckBuildItem;
import io.quarkus.security.deployment.DenyingUnannotatedTransformer;
import io.quarkus.security.deployment.DotNames;
import io.quarkus.security.deployment.JCAProviderBuildItem;
import io.quarkus.security.deployment.SecurityAnnotationsRegistrar;
import io.quarkus.security.deployment.SecurityCheckInstantiationUtil;
import io.quarkus.security.deployment.SecurityConfig;
import io.quarkus.security.runtime.IdentityProviderManagerCreator;
import io.quarkus.security.runtime.SecurityBuildTimeConfig;
import io.quarkus.security.runtime.SecurityIdentityAssociation;
import io.quarkus.security.runtime.SecurityIdentityProxy;
import io.quarkus.security.runtime.X509IdentityProvider;
import io.quarkus.security.runtime.interceptor.AuthenticatedInterceptor;
import io.quarkus.security.runtime.interceptor.DenyAllInterceptor;
import io.quarkus.security.runtime.interceptor.PermitAllInterceptor;
import io.quarkus.security.runtime.interceptor.RolesAllowedInterceptor;
import io.quarkus.security.runtime.interceptor.SecurityCheckStorage;
import io.quarkus.security.runtime.interceptor.SecurityCheckStorageBuilder;
import io.quarkus.security.runtime.interceptor.SecurityConstrainer;
import io.quarkus.security.runtime.interceptor.SecurityHandler;
import io.quarkus.security.runtime.interceptor.check.SecurityCheck;
import io.quarkus.security.spi.AdditionalSecuredClassesBuildIem;
import java.lang.reflect.Modifier;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SecurityProcessor {
    private static final Logger log = Logger.getLogger(SecurityProcessor.class);
    SecurityConfig security;

    @BuildStep
    void services(BuildProducer<JCAProviderBuildItem> jcaProviders) {
        for (String providerName : this.security.securityProviders.orElse(Collections.emptyList())) {
            jcaProviders.produce((BuildItem)new JCAProviderBuildItem(providerName));
            log.debugf("Added providerName: %s", (Object)providerName);
        }
    }

    @BuildStep
    void registerJCAProviders(BuildProducer<ReflectiveClassBuildItem> classes, List<JCAProviderBuildItem> jcaProviders) {
        for (JCAProviderBuildItem provider : jcaProviders) {
            List<String> providerClasses = this.registerProvider(provider.getProviderName());
            for (String className : providerClasses) {
                classes.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{className}));
                log.debugf("Register JCA class: %s", (Object)className);
            }
        }
    }

    @BuildStep
    void registerSecurityInterceptors(BuildProducer<InterceptorBindingRegistrarBuildItem> registrars, BuildProducer<AdditionalBeanBuildItem> beans) {
        registrars.produce((BuildItem)new InterceptorBindingRegistrarBuildItem((InterceptorBindingRegistrar)new SecurityAnnotationsRegistrar()));
        Class[] interceptors = new Class[]{AuthenticatedInterceptor.class, DenyAllInterceptor.class, PermitAllInterceptor.class, RolesAllowedInterceptor.class};
        beans.produce((BuildItem)new AdditionalBeanBuildItem(interceptors));
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SecurityHandler.class, SecurityConstrainer.class}));
    }

    @BuildStep
    void transformSecurityAnnotations(BuildProducer<AnnotationsTransformerBuildItem> transformers, List<AdditionalSecuredClassesBuildIem> additionalSecuredClasses, SecurityBuildTimeConfig config) {
        if (config.denyUnannotated) {
            transformers.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new DenyingUnannotatedTransformer()));
        }
        if (!additionalSecuredClasses.isEmpty()) {
            HashSet<String> additionalSecured = new HashSet<String>();
            for (AdditionalSecuredClassesBuildIem securedClasses : additionalSecuredClasses) {
                for (ClassInfo additionalSecuredClass : securedClasses.additionalSecuredClasses) {
                    additionalSecured.add(additionalSecuredClass.name().toString());
                }
            }
            transformers.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new AdditionalDenyingUnannotatedTransformer(additionalSecured)));
        }
    }

    @BuildStep
    void gatherSecurityChecks(BuildProducer<BeanRegistrarBuildItem> beanRegistrars, final BeanArchiveIndexBuildItem beanArchiveBuildItem, BuildProducer<ApplicationClassPredicateBuildItem> classPredicate, List<AdditionalSecuredClassesBuildIem> additionalSecuredClasses, final List<AdditionalSecurityCheckBuildItem> additionalSecurityChecks, final SecurityBuildTimeConfig config) {
        classPredicate.produce((BuildItem)new ApplicationClassPredicateBuildItem((Predicate)new SecurityCheckStorage.AppPredicate()));
        final HashMap additionalSecured = new HashMap();
        for (AdditionalSecuredClassesBuildIem securedClasses : additionalSecuredClasses) {
            securedClasses.additionalSecuredClasses.forEach(c -> {
                if (!additionalSecured.containsKey(c.name())) {
                    additionalSecured.put(c.name(), c);
                }
            });
        }
        beanRegistrars.produce((BuildItem)new BeanRegistrarBuildItem(new BeanRegistrar(){

            public void register(BeanRegistrar.RegistrationContext registrationContext) {
                IndexView index = beanArchiveBuildItem.getIndex();
                Map securityChecks = SecurityProcessor.this.gatherSecurityAnnotations(index, additionalSecured, config.denyUnannotated);
                for (AdditionalSecurityCheckBuildItem additionalSecurityCheck : additionalSecurityChecks) {
                    securityChecks.put(additionalSecurityCheck.getMethodInfo(), additionalSecurityCheck.getSecurityCheckResultHandleCreator());
                }
                DotName name = DotName.createSimple((String)SecurityCheckStorage.class.getName());
                BeanConfigurator configurator = registrationContext.configure(name);
                configurator.addType(name);
                configurator.scope(BuiltinScope.APPLICATION.getInfo());
                configurator.creator(creator -> {
                    ResultHandle storageBuilder = creator.newInstance(MethodDescriptor.ofConstructor(SecurityCheckStorageBuilder.class, (Class[])new Class[0]), new ResultHandle[0]);
                    for (Map.Entry methodEntry : securityChecks.entrySet()) {
                        SecurityProcessor.this.registerSecuredMethod(storageBuilder, creator, methodEntry);
                    }
                    ResultHandle ret = creator.invokeVirtualMethod(MethodDescriptor.ofMethod(SecurityCheckStorageBuilder.class, (String)"create", SecurityCheckStorage.class, (Class[])new Class[0]), storageBuilder, new ResultHandle[0]);
                    creator.returnValue(ret);
                });
                configurator.done();
            }
        }));
    }

    private void registerSecuredMethod(ResultHandle checkStorage, MethodCreator methodCreator, Map.Entry<MethodInfo, Function<BytecodeCreator, ResultHandle>> methodEntry) {
        MethodInfo methodInfo = methodEntry.getKey();
        ResultHandle declaringClass = methodCreator.load(methodInfo.declaringClass().name().toString());
        ResultHandle methodName = methodCreator.load(methodInfo.name());
        ResultHandle methodParamTypes = this.paramTypes(methodCreator, methodInfo.parameters());
        methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(SecurityCheckStorageBuilder.class, (String)"registerCheck", Void.TYPE, (Class[])new Class[]{String.class, String.class, String[].class, SecurityCheck.class}), checkStorage, new ResultHandle[]{declaringClass, methodName, methodParamTypes, methodEntry.getValue().apply((BytecodeCreator)methodCreator)});
    }

    private ResultHandle paramTypes(MethodCreator ctor, List<Type> parameters) {
        ResultHandle result = ctor.newArray(String.class, parameters.size());
        for (int i = 0; i < parameters.size(); ++i) {
            ctor.writeArrayValue(result, i, ctor.load(parameters.get(i).name().toString()));
        }
        return result;
    }

    private Map<MethodInfo, Function<BytecodeCreator, ResultHandle>> gatherSecurityAnnotations(IndexView index, Map<DotName, ClassInfo> additionalSecuredClasses, boolean denyUnannotated) {
        HashMap<MethodInfo, AnnotationInstance> methodToInstanceCollector = new HashMap<MethodInfo, AnnotationInstance>();
        HashMap<MethodInfo, Function<BytecodeCreator, ResultHandle>> result = new HashMap<MethodInfo, Function<BytecodeCreator, ResultHandle>>(this.gatherSecurityAnnotations(index, DotNames.ROLES_ALLOWED, methodToInstanceCollector, instance -> SecurityCheckInstantiationUtil.rolesAllowedSecurityCheck(instance.value().asStringArray())));
        result.putAll(this.gatherSecurityAnnotations(index, DotNames.PERMIT_ALL, methodToInstanceCollector, instance -> SecurityCheckInstantiationUtil.permitAllSecurityCheck()));
        result.putAll(this.gatherSecurityAnnotations(index, DotNames.AUTHENTICATED, methodToInstanceCollector, instance -> SecurityCheckInstantiationUtil.authenticatedSecurityCheck()));
        result.putAll(this.gatherSecurityAnnotations(index, DotNames.DENY_ALL, methodToInstanceCollector, instance -> SecurityCheckInstantiationUtil.denyAllSecurityCheck()));
        for (Map.Entry<DotName, ClassInfo> additionalSecureClassInfo : additionalSecuredClasses.entrySet()) {
            for (MethodInfo methodInfo : additionalSecureClassInfo.getValue().methods()) {
                if (!this.isPublicNonStaticNonConstructor(methodInfo)) continue;
                AnnotationInstance alreadyExistingInstance = (AnnotationInstance)methodToInstanceCollector.get(methodInfo);
                if (alreadyExistingInstance == null) {
                    result.put(methodInfo, SecurityCheckInstantiationUtil.denyAllSecurityCheck());
                    continue;
                }
                if (alreadyExistingInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                throw new IllegalStateException("Class " + methodInfo.declaringClass() + " should not have been added as an additional secured class");
            }
        }
        if (denyUnannotated) {
            HashSet<ClassInfo> allClassesWithSecurityChecks = new HashSet<ClassInfo>(methodToInstanceCollector.keySet().size());
            for (MethodInfo methodInfo : methodToInstanceCollector.keySet()) {
                allClassesWithSecurityChecks.add(methodInfo.declaringClass());
            }
            for (ClassInfo classWithSecurityCheck : allClassesWithSecurityChecks) {
                for (MethodInfo methodInfo : classWithSecurityCheck.methods()) {
                    if (!this.isPublicNonStaticNonConstructor(methodInfo) || methodToInstanceCollector.containsKey(methodInfo)) continue;
                    result.put(methodInfo, SecurityCheckInstantiationUtil.denyAllSecurityCheck());
                }
            }
        }
        return result;
    }

    private boolean isPublicNonStaticNonConstructor(MethodInfo methodInfo) {
        return Modifier.isPublic(methodInfo.flags()) && !Modifier.isStatic(methodInfo.flags()) && !"<init>".equals(methodInfo.name());
    }

    private Map<MethodInfo, Function<BytecodeCreator, ResultHandle>> gatherSecurityAnnotations(IndexView index, DotName dotName, Map<MethodInfo, AnnotationInstance> alreadyCheckedMethods, Function<AnnotationInstance, Function<BytecodeCreator, ResultHandle>> securityCheckInstanceCreator) {
        AnnotationTarget target;
        HashMap<MethodInfo, Function<BytecodeCreator, ResultHandle>> result = new HashMap<MethodInfo, Function<BytecodeCreator, ResultHandle>>();
        Collection instances = index.getAnnotations(dotName);
        for (AnnotationInstance instance : instances) {
            target = instance.target();
            if (target.kind() != AnnotationTarget.Kind.METHOD) continue;
            MethodInfo methodInfo = target.asMethod();
            if (alreadyCheckedMethods.containsKey(methodInfo)) {
                throw new IllegalStateException("Method " + methodInfo.name() + " of class " + methodInfo.declaringClass() + " is annotated with multiple security annotations");
            }
            alreadyCheckedMethods.put(methodInfo, instance);
            result.put(methodInfo, securityCheckInstanceCreator.apply(instance));
        }
        for (AnnotationInstance instance : instances) {
            target = instance.target();
            if (target.kind() != AnnotationTarget.Kind.CLASS) continue;
            List methods = target.asClass().methods();
            for (MethodInfo methodInfo : methods) {
                AnnotationInstance alreadyExistingInstance = alreadyCheckedMethods.get(methodInfo);
                if (alreadyExistingInstance == null) {
                    result.put(methodInfo, securityCheckInstanceCreator.apply(instance));
                    continue;
                }
                if (alreadyExistingInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                throw new IllegalStateException("Class " + methodInfo.declaringClass() + " is annotated with multiple security annotations");
            }
        }
        return result;
    }

    private List<String> registerProvider(String providerName) {
        ArrayList<String> providerClasses = new ArrayList<String>();
        Provider provider = Security.getProvider(providerName);
        providerClasses.add(provider.getClass().getName());
        Set<Provider.Service> services = provider.getServices();
        for (Provider.Service service : services) {
            String serviceClass = service.getClassName();
            providerClasses.add(serviceClass);
            String supportedKeyClasses = service.getAttribute("SupportedKeyClasses");
            if (supportedKeyClasses == null) continue;
            String[] keyClasses = supportedKeyClasses.split("\\|");
            providerClasses.addAll(Arrays.asList(keyClasses));
        }
        return providerClasses;
    }

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem(Capability.SECURITY);
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SECURITY);
    }

    @BuildStep
    void registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> beans) {
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SecurityIdentityAssociation.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(IdentityProviderManagerCreator.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SecurityIdentityProxy.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(X509IdentityProvider.class));
    }
}

