/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.InterceptorBindingRegistrarBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JPMSExportBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSecurityProviderBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.security.deployment.AdditionalDenyingUnannotatedTransformer;
import io.quarkus.security.deployment.AdditionalRolesAllowedTransformer;
import io.quarkus.security.deployment.AdditionalSecurityCheckBuildItem;
import io.quarkus.security.deployment.BouncyCastleJsseProviderBuildItem;
import io.quarkus.security.deployment.BouncyCastleProviderBuildItem;
import io.quarkus.security.deployment.DenyingUnannotatedTransformer;
import io.quarkus.security.deployment.DotNames;
import io.quarkus.security.deployment.JCAProviderBuildItem;
import io.quarkus.security.deployment.SecurityAnnotationsRegistrar;
import io.quarkus.security.deployment.SecurityConfig;
import io.quarkus.security.runtime.IdentityProviderManagerCreator;
import io.quarkus.security.runtime.SecurityBuildTimeConfig;
import io.quarkus.security.runtime.SecurityCheckRecorder;
import io.quarkus.security.runtime.SecurityIdentityAssociation;
import io.quarkus.security.runtime.SecurityIdentityProxy;
import io.quarkus.security.runtime.SecurityProviderRecorder;
import io.quarkus.security.runtime.SecurityProviderUtils;
import io.quarkus.security.runtime.X509IdentityProvider;
import io.quarkus.security.runtime.interceptor.AuthenticatedInterceptor;
import io.quarkus.security.runtime.interceptor.DenyAllInterceptor;
import io.quarkus.security.runtime.interceptor.PermitAllInterceptor;
import io.quarkus.security.runtime.interceptor.RolesAllowedInterceptor;
import io.quarkus.security.runtime.interceptor.SecurityConstrainer;
import io.quarkus.security.runtime.interceptor.SecurityHandler;
import io.quarkus.security.spi.AdditionalSecuredClassesBuildItem;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.DevModeDisabledAuthorizationController;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.enterprise.context.ApplicationScoped;
import org.graalvm.nativeimage.hosted.Feature;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class SecurityProcessor {
    private static final Logger log = Logger.getLogger(SecurityProcessor.class);
    SecurityConfig security;

    @BuildStep
    void produceJcaSecurityProviders(BuildProducer<JCAProviderBuildItem> jcaProviders, BuildProducer<BouncyCastleProviderBuildItem> bouncyCastleProvider, BuildProducer<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProvider) {
        Set providers = this.security.securityProviders.orElse(Set.of());
        for (String providerName : providers) {
            if ("BC".equals(providerName)) {
                bouncyCastleProvider.produce((BuildItem)new BouncyCastleProviderBuildItem());
            } else if ("BCJSSE".equals(providerName)) {
                bouncyCastleJsseProvider.produce((BuildItem)new BouncyCastleJsseProviderBuildItem());
            } else if ("BCFIPS".equals(providerName)) {
                bouncyCastleProvider.produce((BuildItem)new BouncyCastleProviderBuildItem(true));
            } else if ("BCFIPSJSSE".equals(providerName)) {
                bouncyCastleJsseProvider.produce((BuildItem)new BouncyCastleJsseProviderBuildItem(true));
            } else {
                jcaProviders.produce((BuildItem)new JCAProviderBuildItem(providerName, this.security.securityProviderConfig.get(providerName)));
            }
            log.debugf("Added providerName: %s", (Object)providerName);
        }
    }

    @BuildStep
    void registerJCAProvidersForReflection(BuildProducer<ReflectiveClassBuildItem> classes, List<JCAProviderBuildItem> jcaProviders, BuildProducer<NativeImageSecurityProviderBuildItem> additionalProviders) throws IOException, URISyntaxException {
        for (JCAProviderBuildItem provider : jcaProviders) {
            List<String> providerClasses = this.registerProvider(provider.getProviderName(), provider.getProviderConfig(), additionalProviders);
            for (String className : providerClasses) {
                classes.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{className}));
                log.debugf("Register JCA class: %s", (Object)className);
            }
        }
    }

    @BuildStep
    void prepareBouncyCastleProviders(BuildProducer<ReflectiveClassBuildItem> reflection, BuildProducer<RuntimeReinitializedClassBuildItem> runtimeReInitialized, List<BouncyCastleProviderBuildItem> bouncyCastleProviders, List<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProviders) throws Exception {
        Optional<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProvider = this.getOne(bouncyCastleJsseProviders);
        if (bouncyCastleJsseProvider.isPresent()) {
            reflection.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.bouncycastle.jsse.provider.BouncyCastleJsseProvider"}));
            reflection.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{"org.bouncycastle.jsse.provider.DefaultSSLContextSpi$LazyManagers"}));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.jsse.provider.DefaultSSLContextSpi$LazyManagers"));
            SecurityProcessor.prepareBouncyCastleProvider(reflection, runtimeReInitialized, bouncyCastleJsseProvider.get().isInFipsMode());
        } else {
            Optional<BouncyCastleProviderBuildItem> bouncyCastleProvider = this.getOne(bouncyCastleProviders);
            if (bouncyCastleProvider.isPresent()) {
                SecurityProcessor.prepareBouncyCastleProvider(reflection, runtimeReInitialized, bouncyCastleProvider.get().isInFipsMode());
            }
        }
    }

    private static void prepareBouncyCastleProvider(BuildProducer<ReflectiveClassBuildItem> reflection, BuildProducer<RuntimeReinitializedClassBuildItem> runtimeReInitialized, boolean isFipsMode) {
        reflection.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{isFipsMode ? "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider" : "org.bouncycastle.jce.provider.BouncyCastleProvider"}));
        reflection.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.bouncycastle.jcajce.provider.symmetric.AES", "org.bouncycastle.jcajce.provider.symmetric.AES$CBC", "org.bouncycastle.crypto.paddings.PKCS7Padding", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi$EC", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi$ECDSA", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$EC", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$ECDSA", "org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyFactorySpi", "org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyPairGeneratorSpi", "org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi", "org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$SHA256withRSA"}));
        runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.crypto.CryptoServicesRegistrar"));
        if (!isFipsMode) {
            reflection.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{"org.bouncycastle.jcajce.provider.drbg.DRBG$Default"}));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.jcajce.provider.drbg.DRBG$Default"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.jcajce.provider.drbg.DRBG$NonceAndIV"));
        } else {
            reflection.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{"org.bouncycastle.crypto.general.AES"}));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.crypto.general.AES"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.crypto.asymmetric.NamedECDomainParameters"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.crypto.asymmetric.CustomNamedCurves"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.asn1.ua.DSTU4145NamedCurves"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.asn1.sec.SECNamedCurves"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.asn1.x9.X962NamedCurves"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.asn1.x9.ECNamedCurveTable"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.asn1.anssi.ANSSINamedCurves"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.jcajce.spec.ECUtil"));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void recordBouncyCastleProviders(SecurityProviderRecorder recorder, List<BouncyCastleProviderBuildItem> bouncyCastleProviders, List<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProviders) {
        Optional<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProvider = this.getOne(bouncyCastleJsseProviders);
        if (bouncyCastleJsseProvider.isPresent()) {
            if (bouncyCastleJsseProvider.get().isInFipsMode()) {
                recorder.addBouncyCastleFipsJsseProvider();
            } else {
                recorder.addBouncyCastleJsseProvider();
            }
        } else {
            Optional<BouncyCastleProviderBuildItem> bouncyCastleProvider = this.getOne(bouncyCastleProviders);
            if (bouncyCastleProvider.isPresent()) {
                recorder.addBouncyCastleProvider(bouncyCastleProvider.get().isInFipsMode());
            }
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    NativeImageFeatureBuildItem bouncyCastleFeature(List<BouncyCastleProviderBuildItem> bouncyCastleProviders, List<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProviders) {
        Optional<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProvider = this.getOne(bouncyCastleJsseProviders);
        Optional<BouncyCastleProviderBuildItem> bouncyCastleProvider = this.getOne(bouncyCastleProviders);
        if (bouncyCastleJsseProvider.isPresent() || bouncyCastleProvider.isPresent()) {
            return new NativeImageFeatureBuildItem("io.quarkus.security.BouncyCastleFeature");
        }
        return null;
    }

    @BuildStep
    void addBouncyCastleProvidersToNativeImage(final BuildProducer<GeneratedNativeImageClassBuildItem> nativeImageClass, BuildProducer<NativeImageSecurityProviderBuildItem> additionalProviders, List<BouncyCastleProviderBuildItem> bouncyCastleProviders, List<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProviders) {
        Optional<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProvider = this.getOne(bouncyCastleJsseProviders);
        Optional<BouncyCastleProviderBuildItem> bouncyCastleProvider = this.getOne(bouncyCastleProviders);
        if (bouncyCastleJsseProvider.isPresent() || bouncyCastleProvider.isPresent()) {
            ClassCreator file = new ClassCreator(new ClassOutput(){

                public void write(String s, byte[] bytes) {
                    nativeImageClass.produce((BuildItem)new GeneratedNativeImageClassBuildItem(s, bytes));
                }
            }, "io.quarkus.security.BouncyCastleFeature", null, Object.class.getName(), new String[]{org.graalvm.nativeimage.hosted.Feature.class.getName()});
            MethodCreator afterRegistration = file.getMethodCreator("afterRegistration", "V", new String[]{Feature.AfterRegistrationAccess.class.getName()});
            TryBlock overallCatch = afterRegistration.tryBlock();
            if (bouncyCastleJsseProvider.isPresent()) {
                additionalProviders.produce((BuildItem)new NativeImageSecurityProviderBuildItem("org.bouncycastle.jsse.provider.BouncyCastleJsseProvider"));
                if (!bouncyCastleJsseProvider.get().isInFipsMode()) {
                    int sunJsseIndex = SecurityProviderUtils.findProviderIndex((String)"SunJSSE");
                    ResultHandle bcProvider = overallCatch.newInstance(MethodDescriptor.ofConstructor((String)"org.bouncycastle.jce.provider.BouncyCastleProvider", (String[])new String[0]), new ResultHandle[0]);
                    ResultHandle bcJsseProvider = overallCatch.newInstance(MethodDescriptor.ofConstructor((String)"org.bouncycastle.jsse.provider.BouncyCastleJsseProvider", (String[])new String[0]), new ResultHandle[0]);
                    overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Security.class, (String)"insertProviderAt", Integer.TYPE, (Class[])new Class[]{Provider.class, Integer.TYPE}), new ResultHandle[]{bcProvider, overallCatch.load(sunJsseIndex)});
                    overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Security.class, (String)"insertProviderAt", Integer.TYPE, (Class[])new Class[]{Provider.class, Integer.TYPE}), new ResultHandle[]{bcJsseProvider, overallCatch.load(sunJsseIndex + 1)});
                } else {
                    int sunIndex = SecurityProviderUtils.findProviderIndex((String)"SUN");
                    ResultHandle bcFipsProvider = overallCatch.newInstance(MethodDescriptor.ofConstructor((String)"org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider", (String[])new String[0]), new ResultHandle[0]);
                    MethodDescriptor bcJsseProviderConstructor = MethodDescriptor.ofConstructor((String)"org.bouncycastle.jsse.provider.BouncyCastleJsseProvider", (String[])new String[]{"boolean", Provider.class.getName()});
                    ResultHandle bcJsseProvider = overallCatch.newInstance(bcJsseProviderConstructor, new ResultHandle[]{overallCatch.load(true), bcFipsProvider});
                    overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Security.class, (String)"insertProviderAt", Integer.TYPE, (Class[])new Class[]{Provider.class, Integer.TYPE}), new ResultHandle[]{bcFipsProvider, overallCatch.load(sunIndex)});
                    overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Security.class, (String)"insertProviderAt", Integer.TYPE, (Class[])new Class[]{Provider.class, Integer.TYPE}), new ResultHandle[]{bcJsseProvider, overallCatch.load(sunIndex + 1)});
                }
            } else {
                String providerName = bouncyCastleProvider.get().isInFipsMode() ? "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider" : "org.bouncycastle.jce.provider.BouncyCastleProvider";
                ResultHandle bcProvider = overallCatch.newInstance(MethodDescriptor.ofConstructor((String)providerName, (String[])new String[0]), new ResultHandle[0]);
                overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Security.class, (String)"addProvider", Integer.TYPE, (Class[])new Class[]{Provider.class}), new ResultHandle[]{bcProvider});
            }
            CatchBlockCreator print = overallCatch.addCatch(Throwable.class);
            print.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), print.getCaughtException(), new ResultHandle[0]);
            afterRegistration.returnValue(null);
            file.close();
        }
    }

    @BuildStep
    void addBouncyCastleExportsToNativeImage(BuildProducer<JPMSExportBuildItem> jpmsExports, List<BouncyCastleProviderBuildItem> bouncyCastleProviders, List<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProviders) {
        boolean isInFipsMode;
        Optional<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProvider = this.getOne(bouncyCastleJsseProviders);
        if (bouncyCastleJsseProvider.isPresent()) {
            isInFipsMode = bouncyCastleJsseProvider.get().isInFipsMode();
        } else {
            Optional<BouncyCastleProviderBuildItem> bouncyCastleProvider = this.getOne(bouncyCastleProviders);
            boolean bl = isInFipsMode = bouncyCastleProvider.isPresent() && bouncyCastleProvider.get().isInFipsMode();
        }
        if (isInFipsMode) {
            jpmsExports.produce((BuildItem)new JPMSExportBuildItem("java.base", "sun.security.internal.spec"));
            jpmsExports.produce((BuildItem)new JPMSExportBuildItem("java.base", "sun.security.provider"));
        }
    }

    private <BI extends MultiBuildItem> Optional<BI> getOne(List<BI> items) {
        if (items.size() > 1) {
            throw new IllegalStateException("Only a single Bouncy Castle registration can be provided.");
        }
        return items.stream().findFirst();
    }

    private List<String> registerProvider(String providerName, String providerConfig, BuildProducer<NativeImageSecurityProviderBuildItem> additionalProviders) {
        ArrayList<String> providerClasses = new ArrayList<String>();
        Provider provider = Security.getProvider(providerName);
        if (provider != null) {
            Provider configuredProvider;
            providerClasses.add(provider.getClass().getName());
            for (Provider.Service service : provider.getServices()) {
                providerClasses.add(service.getClassName());
                String supportedKeyClasses = service.getAttribute("SupportedKeyClasses");
                if (supportedKeyClasses == null) continue;
                providerClasses.addAll(Arrays.asList(supportedKeyClasses.split("\\|")));
            }
            if (providerConfig != null && (configuredProvider = provider.configure(providerConfig)) != null) {
                Security.addProvider(configuredProvider);
                providerClasses.add(configuredProvider.getClass().getName());
            }
        }
        if (SecurityProviderUtils.SUN_PROVIDERS.containsKey(providerName)) {
            additionalProviders.produce((BuildItem)new NativeImageSecurityProviderBuildItem((String)SecurityProviderUtils.SUN_PROVIDERS.get(providerName)));
        }
        return providerClasses;
    }

    @BuildStep
    void registerSecurityInterceptors(BuildProducer<InterceptorBindingRegistrarBuildItem> registrars, BuildProducer<AdditionalBeanBuildItem> beans) {
        registrars.produce((BuildItem)new InterceptorBindingRegistrarBuildItem((InterceptorBindingRegistrar)new SecurityAnnotationsRegistrar()));
        Class[] interceptors = new Class[]{AuthenticatedInterceptor.class, DenyAllInterceptor.class, PermitAllInterceptor.class, RolesAllowedInterceptor.class};
        beans.produce((BuildItem)new AdditionalBeanBuildItem(interceptors));
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SecurityHandler.class, SecurityConstrainer.class}));
    }

    @BuildStep
    void transformSecurityAnnotations(BuildProducer<AnnotationsTransformerBuildItem> transformers, List<AdditionalSecuredClassesBuildItem> additionalSecuredClasses, SecurityBuildTimeConfig config) {
        if (config.denyUnannotated) {
            transformers.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new DenyingUnannotatedTransformer()));
        }
        if (!additionalSecuredClasses.isEmpty()) {
            for (AdditionalSecuredClassesBuildItem securedClasses : additionalSecuredClasses) {
                HashSet<String> additionalSecured = new HashSet<String>();
                for (ClassInfo additionalSecuredClass : securedClasses.additionalSecuredClasses) {
                    additionalSecured.add(additionalSecuredClass.name().toString());
                }
                if (securedClasses.rolesAllowed.isPresent()) {
                    transformers.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new AdditionalRolesAllowedTransformer(additionalSecured, (List)securedClasses.rolesAllowed.get())));
                    continue;
                }
                transformers.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new AdditionalDenyingUnannotatedTransformer(additionalSecured)));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void gatherSecurityChecks(BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BeanArchiveIndexBuildItem beanArchiveBuildItem, BuildProducer<ApplicationClassPredicateBuildItem> classPredicate, List<AdditionalSecuredClassesBuildItem> additionalSecuredClasses, SecurityCheckRecorder recorder, List<AdditionalSecurityCheckBuildItem> additionalSecurityChecks, SecurityBuildTimeConfig config) {
        classPredicate.produce((BuildItem)new ApplicationClassPredicateBuildItem((Predicate)new SecurityCheckStorageAppPredicate()));
        HashMap<DotName, AdditionalSecured> additionalSecured = new HashMap<DotName, AdditionalSecured>();
        for (AdditionalSecuredClassesBuildItem securedClasses : additionalSecuredClasses) {
            securedClasses.additionalSecuredClasses.forEach(c -> {
                if (!additionalSecured.containsKey(c.name())) {
                    additionalSecured.put(c.name(), new AdditionalSecured((ClassInfo)c, securedClasses.rolesAllowed));
                }
            });
        }
        IndexView index = beanArchiveBuildItem.getIndex();
        Map<MethodInfo, SecurityCheck> securityChecks = this.gatherSecurityAnnotations(index, additionalSecured, config.denyUnannotated, recorder);
        for (AdditionalSecurityCheckBuildItem additionalSecurityCheck : additionalSecurityChecks) {
            securityChecks.put(additionalSecurityCheck.getMethodInfo(), additionalSecurityCheck.getSecurityCheck());
        }
        RuntimeValue builder = recorder.newBuilder();
        for (Map.Entry<MethodInfo, SecurityCheck> methodEntry : securityChecks.entrySet()) {
            MethodInfo method = methodEntry.getKey();
            String[] params = new String[method.parametersCount()];
            for (int i = 0; i < method.parametersCount(); ++i) {
                params[i] = method.parameterType(i).name().toString();
            }
            recorder.addMethod(builder, method.declaringClass().name().toString(), method.name(), params, methodEntry.getValue());
        }
        recorder.create(builder);
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SecurityCheckStorage.class).scope(ApplicationScoped.class)).unremovable()).creator(creator -> {
            ResultHandle ret = creator.invokeStaticMethod(MethodDescriptor.ofMethod(SecurityCheckRecorder.class, (String)"getStorage", SecurityCheckStorage.class, (Class[])new Class[0]), new ResultHandle[0]);
            creator.returnValue(ret);
        })).done());
    }

    private Map<MethodInfo, SecurityCheck> gatherSecurityAnnotations(IndexView index, Map<DotName, AdditionalSecured> additionalSecuredClasses, boolean denyUnannotated, SecurityCheckRecorder recorder) {
        HashMap<MethodInfo, AnnotationInstance> methodToInstanceCollector = new HashMap<MethodInfo, AnnotationInstance>();
        HashMap<ClassInfo, AnnotationInstance> classAnnotations = new HashMap<ClassInfo, AnnotationInstance>();
        HashMap<MethodInfo, SecurityCheck> result = new HashMap<MethodInfo, SecurityCheck>(this.gatherSecurityAnnotations(index, DotNames.ROLES_ALLOWED, methodToInstanceCollector, classAnnotations, instance -> recorder.rolesAllowed(instance.value().asStringArray())));
        result.putAll(this.gatherSecurityAnnotations(index, DotNames.PERMIT_ALL, methodToInstanceCollector, classAnnotations, instance -> recorder.permitAll()));
        result.putAll(this.gatherSecurityAnnotations(index, DotNames.AUTHENTICATED, methodToInstanceCollector, classAnnotations, instance -> recorder.authenticated()));
        result.putAll(this.gatherSecurityAnnotations(index, DotNames.DENY_ALL, methodToInstanceCollector, classAnnotations, instance -> recorder.denyAll()));
        for (Map.Entry<DotName, AdditionalSecured> additionalSecureClassInfo : additionalSecuredClasses.entrySet()) {
            for (MethodInfo methodInfo : additionalSecureClassInfo.getValue().classInfo.methods()) {
                if (!this.isPublicNonStaticNonConstructor(methodInfo)) continue;
                AnnotationInstance alreadyExistingInstance = (AnnotationInstance)methodToInstanceCollector.get(methodInfo);
                if (alreadyExistingInstance == null) {
                    if (additionalSecureClassInfo.getValue().rolesAllowed.isPresent()) {
                        result.put(methodInfo, recorder.rolesAllowed((String[])additionalSecureClassInfo.getValue().rolesAllowed.get().toArray(String[]::new)));
                        continue;
                    }
                    result.put(methodInfo, recorder.denyAll());
                    continue;
                }
                if (alreadyExistingInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                throw new IllegalStateException("Class " + methodInfo.declaringClass() + " should not have been added as an additional secured class");
            }
        }
        if (denyUnannotated) {
            HashSet<ClassInfo> allClassesWithSecurityChecks = new HashSet<ClassInfo>(methodToInstanceCollector.keySet().size());
            for (MethodInfo methodInfo : methodToInstanceCollector.keySet()) {
                allClassesWithSecurityChecks.add(methodInfo.declaringClass());
            }
            for (ClassInfo classWithSecurityCheck : allClassesWithSecurityChecks) {
                for (MethodInfo methodInfo : classWithSecurityCheck.methods()) {
                    if (!this.isPublicNonStaticNonConstructor(methodInfo) || methodToInstanceCollector.containsKey(methodInfo)) continue;
                    result.put(methodInfo, recorder.denyAll());
                }
            }
        }
        return result;
    }

    private boolean isPublicNonStaticNonConstructor(MethodInfo methodInfo) {
        return Modifier.isPublic(methodInfo.flags()) && !Modifier.isStatic(methodInfo.flags()) && !"<init>".equals(methodInfo.name());
    }

    private Map<MethodInfo, SecurityCheck> gatherSecurityAnnotations(IndexView index, DotName dotName, Map<MethodInfo, AnnotationInstance> alreadyCheckedMethods, Map<ClassInfo, AnnotationInstance> classLevelAnnotations, Function<AnnotationInstance, SecurityCheck> securityCheckInstanceCreator) {
        AnnotationTarget target;
        HashMap<MethodInfo, SecurityCheck> result = new HashMap<MethodInfo, SecurityCheck>();
        Collection instances = index.getAnnotations(dotName);
        for (AnnotationInstance instance : instances) {
            target = instance.target();
            if (target.kind() != AnnotationTarget.Kind.METHOD) continue;
            MethodInfo methodInfo = target.asMethod();
            if (alreadyCheckedMethods.containsKey(methodInfo)) {
                throw new IllegalStateException("Method " + methodInfo.name() + " of class " + methodInfo.declaringClass() + " is annotated with multiple security annotations");
            }
            alreadyCheckedMethods.put(methodInfo, instance);
            result.put(methodInfo, securityCheckInstanceCreator.apply(instance));
        }
        for (AnnotationInstance instance : instances) {
            target = instance.target();
            if (target.kind() != AnnotationTarget.Kind.CLASS) continue;
            List methods = target.asClass().methods();
            AnnotationInstance existingClassInstance = classLevelAnnotations.get(target.asClass());
            if (existingClassInstance == null) {
                classLevelAnnotations.put(target.asClass(), instance);
                for (MethodInfo methodInfo : methods) {
                    AnnotationInstance alreadyExistingInstance = alreadyCheckedMethods.get(methodInfo);
                    if (alreadyExistingInstance != null) continue;
                    result.put(methodInfo, securityCheckInstanceCreator.apply(instance));
                }
                continue;
            }
            throw new IllegalStateException("Class " + target.asClass() + " is annotated with multiple security annotations " + instance.name() + " and " + existingClassInstance.name());
        }
        return result;
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SECURITY);
    }

    @BuildStep
    void registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> beans) {
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SecurityIdentityAssociation.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(IdentityProviderManagerCreator.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SecurityIdentityProxy.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(X509IdentityProvider.class));
    }

    @BuildStep
    AdditionalBeanBuildItem authorizationController(LaunchModeBuildItem launchMode) {
        Class<AuthorizationController> controllerClass = AuthorizationController.class;
        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT && !this.security.authorizationEnabledInDevMode) {
            controllerClass = DevModeDisabledAuthorizationController.class;
        }
        return AdditionalBeanBuildItem.builder().addBeanClass(controllerClass).build();
    }

    class SecurityCheckStorageAppPredicate
    implements Predicate<String> {
        SecurityCheckStorageAppPredicate() {
        }

        @Override
        public boolean test(String s) {
            return s.equals(SecurityCheckStorage.class.getName());
        }
    }

    static class AdditionalSecured {
        final ClassInfo classInfo;
        final Optional<List<String>> rolesAllowed;

        AdditionalSecured(ClassInfo classInfo, Optional<List<String>> rolesAllowed) {
            this.classInfo = classInfo;
            this.rolesAllowed = rolesAllowed;
        }
    }
}

