/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.arc.processor.DotNames;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.security.StringPermission;
import io.quarkus.security.deployment.SecurityProcessor;
import io.quarkus.security.runtime.SecurityCheckRecorder;
import io.quarkus.security.runtime.interceptor.PermissionsAllowedInterceptor;
import io.quarkus.security.spi.runtime.SecurityCheck;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

interface PermissionSecurityChecks {
    public Map<MethodInfo, SecurityCheck> get();

    public Set<String> permissionClasses();

    public static final class PermissionSecurityChecksBuilder {
        private static final DotName STRING_PERMISSION = DotName.createSimple(StringPermission.class);
        private static final DotName PERMISSIONS_ALLOWED_INTERCEPTOR = DotName.createSimple(PermissionsAllowedInterceptor.class);
        private final Map<MethodInfo, List<List<PermissionKey>>> methodToPermissionKeys = new HashMap<MethodInfo, List<List<PermissionKey>>>();
        private final Map<MethodInfo, LogicalAndPermissionPredicate> methodToPredicate = new HashMap<MethodInfo, LogicalAndPermissionPredicate>();
        private final Map<String, MethodInfo> classSignatureToConstructor = new HashMap<String, MethodInfo>();
        private final SecurityCheckRecorder recorder;

        public PermissionSecurityChecksBuilder(SecurityCheckRecorder recorder) {
            this.recorder = recorder;
        }

        PermissionSecurityChecks build() {
            return new PermissionSecurityChecks(){

                @Override
                public Map<MethodInfo, SecurityCheck> get() {
                    HashMap<LogicalAndPermissionPredicate, SecurityCheck> cache = new HashMap<LogicalAndPermissionPredicate, SecurityCheck>();
                    HashMap<MethodInfo, SecurityCheck> methodToCheck = new HashMap<MethodInfo, SecurityCheck>();
                    for (Map.Entry<MethodInfo, LogicalAndPermissionPredicate> methodToPredicate : methodToPredicate.entrySet()) {
                        SecurityCheck check = cache.computeIfAbsent(methodToPredicate.getValue(), new Function<LogicalAndPermissionPredicate, SecurityCheck>(){

                            @Override
                            public SecurityCheck apply(LogicalAndPermissionPredicate predicate) {
                                return this.createSecurityCheck(predicate);
                            }
                        });
                        methodToCheck.put(methodToPredicate.getKey(), check);
                    }
                    return methodToCheck;
                }

                @Override
                public Set<String> permissionClasses() {
                    return classSignatureToConstructor.keySet();
                }
            };
        }

        PermissionSecurityChecksBuilder createPermissionPredicates() {
            HashMap<PermissionCacheKey, PermissionWrapper> permissionCache = new HashMap<PermissionCacheKey, PermissionWrapper>();
            for (Map.Entry<MethodInfo, List<List<PermissionKey>>> entry : this.methodToPermissionKeys.entrySet()) {
                MethodInfo securedMethod = entry.getKey();
                LogicalAndPermissionPredicate predicate = new LogicalAndPermissionPredicate();
                for (List<PermissionKey> permissionKeys : entry.getValue()) {
                    boolean inclusive = this.isInclusive(permissionKeys);
                    if (inclusive) {
                        for (PermissionKey permissionKey : permissionKeys) {
                            PermissionWrapper permission = this.createPermission(permissionKey, securedMethod, permissionCache);
                            if (permission.isComputed()) {
                                predicate.markAsComputed();
                            }
                            predicate.and(new LogicalOrPermissionPredicate().or(permission));
                        }
                        continue;
                    }
                    LogicalOrPermissionPredicate orPredicate = new LogicalOrPermissionPredicate();
                    predicate.and(orPredicate);
                    for (PermissionKey permissionKey : permissionKeys) {
                        PermissionWrapper permission = this.createPermission(permissionKey, securedMethod, permissionCache);
                        if (permission.isComputed()) {
                            predicate.markAsComputed();
                        }
                        orPredicate.or(permission);
                    }
                }
                this.methodToPredicate.put(securedMethod, predicate);
            }
            return this;
        }

        private boolean isInclusive(List<PermissionKey> permissionKeys) {
            if (permissionKeys.isEmpty()) {
                return false;
            }
            return permissionKeys.get((int)0).inclusive;
        }

        PermissionSecurityChecksBuilder validatePermissionClasses(IndexView index) {
            for (List<List<PermissionKey>> keyLists : this.methodToPermissionKeys.values()) {
                for (List<PermissionKey> keyList : keyLists) {
                    for (PermissionKey key : keyList) {
                        if (this.classSignatureToConstructor.containsKey(key.classSignature())) continue;
                        ClassInfo clazz = index.getClassByName(key.clazz.name());
                        Objects.requireNonNull(clazz);
                        if (clazz.constructors().size() != 1) {
                            throw new RuntimeException(String.format("Permission class '%s' has %d constructors, exactly one is allowed", key.classSignature(), clazz.constructors().size()));
                        }
                        MethodInfo constructor = (MethodInfo)clazz.constructors().get(0);
                        if (constructor.parametersCount() == 0 || !DotNames.STRING.equals((Object)constructor.parameterType(0).name())) {
                            throw new RuntimeException(String.format("Permission constructor '%s' first argument must be '%s'", clazz.name().toString(), String.class.getName()));
                        }
                        this.classSignatureToConstructor.put(key.classSignature(), constructor);
                    }
                }
            }
            return this;
        }

        PermissionSecurityChecksBuilder gatherPermissionsAllowedAnnotations(List<AnnotationInstance> instances, Map<MethodInfo, AnnotationInstance> alreadyCheckedMethods, Map<ClassInfo, AnnotationInstance> alreadyCheckedClasses) {
            instances.sort(new Comparator<AnnotationInstance>(){

                @Override
                public int compare(AnnotationInstance o1, AnnotationInstance o2) {
                    if (o1.target().kind() != o2.target().kind()) {
                        return o1.target().kind() == AnnotationTarget.Kind.METHOD ? -1 : 1;
                    }
                    return 0;
                }
            });
            ArrayList<PermissionKey> cache = new ArrayList<PermissionKey>();
            HashMap<MethodInfo, List<List<PermissionKey>>> classMethodToPermissionKeys = new HashMap<MethodInfo, List<List<PermissionKey>>>();
            for (AnnotationInstance instance : instances) {
                ClassInfo clazz;
                AnnotationTarget target = instance.target();
                if (target.kind() == AnnotationTarget.Kind.METHOD) {
                    MethodInfo methodInfo = target.asMethod();
                    if (alreadyCheckedMethods.containsKey(methodInfo)) {
                        throw new IllegalStateException(String.format("Method %s of class %s is annotated with multiple security annotations", methodInfo.name(), methodInfo.declaringClass()));
                    }
                    PermissionSecurityChecksBuilder.gatherPermissionKeys(instance, methodInfo, cache, this.methodToPermissionKeys);
                    continue;
                }
                if (target.kind() != AnnotationTarget.Kind.CLASS || PERMISSIONS_ALLOWED_INTERCEPTOR.equals((Object)(clazz = target.asClass()).name()) || clazz.name().toString().endsWith("PermissionsAllowedInterceptor")) continue;
                AnnotationInstance existingClassInstance = alreadyCheckedClasses.get(clazz);
                if (existingClassInstance == null) {
                    for (MethodInfo methodInfo : clazz.methods()) {
                        boolean noMethodLevelPermissionsAllowed;
                        if (!SecurityProcessor.isPublicNonStaticNonConstructor(methodInfo)) continue;
                        boolean noMethodLevelSecurityAnnotation = !alreadyCheckedMethods.containsKey(methodInfo);
                        boolean bl = noMethodLevelPermissionsAllowed = !this.methodToPermissionKeys.containsKey(methodInfo);
                        if (!noMethodLevelSecurityAnnotation || !noMethodLevelPermissionsAllowed) continue;
                        PermissionSecurityChecksBuilder.gatherPermissionKeys(instance, methodInfo, cache, classMethodToPermissionKeys);
                    }
                    continue;
                }
                throw new IllegalStateException(String.format("Class %s is annotated with multiple security annotations %s and %s", clazz, instance.name(), existingClassInstance.name()));
            }
            this.methodToPermissionKeys.putAll(classMethodToPermissionKeys);
            return this;
        }

        private static void gatherPermissionKeys(AnnotationInstance instance, MethodInfo methodInfo, List<PermissionKey> cache, Map<MethodInfo, List<List<PermissionKey>>> methodToPermissionKeys) {
            String[] stringArray;
            HashMap permissionToActions = new HashMap();
            for (String permissionToAction : instance.value().asStringArray()) {
                if (permissionToAction.contains(":")) {
                    String[] permissionToActionArr = permissionToAction.split(":");
                    if (permissionToActionArr.length != 2) {
                        throw new RuntimeException(String.format("PermissionsAllowed value '%s' contains more than one separator '%2$s', expected format is 'permissionName%2$saction'", permissionToAction, ":"));
                    }
                    String permissionName = permissionToActionArr[0];
                    String action = permissionToActionArr[1];
                    if (permissionToActions.containsKey(permissionName)) {
                        ((Set)permissionToActions.get(permissionName)).add(action);
                        continue;
                    }
                    HashSet<String> actions = new HashSet<String>();
                    actions.add(action);
                    permissionToActions.put(permissionName, actions);
                    continue;
                }
                if (permissionToActions.containsKey(permissionToAction)) continue;
                permissionToActions.put(permissionToAction, new HashSet());
            }
            if (permissionToActions.isEmpty()) {
                throw new RuntimeException(String.format("Method '%s' was annotated with '@PermissionsAllowed', but no valid permission was provided", methodInfo.name()));
            }
            ArrayList<PermissionKey> orPermissions = new ArrayList<PermissionKey>();
            if (instance.value("params") == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "<<autodetected>>";
            } else {
                stringArray = instance.value("params").asStringArray();
            }
            String[] params = stringArray;
            Type classType = instance.value("permission") == null ? Type.create((DotName)STRING_PERMISSION, (Type.Kind)Type.Kind.CLASS) : instance.value("permission").asClass();
            boolean inclusive = instance.value("inclusive") != null && instance.value("inclusive").asBoolean();
            for (Map.Entry permissionToAction : permissionToActions.entrySet()) {
                PermissionKey key = new PermissionKey((String)permissionToAction.getKey(), (Set)permissionToAction.getValue(), params, classType, inclusive);
                int i = cache.indexOf(key);
                if (i == -1) {
                    orPermissions.add(key);
                    cache.add(key);
                    continue;
                }
                orPermissions.add(cache.get(i));
            }
            methodToPermissionKeys.computeIfAbsent(methodInfo, new Function<MethodInfo, List<List<PermissionKey>>>(){

                @Override
                public List<List<PermissionKey>> apply(MethodInfo methodInfo) {
                    return new ArrayList<List<PermissionKey>>();
                }
            }).add(List.copyOf(orPermissions));
        }

        private SecurityCheck createSecurityCheck(LogicalAndPermissionPredicate andPredicate) {
            SecurityCheck securityCheck;
            boolean isSinglePermissionGroup;
            boolean bl = isSinglePermissionGroup = andPredicate.operands.size() == 1;
            if (isSinglePermissionGroup) {
                boolean isSinglePermission;
                LogicalOrPermissionPredicate orPredicate = andPredicate.operands.iterator().next();
                boolean bl2 = isSinglePermission = orPredicate.operands.size() == 1;
                if (isSinglePermission) {
                    PermissionWrapper permissionWrapper = orPredicate.operands.iterator().next();
                    securityCheck = this.recorder.permissionsAllowed(permissionWrapper.computedPermission, permissionWrapper.permission);
                } else {
                    securityCheck = andPredicate.atLeastOnePermissionIsComputed ? this.recorder.permissionsAllowed(orPredicate.asComputedPermissions(this.recorder), null) : this.recorder.permissionsAllowed(null, orPredicate.asPermissions());
                }
            } else if (andPredicate.atLeastOnePermissionIsComputed) {
                ArrayList<List<Function<Object[], Permission>>> computedPermissionGroups = new ArrayList<List<Function<Object[], Permission>>>();
                for (LogicalOrPermissionPredicate permissionGroup : andPredicate.operands) {
                    computedPermissionGroups.add(permissionGroup.asComputedPermissions(this.recorder));
                }
                securityCheck = this.recorder.permissionsAllowedGroups(computedPermissionGroups, null);
            } else {
                ArrayList<List<RuntimeValue<Permission>>> permissionGroups = new ArrayList<List<RuntimeValue<Permission>>>();
                for (LogicalOrPermissionPredicate permissionGroup : andPredicate.operands) {
                    permissionGroups.add(permissionGroup.asPermissions());
                }
                securityCheck = this.recorder.permissionsAllowedGroups(null, permissionGroups);
            }
            return securityCheck;
        }

        private PermissionWrapper createPermission(PermissionKey permissionKey, MethodInfo securedMethod, Map<PermissionCacheKey, PermissionWrapper> cache) {
            MethodInfo constructor = this.classSignatureToConstructor.get(permissionKey.classSignature());
            return cache.computeIfAbsent(new PermissionCacheKey(permissionKey, securedMethod, constructor), new Function<PermissionCacheKey, PermissionWrapper>(){

                @Override
                public PermissionWrapper apply(PermissionCacheKey permissionCacheKey) {
                    if (permissionCacheKey.computed) {
                        return new PermissionWrapper(this.createComputedPermission(permissionCacheKey), null);
                    }
                    RuntimeValue<Permission> permission = permissionCacheKey.isStringPermission() ? this.createStringPermission(permissionCacheKey.permissionKey) : this.createCustomPermission(permissionCacheKey);
                    return new PermissionWrapper(null, permission);
                }
            });
        }

        private Function<Object[], Permission> createComputedPermission(PermissionCacheKey permissionCacheKey) {
            return this.recorder.createComputedPermission(permissionCacheKey.permissionKey.name, permissionCacheKey.permissionKey.classSignature(), permissionCacheKey.permissionKey.actions(), permissionCacheKey.passActionsToConstructor, permissionCacheKey.methodParamIndexes());
        }

        private RuntimeValue<Permission> createCustomPermission(PermissionCacheKey permissionCacheKey) {
            return this.recorder.createPermission(permissionCacheKey.permissionKey.name, permissionCacheKey.permissionKey.classSignature(), permissionCacheKey.permissionKey.actions(), permissionCacheKey.passActionsToConstructor);
        }

        private RuntimeValue<Permission> createStringPermission(PermissionKey permissionKey) {
            if (permissionKey.notAutodetectParams()) {
                throw new IllegalArgumentException(String.format("'%s' must have autodetected params", STRING_PERMISSION));
            }
            return this.recorder.createStringPermission(permissionKey.name, permissionKey.actions());
        }

        private static final class PermissionCacheKey {
            private final int[] methodParamIndexes;
            private final PermissionKey permissionKey;
            private final boolean computed;
            private final boolean passActionsToConstructor;

            private PermissionCacheKey(PermissionKey permissionKey, MethodInfo securedMethod, MethodInfo constructor) {
                if (PermissionCacheKey.isComputed(permissionKey, constructor)) {
                    boolean isSecondParamStringArr;
                    this.permissionKey = permissionKey;
                    this.computed = true;
                    boolean bl = isSecondParamStringArr = !PermissionCacheKey.secondParamIsNotStringArr(constructor);
                    if (permissionKey.notAutodetectParams()) {
                        int foundIx;
                        this.passActionsToConstructor = isSecondParamStringArr ? (foundIx = PermissionCacheKey.findSecuredMethodParamIndex(securedMethod, constructor, 1)) == -1 : false;
                        this.methodParamIndexes = PermissionCacheKey.userDefinedConstructorParamIndexes(securedMethod, constructor, this.passActionsToConstructor);
                    } else {
                        this.passActionsToConstructor = isSecondParamStringArr;
                        this.methodParamIndexes = PermissionCacheKey.autodetectConstructorParamIndexes(permissionKey, securedMethod, constructor, isSecondParamStringArr);
                    }
                } else {
                    this.methodParamIndexes = null;
                    this.permissionKey = permissionKey;
                    this.computed = false;
                    this.passActionsToConstructor = constructor.parametersCount() == 2;
                }
            }

            private static int[] userDefinedConstructorParamIndexes(MethodInfo securedMethod, MethodInfo constructor, boolean passActionsToConstructor) {
                int nonMethodParams = passActionsToConstructor ? 2 : 1;
                int[] methodParamIndexes = new int[constructor.parametersCount() - nonMethodParams];
                for (int i = nonMethodParams; i < constructor.parametersCount(); ++i) {
                    int foundIx = PermissionCacheKey.findSecuredMethodParamIndex(securedMethod, constructor, i);
                    if (foundIx == -1) {
                        String constructorParamName = constructor.parameterName(i);
                        throw new RuntimeException(String.format("No '%s' formal parameter name matches '%s' constructor parameter name '%s' specified via '@PermissionsAllowed#params'", securedMethod.name(), constructor.declaringClass().name().toString(), constructorParamName));
                    }
                    methodParamIndexes[i - nonMethodParams] = foundIx;
                }
                return methodParamIndexes;
            }

            private static int[] autodetectConstructorParamIndexes(PermissionKey permissionKey, MethodInfo securedMethod, MethodInfo constructor, boolean isSecondParamStringArr) {
                int nonMethodParams = isSecondParamStringArr ? 2 : 1;
                int[] methodParamIndexes = new int[constructor.parametersCount() - nonMethodParams];
                for (int i = 0; i < methodParamIndexes.length; ++i) {
                    Type seekedParamType = constructor.parameterType(i + nonMethodParams);
                    int foundIndex = -1;
                    block1: for (int j = 0; j < securedMethod.parameterTypes().size(); ++j) {
                        if (!seekedParamType.equals((Object)securedMethod.parameterType(j))) continue;
                        for (int k = 0; k < i; ++k) {
                            if (methodParamIndexes[k] == j) continue block1;
                        }
                        foundIndex = j;
                        break;
                    }
                    if (foundIndex == -1) {
                        throw new RuntimeException(String.format("Failed to identify matching data type for '%s' param of '%s' constructor for method '%s' annotated with @PermissionsAllowed", constructor.parameterName(i), permissionKey.classSignature(), securedMethod.name()));
                    }
                    methodParamIndexes[i] = foundIndex;
                }
                return methodParamIndexes;
            }

            private static int findSecuredMethodParamIndex(MethodInfo securedMethod, MethodInfo constructor, int constructorIx) {
                String constructorParamName = constructor.parameterName(constructorIx);
                int foundIx = -1;
                for (int i = 0; i < securedMethod.parametersCount(); ++i) {
                    boolean paramNamesMatch = constructorParamName.equals(securedMethod.parameterName(i));
                    if (!paramNamesMatch) continue;
                    foundIx = i;
                    break;
                }
                return foundIx;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PermissionCacheKey that = (PermissionCacheKey)o;
                return this.computed == that.computed && this.passActionsToConstructor == that.passActionsToConstructor && Arrays.equals(this.methodParamIndexes, that.methodParamIndexes) && this.permissionKey.equals(that.permissionKey);
            }

            public int hashCode() {
                int result = Objects.hash(this.permissionKey, this.computed, this.passActionsToConstructor);
                result = 31 * result + Arrays.hashCode(this.methodParamIndexes);
                return result;
            }

            private int[] methodParamIndexes() {
                return Objects.requireNonNull(this.methodParamIndexes);
            }

            private boolean isStringPermission() {
                return PermissionCacheKey.isStringPermission(this.permissionKey);
            }

            private static boolean isComputed(PermissionKey permissionKey, MethodInfo constructor) {
                return permissionKey.notAutodetectParams() || constructor.parametersCount() > 2 || constructor.parametersCount() == 2 && PermissionCacheKey.secondParamIsNotStringArr(constructor);
            }

            private static boolean secondParamIsNotStringArr(MethodInfo constructor) {
                return constructor.parametersCount() < 2 || constructor.parameterType(1).kind() != Type.Kind.ARRAY || !constructor.parameterType(1).asArrayType().component().name().equals((Object)DotNames.STRING);
            }

            private static boolean isStringPermission(PermissionKey permissionKey) {
                return STRING_PERMISSION.equals((Object)permissionKey.clazz.name());
            }
        }

        private static final class PermissionKey {
            private final String name;
            private final Set<String> actions;
            private final String[] params;
            private final Type clazz;
            private final boolean inclusive;

            private PermissionKey(String name, Set<String> actions, String[] params, Type clazz, boolean inclusive) {
                this.name = name;
                this.clazz = clazz;
                this.inclusive = inclusive;
                this.actions = !actions.isEmpty() ? actions : null;
                this.params = params;
            }

            private String classSignature() {
                return this.clazz.name().toString();
            }

            private boolean notAutodetectParams() {
                return this.params.length != 1 || !"<<autodetected>>".equals(this.params[0]);
            }

            private String[] actions() {
                return this.actions == null ? null : this.actions.toArray(new String[0]);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PermissionKey that = (PermissionKey)o;
                return this.name.equals(that.name) && Objects.equals(this.actions, that.actions) && Arrays.equals(this.params, that.params) && this.clazz.equals((Object)that.clazz) && this.inclusive == that.inclusive;
            }

            public int hashCode() {
                int result = Objects.hash(this.name, this.actions, this.clazz, this.inclusive);
                result = 31 * result + Arrays.hashCode(this.params);
                return result;
            }
        }

        private static final class PermissionWrapper {
            private final Function<Object[], Permission> computedPermission;
            private final RuntimeValue<Permission> permission;

            private PermissionWrapper(Function<Object[], Permission> computedPermission, RuntimeValue<Permission> permission) {
                this.computedPermission = computedPermission;
                this.permission = permission;
            }

            private boolean isComputed() {
                return this.permission == null;
            }
        }

        private static final class LogicalAndPermissionPredicate {
            private final Set<LogicalOrPermissionPredicate> operands = new HashSet<LogicalOrPermissionPredicate>();
            private boolean atLeastOnePermissionIsComputed = false;

            private LogicalAndPermissionPredicate() {
            }

            private void and(LogicalOrPermissionPredicate orPermissionPredicate) {
                this.operands.add(orPermissionPredicate);
            }

            private void markAsComputed() {
                if (!this.atLeastOnePermissionIsComputed) {
                    this.atLeastOnePermissionIsComputed = true;
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogicalAndPermissionPredicate that = (LogicalAndPermissionPredicate)o;
                return this.operands.equals(that.operands);
            }

            public int hashCode() {
                return Objects.hash(this.operands);
            }
        }

        private static final class LogicalOrPermissionPredicate {
            private final Set<PermissionWrapper> operands = new HashSet<PermissionWrapper>();

            private LogicalOrPermissionPredicate() {
            }

            private LogicalOrPermissionPredicate or(PermissionWrapper permission) {
                this.operands.add(permission);
                return this;
            }

            private List<Function<Object[], Permission>> asComputedPermissions(SecurityCheckRecorder recorder) {
                ArrayList<Function> computedPermissions = new ArrayList<Function>();
                for (PermissionWrapper wrapper : this.operands) {
                    if (wrapper.isComputed()) {
                        computedPermissions.add(wrapper.computedPermission);
                        continue;
                    }
                    computedPermissions.add(recorder.toComputedPermission(wrapper.permission));
                }
                return List.copyOf(computedPermissions);
            }

            private List<RuntimeValue<Permission>> asPermissions() {
                ArrayList<RuntimeValue<Permission>> permissions = new ArrayList<RuntimeValue<Permission>>();
                for (PermissionWrapper wrapper : this.operands) {
                    Objects.requireNonNull(wrapper.permission);
                    permissions.add(wrapper.permission);
                }
                return List.copyOf(permissions);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogicalOrPermissionPredicate that = (LogicalOrPermissionPredicate)o;
                return this.operands.equals(that.operands);
            }

            public int hashCode() {
                return Objects.hash(this.operands);
            }
        }
    }
}

