/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.InterceptorBindingRegistrarBuildItem;
import io.quarkus.arc.deployment.SynthesisFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JPMSExportBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSecurityProviderBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.StartupEvent;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.security.deployment.AdditionalDenyingUnannotatedTransformer;
import io.quarkus.security.deployment.AdditionalRolesAllowedTransformer;
import io.quarkus.security.deployment.AdditionalSecurityCheckBuildItem;
import io.quarkus.security.deployment.BouncyCastleJsseProviderBuildItem;
import io.quarkus.security.deployment.BouncyCastleProviderBuildItem;
import io.quarkus.security.deployment.ConfigExpRolesAllowedSecurityCheckBuildItem;
import io.quarkus.security.deployment.DenyingUnannotatedTransformer;
import io.quarkus.security.deployment.DotNames;
import io.quarkus.security.deployment.JCAProviderBuildItem;
import io.quarkus.security.deployment.PermissionSecurityChecks;
import io.quarkus.security.deployment.RegisterClassSecurityCheckBuildItem;
import io.quarkus.security.deployment.SecurityAnnotationsRegistrar;
import io.quarkus.security.deployment.SecurityConfig;
import io.quarkus.security.deployment.SecurityTransformerUtils;
import io.quarkus.security.runtime.IdentityProviderManagerCreator;
import io.quarkus.security.runtime.QuarkusSecurityRolesAllowedConfigBuilder;
import io.quarkus.security.runtime.SecurityBuildTimeConfig;
import io.quarkus.security.runtime.SecurityCheckRecorder;
import io.quarkus.security.runtime.SecurityIdentityAssociation;
import io.quarkus.security.runtime.SecurityIdentityProxy;
import io.quarkus.security.runtime.SecurityProviderRecorder;
import io.quarkus.security.runtime.SecurityProviderUtils;
import io.quarkus.security.runtime.X509IdentityProvider;
import io.quarkus.security.runtime.interceptor.AuthenticatedInterceptor;
import io.quarkus.security.runtime.interceptor.DenyAllInterceptor;
import io.quarkus.security.runtime.interceptor.PermissionsAllowedInterceptor;
import io.quarkus.security.runtime.interceptor.PermitAllInterceptor;
import io.quarkus.security.runtime.interceptor.RolesAllowedInterceptor;
import io.quarkus.security.runtime.interceptor.SecurityConstrainer;
import io.quarkus.security.runtime.interceptor.SecurityHandler;
import io.quarkus.security.spi.AdditionalSecuredClassesBuildItem;
import io.quarkus.security.spi.AdditionalSecuredMethodsBuildItem;
import io.quarkus.security.spi.AdditionalSecurityConstrainerEventPropsBuildItem;
import io.quarkus.security.spi.ClassSecurityCheckAnnotationBuildItem;
import io.quarkus.security.spi.ClassSecurityCheckStorageBuildItem;
import io.quarkus.security.spi.DefaultSecurityCheckBuildItem;
import io.quarkus.security.spi.RolesAllowedConfigExpResolverBuildItem;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.DevModeDisabledAuthorizationController;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.graalvm.nativeimage.hosted.Feature;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SecurityProcessor {
    private static final Logger log = Logger.getLogger(SecurityProcessor.class);
    private static final DotName STARTUP_EVENT_NAME = DotName.createSimple((String)StartupEvent.class.getName());
    SecurityConfig security;

    @BuildStep
    void produceJcaSecurityProviders(BuildProducer<JCAProviderBuildItem> jcaProviders, BuildProducer<BouncyCastleProviderBuildItem> bouncyCastleProvider, BuildProducer<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProvider) {
        Set providers = this.security.securityProviders().orElse(Set.of());
        for (String providerName : providers) {
            if ("BC".equals(providerName)) {
                bouncyCastleProvider.produce((BuildItem)new BouncyCastleProviderBuildItem());
            } else if ("BCJSSE".equals(providerName)) {
                bouncyCastleJsseProvider.produce((BuildItem)new BouncyCastleJsseProviderBuildItem());
            } else if ("BCFIPS".equals(providerName)) {
                bouncyCastleProvider.produce((BuildItem)new BouncyCastleProviderBuildItem(true));
            } else if ("BCFIPSJSSE".equals(providerName)) {
                bouncyCastleJsseProvider.produce((BuildItem)new BouncyCastleJsseProviderBuildItem(true));
            } else {
                jcaProviders.produce((BuildItem)new JCAProviderBuildItem(providerName, this.security.securityProviderConfig().get(providerName)));
            }
            log.debugf("Added providerName: %s", (Object)providerName);
        }
    }

    @BuildStep
    void registerJCAProvidersForReflection(BuildProducer<ReflectiveClassBuildItem> classes, List<JCAProviderBuildItem> jcaProviders, BuildProducer<NativeImageSecurityProviderBuildItem> additionalProviders) throws IOException, URISyntaxException {
        for (JCAProviderBuildItem provider : jcaProviders) {
            List<String> providerClasses = SecurityProcessor.registerProvider(provider.getProviderName(), provider.getProviderConfig(), additionalProviders);
            for (String className : providerClasses) {
                classes.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className}).methods().fields().build());
                log.debugf("Register JCA class: %s", (Object)className);
            }
        }
    }

    @BuildStep
    void prepareBouncyCastleProviders(CurateOutcomeBuildItem curateOutcomeBuildItem, BuildProducer<ReflectiveClassBuildItem> reflection, BuildProducer<RuntimeReinitializedClassBuildItem> runtimeReInitialized, List<BouncyCastleProviderBuildItem> bouncyCastleProviders, List<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProviders) throws Exception {
        Optional<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProvider = SecurityProcessor.getOne(bouncyCastleJsseProviders);
        if (bouncyCastleJsseProvider.isPresent()) {
            reflection.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.bouncycastle.jsse.provider.BouncyCastleJsseProvider"}).methods().fields().build());
            reflection.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.bouncycastle.jsse.provider.DefaultSSLContextSpi$LazyManagers"}).methods().fields().build());
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.jsse.provider.DefaultSSLContextSpi$LazyManagers"));
            SecurityProcessor.prepareBouncyCastleProvider(curateOutcomeBuildItem, reflection, runtimeReInitialized, bouncyCastleJsseProvider.get().isInFipsMode());
        } else {
            Optional<BouncyCastleProviderBuildItem> bouncyCastleProvider = SecurityProcessor.getOne(bouncyCastleProviders);
            if (bouncyCastleProvider.isPresent()) {
                SecurityProcessor.prepareBouncyCastleProvider(curateOutcomeBuildItem, reflection, runtimeReInitialized, bouncyCastleProvider.get().isInFipsMode());
            }
        }
    }

    private static void prepareBouncyCastleProvider(CurateOutcomeBuildItem curateOutcomeBuildItem, BuildProducer<ReflectiveClassBuildItem> reflection, BuildProducer<RuntimeReinitializedClassBuildItem> runtimeReInitialized, boolean isFipsMode) {
        reflection.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{isFipsMode ? "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider" : "org.bouncycastle.jce.provider.BouncyCastleProvider"}).methods().fields().build());
        if (curateOutcomeBuildItem.getApplicationModel().getDependencies().stream().anyMatch(x -> x.getGroupId().equals("org.bouncycastle") && x.getArtifactId().startsWith("bcprov-"))) {
            reflection.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.bouncycastle.jcajce.provider.symmetric.AES", "org.bouncycastle.jcajce.provider.symmetric.AES$CBC", "org.bouncycastle.crypto.paddings.PKCS7Padding", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi$EC", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi$ECDSA", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$EC", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$ECDSA", "org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyFactorySpi", "org.bouncycastle.jcajce.provider.asymmetric.rsa.KeyPairGeneratorSpi", "org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi", "org.bouncycastle.jcajce.provider.asymmetric.rsa.PSSSignatureSpi$SHA256withRSA"}).methods().fields().build());
        }
        runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.crypto.CryptoServicesRegistrar"));
        if (!isFipsMode) {
            reflection.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.bouncycastle.jcajce.provider.drbg.DRBG$Default"}).methods().fields().build());
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.jcajce.provider.drbg.DRBG$Default"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.jcajce.provider.drbg.DRBG$NonceAndIV"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.jcajce.provider.drbg.DRBG$URLSeededEntropySourceProvider"));
        } else {
            reflection.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.bouncycastle.crypto.general.AES"}).methods().fields().build());
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.crypto.general.AES"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.crypto.asymmetric.NamedECDomainParameters"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.crypto.asymmetric.CustomNamedCurves"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.asn1.ua.DSTU4145NamedCurves"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.asn1.sec.SECNamedCurves"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.asn1.x9.X962NamedCurves"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.asn1.x9.ECNamedCurveTable"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.asn1.anssi.ANSSINamedCurves"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves"));
            runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("org.bouncycastle.jcajce.spec.ECUtil"));
        }
        runtimeReInitialized.produce((BuildItem)new RuntimeReinitializedClassBuildItem("sun.security.pkcs11.P11Util"));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void recordBouncyCastleProviders(SecurityProviderRecorder recorder, List<BouncyCastleProviderBuildItem> bouncyCastleProviders, List<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProviders) {
        Optional<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProvider = SecurityProcessor.getOne(bouncyCastleJsseProviders);
        if (bouncyCastleJsseProvider.isPresent()) {
            if (bouncyCastleJsseProvider.get().isInFipsMode()) {
                recorder.addBouncyCastleFipsJsseProvider();
            } else {
                recorder.addBouncyCastleJsseProvider();
            }
        } else {
            Optional<BouncyCastleProviderBuildItem> bouncyCastleProvider = SecurityProcessor.getOne(bouncyCastleProviders);
            if (bouncyCastleProvider.isPresent()) {
                recorder.addBouncyCastleProvider(bouncyCastleProvider.get().isInFipsMode());
            }
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    NativeImageFeatureBuildItem bouncyCastleFeature(List<BouncyCastleProviderBuildItem> bouncyCastleProviders, List<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProviders) {
        Optional<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProvider = SecurityProcessor.getOne(bouncyCastleJsseProviders);
        Optional<BouncyCastleProviderBuildItem> bouncyCastleProvider = SecurityProcessor.getOne(bouncyCastleProviders);
        if (bouncyCastleJsseProvider.isPresent() || bouncyCastleProvider.isPresent()) {
            return new NativeImageFeatureBuildItem("io.quarkus.security.BouncyCastleFeature");
        }
        return null;
    }

    @BuildStep
    void addBouncyCastleProvidersToNativeImage(final BuildProducer<GeneratedNativeImageClassBuildItem> nativeImageClass, BuildProducer<NativeImageSecurityProviderBuildItem> additionalProviders, List<BouncyCastleProviderBuildItem> bouncyCastleProviders, List<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProviders) {
        Optional<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProvider = SecurityProcessor.getOne(bouncyCastleJsseProviders);
        Optional<BouncyCastleProviderBuildItem> bouncyCastleProvider = SecurityProcessor.getOne(bouncyCastleProviders);
        if (bouncyCastleJsseProvider.isPresent() || bouncyCastleProvider.isPresent()) {
            ClassCreator file = new ClassCreator(new ClassOutput(){

                public void write(String s, byte[] bytes) {
                    nativeImageClass.produce((BuildItem)new GeneratedNativeImageClassBuildItem(s, bytes));
                }
            }, "io.quarkus.security.BouncyCastleFeature", null, Object.class.getName(), new String[]{org.graalvm.nativeimage.hosted.Feature.class.getName()});
            MethodCreator afterRegistration = file.getMethodCreator("afterRegistration", "V", new String[]{Feature.AfterRegistrationAccess.class.getName()});
            TryBlock overallCatch = afterRegistration.tryBlock();
            if (bouncyCastleJsseProvider.isPresent()) {
                additionalProviders.produce((BuildItem)new NativeImageSecurityProviderBuildItem("org.bouncycastle.jsse.provider.BouncyCastleJsseProvider"));
                if (!bouncyCastleJsseProvider.get().isInFipsMode()) {
                    int sunJsseIndex = SecurityProviderUtils.findProviderIndex((String)"SunJSSE");
                    ResultHandle bcProvider = overallCatch.newInstance(MethodDescriptor.ofConstructor((String)"org.bouncycastle.jce.provider.BouncyCastleProvider", (String[])new String[0]), new ResultHandle[0]);
                    ResultHandle bcJsseProvider = overallCatch.newInstance(MethodDescriptor.ofConstructor((String)"org.bouncycastle.jsse.provider.BouncyCastleJsseProvider", (String[])new String[0]), new ResultHandle[0]);
                    overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Security.class, (String)"insertProviderAt", Integer.TYPE, (Class[])new Class[]{Provider.class, Integer.TYPE}), new ResultHandle[]{bcProvider, overallCatch.load(sunJsseIndex)});
                    overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Security.class, (String)"insertProviderAt", Integer.TYPE, (Class[])new Class[]{Provider.class, Integer.TYPE}), new ResultHandle[]{bcJsseProvider, overallCatch.load(sunJsseIndex + 1)});
                } else {
                    int sunIndex = SecurityProviderUtils.findProviderIndex((String)"SUN");
                    ResultHandle bcFipsProvider = overallCatch.newInstance(MethodDescriptor.ofConstructor((String)"org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider", (String[])new String[0]), new ResultHandle[0]);
                    MethodDescriptor bcJsseProviderConstructor = MethodDescriptor.ofConstructor((String)"org.bouncycastle.jsse.provider.BouncyCastleJsseProvider", (String[])new String[]{"boolean", Provider.class.getName()});
                    ResultHandle bcJsseProvider = overallCatch.newInstance(bcJsseProviderConstructor, new ResultHandle[]{overallCatch.load(true), bcFipsProvider});
                    overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Security.class, (String)"insertProviderAt", Integer.TYPE, (Class[])new Class[]{Provider.class, Integer.TYPE}), new ResultHandle[]{bcFipsProvider, overallCatch.load(sunIndex)});
                    overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Security.class, (String)"insertProviderAt", Integer.TYPE, (Class[])new Class[]{Provider.class, Integer.TYPE}), new ResultHandle[]{bcJsseProvider, overallCatch.load(sunIndex + 1)});
                }
            } else {
                String providerName = bouncyCastleProvider.get().isInFipsMode() ? "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider" : "org.bouncycastle.jce.provider.BouncyCastleProvider";
                ResultHandle bcProvider = overallCatch.newInstance(MethodDescriptor.ofConstructor((String)providerName, (String[])new String[0]), new ResultHandle[0]);
                overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Security.class, (String)"addProvider", Integer.TYPE, (Class[])new Class[]{Provider.class}), new ResultHandle[]{bcProvider});
            }
            CatchBlockCreator print = overallCatch.addCatch(Throwable.class);
            print.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), print.getCaughtException(), new ResultHandle[0]);
            afterRegistration.returnValue(null);
            file.close();
        }
    }

    @BuildStep
    void addBouncyCastleExportsToNativeImage(BuildProducer<JPMSExportBuildItem> jpmsExports, List<BouncyCastleProviderBuildItem> bouncyCastleProviders, List<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProviders) {
        boolean isInFipsMode;
        Optional<BouncyCastleJsseProviderBuildItem> bouncyCastleJsseProvider = SecurityProcessor.getOne(bouncyCastleJsseProviders);
        if (bouncyCastleJsseProvider.isPresent()) {
            isInFipsMode = bouncyCastleJsseProvider.get().isInFipsMode();
        } else {
            Optional<BouncyCastleProviderBuildItem> bouncyCastleProvider = SecurityProcessor.getOne(bouncyCastleProviders);
            boolean bl = isInFipsMode = bouncyCastleProvider.isPresent() && bouncyCastleProvider.get().isInFipsMode();
        }
        if (isInFipsMode) {
            jpmsExports.produce((BuildItem)new JPMSExportBuildItem("java.base", "sun.security.internal.spec"));
            jpmsExports.produce((BuildItem)new JPMSExportBuildItem("java.base", "sun.security.provider"));
        }
    }

    private static <BI extends MultiBuildItem> Optional<BI> getOne(List<BI> items) {
        if (items.size() > 1) {
            throw new IllegalStateException("Only a single Bouncy Castle registration can be provided.");
        }
        return items.stream().findFirst();
    }

    private static List<String> registerProvider(String providerName, String providerConfig, BuildProducer<NativeImageSecurityProviderBuildItem> additionalProviders) {
        ArrayList<String> providerClasses = new ArrayList<String>();
        Provider provider = Security.getProvider(providerName);
        if (provider != null) {
            Provider configuredProvider;
            providerClasses.add(provider.getClass().getName());
            for (Provider.Service service : provider.getServices()) {
                providerClasses.add(service.getClassName());
                String supportedKeyClasses = service.getAttribute("SupportedKeyClasses");
                if (supportedKeyClasses == null) continue;
                providerClasses.addAll(Arrays.asList(supportedKeyClasses.split("\\|")));
            }
            if (providerConfig != null && (configuredProvider = provider.configure(providerConfig)) != null) {
                Security.addProvider(configuredProvider);
                providerClasses.add(configuredProvider.getClass().getName());
            }
        }
        if (SecurityProviderUtils.SUN_PROVIDERS.containsKey(providerName)) {
            additionalProviders.produce((BuildItem)new NativeImageSecurityProviderBuildItem((String)SecurityProviderUtils.SUN_PROVIDERS.get(providerName)));
        }
        return providerClasses;
    }

    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void recordRuntimeConfigReady(SecurityCheckRecorder recorder, ShutdownContextBuildItem shutdownContextBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        recorder.setRuntimeConfigReady();
        if (launchModeBuildItem.getLaunchMode() == LaunchMode.DEVELOPMENT) {
            recorder.unsetRuntimeConfigReady((ShutdownContext)shutdownContextBuildItem);
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void registerSecurityInterceptors(BuildProducer<InterceptorBindingRegistrarBuildItem> registrars, BuildProducer<AdditionalBeanBuildItem> beans, BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer, SecurityCheckRecorder recorder, Optional<AdditionalSecurityConstrainerEventPropsBuildItem> additionalSecurityConstrainerEventsItem) {
        registrars.produce((BuildItem)new InterceptorBindingRegistrarBuildItem((InterceptorBindingRegistrar)new SecurityAnnotationsRegistrar()));
        Class[] interceptors = new Class[]{AuthenticatedInterceptor.class, DenyAllInterceptor.class, PermitAllInterceptor.class, RolesAllowedInterceptor.class, PermissionsAllowedInterceptor.class};
        beans.produce((BuildItem)new AdditionalBeanBuildItem(interceptors));
        beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SecurityHandler.class}));
        Supplier additionalEventsSupplier = additionalSecurityConstrainerEventsItem.map(AdditionalSecurityConstrainerEventPropsBuildItem::getAdditionalEventPropsSupplier).orElse(null);
        syntheticBeanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SecurityConstrainer.class).unremovable()).scope(Singleton.class)).supplier(recorder.createSecurityConstrainer(additionalEventsSupplier)).done());
    }

    @BuildStep
    void transformAdditionalSecuredClassesToMethods(List<AdditionalSecuredClassesBuildItem> additionalSecuredClassesBuildItems, BuildProducer<AdditionalSecuredMethodsBuildItem> additionalSecuredMethodsBuildItemBuildProducer) {
        for (AdditionalSecuredClassesBuildItem additionalSecuredClassesBuildItem : additionalSecuredClassesBuildItems) {
            ArrayList<MethodInfo> securedMethods = new ArrayList<MethodInfo>();
            for (ClassInfo additionalSecuredClass : additionalSecuredClassesBuildItem.additionalSecuredClasses) {
                for (MethodInfo method : additionalSecuredClass.methods()) {
                    if (!SecurityProcessor.isPublicNonStaticNonConstructor(method)) continue;
                    securedMethods.add(method);
                }
            }
            additionalSecuredMethodsBuildItemBuildProducer.produce((BuildItem)new AdditionalSecuredMethodsBuildItem(securedMethods, additionalSecuredClassesBuildItem.rolesAllowed));
        }
    }

    @BuildStep
    void transformSecurityAnnotations(BuildProducer<AnnotationsTransformerBuildItem> transformers, List<AdditionalSecuredMethodsBuildItem> additionalSecuredMethods, SecurityBuildTimeConfig config) {
        if (config.denyUnannotated()) {
            transformers.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new DenyingUnannotatedTransformer()));
        }
        if (!additionalSecuredMethods.isEmpty()) {
            for (AdditionalSecuredMethodsBuildItem securedMethods : additionalSecuredMethods) {
                HashSet<MethodDescription> additionalSecured = new HashSet<MethodDescription>();
                for (MethodInfo additionalSecuredMethod : securedMethods.additionalSecuredMethods) {
                    additionalSecured.add(SecurityProcessor.createMethodDescription(additionalSecuredMethod));
                }
                if (securedMethods.rolesAllowed.isPresent()) {
                    transformers.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new AdditionalRolesAllowedTransformer(additionalSecured, (List)securedMethods.rolesAllowed.get())));
                    continue;
                }
                transformers.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new AdditionalDenyingUnannotatedTransformer(additionalSecured)));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    MethodSecurityChecks gatherSecurityChecks(BuildProducer<ConfigExpRolesAllowedSecurityCheckBuildItem> configExpSecurityCheckProducer, List<RolesAllowedConfigExpResolverBuildItem> rolesAllowedConfigExpResolverBuildItems, BeanArchiveIndexBuildItem beanArchiveBuildItem, BuildProducer<ApplicationClassPredicateBuildItem> classPredicate, BuildProducer<RunTimeConfigBuilderBuildItem> configBuilderProducer, List<AdditionalSecuredMethodsBuildItem> additionalSecuredMethods, SecurityCheckRecorder recorder, BuildProducer<ClassSecurityCheckStorageBuildItem> classSecurityCheckStorageProducer, List<RegisterClassSecurityCheckBuildItem> registerClassSecurityCheckBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, List<AdditionalSecurityCheckBuildItem> additionalSecurityChecks, SecurityBuildTimeConfig config) {
        classPredicate.produce((BuildItem)new ApplicationClassPredicateBuildItem((Predicate)new SecurityCheckStorageAppPredicate()));
        HashMap<MethodDescription, AdditionalSecured> additionalSecured = new HashMap<MethodDescription, AdditionalSecured>();
        for (AdditionalSecuredMethodsBuildItem securedMethods : additionalSecuredMethods) {
            for (MethodInfo m : securedMethods.additionalSecuredMethods) {
                additionalSecured.putIfAbsent(SecurityProcessor.createMethodDescription(m), new AdditionalSecured(m, securedMethods.rolesAllowed));
            }
        }
        IndexView index = beanArchiveBuildItem.getIndex();
        Map<MethodInfo, SecurityCheck> securityChecks = SecurityProcessor.gatherSecurityAnnotations(index, configExpSecurityCheckProducer, additionalSecured.values(), config.denyUnannotated(), recorder, configBuilderProducer, reflectiveClassBuildItemBuildProducer, rolesAllowedConfigExpResolverBuildItems, registerClassSecurityCheckBuildItems, classSecurityCheckStorageProducer);
        for (AdditionalSecurityCheckBuildItem additionalSecurityCheck : additionalSecurityChecks) {
            securityChecks.put(additionalSecurityCheck.getMethodInfo(), additionalSecurityCheck.getSecurityCheck());
        }
        return new MethodSecurityChecks(securityChecks);
    }

    @Consume(value=Capabilities.class)
    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void createSecurityCheckStorage(BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<ApplicationClassPredicateBuildItem> classPredicate, SecurityCheckRecorder recorder, MethodSecurityChecks securityChecksItem, List<DefaultSecurityCheckBuildItem> defaultSecurityCheckBuildItem) {
        classPredicate.produce((BuildItem)new ApplicationClassPredicateBuildItem((Predicate)new SecurityCheckStorageAppPredicate()));
        RuntimeValue builder = recorder.newBuilder();
        for (Map.Entry<MethodInfo, SecurityCheck> methodEntry : securityChecksItem.securityChecks.entrySet()) {
            MethodInfo method = methodEntry.getKey();
            String[] params = new String[method.parametersCount()];
            for (int i = 0; i < method.parametersCount(); ++i) {
                params[i] = method.parameterType(i).name().toString();
            }
            recorder.addMethod(builder, method.declaringClass().name().toString(), method.name(), params, methodEntry.getValue());
        }
        if (!defaultSecurityCheckBuildItem.isEmpty()) {
            if (defaultSecurityCheckBuildItem.size() > 1) {
                int itemCount = defaultSecurityCheckBuildItem.size();
                throw new IllegalStateException("Found %d DefaultSecurityCheckBuildItem items, ".formatted(itemCount) + "please make sure the item is produced exactly once");
            }
            List roles = defaultSecurityCheckBuildItem.get(0).getRolesAllowed();
            if (roles == null) {
                recorder.registerDefaultSecurityCheck(builder, recorder.denyAll());
            } else {
                recorder.registerDefaultSecurityCheck(builder, recorder.rolesAllowed(roles.toArray(new String[0])));
            }
        }
        recorder.create(builder);
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(SecurityCheckStorage.class).scope(ApplicationScoped.class)).unremovable()).creator(creator -> {
            ResultHandle ret = creator.invokeStaticMethod(MethodDescriptor.ofMethod(SecurityCheckRecorder.class, (String)"getStorage", SecurityCheckStorage.class, (Class[])new Class[0]), new ResultHandle[0]);
            creator.returnValue(ret);
        })).done());
    }

    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void resolveConfigExpressionRoles(Optional<ConfigExpRolesAllowedSecurityCheckBuildItem> configExpRolesChecks, SecurityCheckRecorder recorder) {
        if (configExpRolesChecks.isPresent()) {
            recorder.resolveRolesAllowedConfigExpRoles();
        }
    }

    private static Map<MethodInfo, SecurityCheck> gatherSecurityAnnotations(IndexView index, BuildProducer<ConfigExpRolesAllowedSecurityCheckBuildItem> configExpSecurityCheckProducer, Collection<AdditionalSecured> additionalSecuredMethods, boolean denyUnannotated, SecurityCheckRecorder recorder, BuildProducer<RunTimeConfigBuilderBuildItem> configBuilderProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, List<RolesAllowedConfigExpResolverBuildItem> rolesAllowedConfigExpResolverBuildItems, List<RegisterClassSecurityCheckBuildItem> registerClassSecurityCheckBuildItems, BuildProducer<ClassSecurityCheckStorageBuildItem> classSecurityCheckStorageProducer) {
        boolean registerRolesAllowedConfigSource;
        Map<Object, Object> classNameToPermCheck;
        HashMap<MethodInfo, AnnotationInstance> methodToInstanceCollector = new HashMap<MethodInfo, AnnotationInstance>();
        HashMap<ClassInfo, AnnotationInstance> classAnnotations = new HashMap<ClassInfo, AnnotationInstance>();
        HashMap<MethodInfo, SecurityCheck> result = new HashMap<MethodInfo, SecurityCheck>();
        SecurityProcessor.gatherSecurityAnnotations(index, DotNames.PERMIT_ALL, methodToInstanceCollector, classAnnotations, (m, i) -> result.put((MethodInfo)m, recorder.permitAll()));
        SecurityProcessor.gatherSecurityAnnotations(index, DotNames.AUTHENTICATED, methodToInstanceCollector, classAnnotations, (m, i) -> result.put((MethodInfo)m, recorder.authenticated()));
        SecurityProcessor.gatherSecurityAnnotations(index, DotNames.DENY_ALL, methodToInstanceCollector, classAnnotations, (m, i) -> result.put((MethodInfo)m, recorder.denyAll()));
        HashMap<MethodInfo, String[]> methodToRoles = new HashMap<MethodInfo, String[]>();
        SecurityProcessor.gatherSecurityAnnotations(index, DotNames.ROLES_ALLOWED, methodToInstanceCollector, classAnnotations, (methodInfo, instance) -> methodToRoles.put((MethodInfo)methodInfo, instance.value().asStringArray()));
        for (AdditionalSecured additionalSecuredMethod : additionalSecuredMethods) {
            if (!SecurityProcessor.isPublicNonStaticNonConstructor(additionalSecuredMethod.methodInfo)) continue;
            AnnotationInstance alreadyExistingInstance = (AnnotationInstance)methodToInstanceCollector.get(additionalSecuredMethod.methodInfo);
            if (additionalSecuredMethod.rolesAllowed.isPresent()) {
                if (alreadyExistingInstance == null) {
                    methodToRoles.put(additionalSecuredMethod.methodInfo, (String[])additionalSecuredMethod.rolesAllowed.get().toArray(String[]::new));
                    continue;
                }
                if (!SecurityProcessor.alreadyHasAnnotation(alreadyExistingInstance, DotNames.ROLES_ALLOWED)) continue;
                throw new IllegalStateException("Method " + additionalSecuredMethod.methodInfo.declaringClass() + "#" + additionalSecuredMethod.methodInfo.name() + " should not have been added as an additional secured method as it's already annotated with @RolesAllowed.");
            }
            if (alreadyExistingInstance == null) {
                result.put(additionalSecuredMethod.methodInfo, recorder.denyAll());
                continue;
            }
            if (!SecurityProcessor.alreadyHasAnnotation(alreadyExistingInstance, DotNames.DENY_ALL)) continue;
            throw new IllegalStateException("Method " + additionalSecuredMethod.methodInfo.declaringClass() + "#" + additionalSecuredMethod.methodInfo.name() + " should not have been added as an additional secured method as it's already annotated with @DenyAll.");
        }
        HashMap<Set<String>, SecurityCheck> cache = new HashMap<Set<String>, SecurityCheck>();
        AtomicInteger keyIndex = new AtomicInteger(0);
        AtomicBoolean hasRolesAllowedCheckWithConfigExp = new AtomicBoolean(false);
        for (Map.Entry entry : methodToRoles.entrySet()) {
            MethodInfo methodInfo2 = (MethodInfo)entry.getKey();
            result.put(methodInfo2, SecurityProcessor.computeRolesAllowedCheck(cache, hasRolesAllowedCheckWithConfigExp, keyIndex, recorder, (String[])entry.getValue()));
        }
        ArrayList<AnnotationInstance> permissionInstances = new ArrayList<AnnotationInstance>(index.getAnnotationsWithRepeatable(DotNames.PERMISSIONS_ALLOWED, index));
        if (!permissionInstances.isEmpty()) {
            List<AnnotationInstance> additionalClassInstances = registerClassSecurityCheckBuildItems.stream().filter(i -> DotNames.PERMISSIONS_ALLOWED.equals((Object)i.securityAnnotationInstance.name())).map(i -> i.securityAnnotationInstance).toList();
            PermissionSecurityChecks securityChecks = new PermissionSecurityChecks.PermissionSecurityChecksBuilder(recorder).gatherPermissionsAllowedAnnotations(permissionInstances, methodToInstanceCollector, classAnnotations, additionalClassInstances).validatePermissionClasses(index).createPermissionPredicates().build();
            result.putAll(securityChecks.getMethodSecurityChecks());
            classNameToPermCheck = securityChecks.getClassNameSecurityChecks();
            for (String permissionClass : securityChecks.permissionClasses()) {
                reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{permissionClass}).constructors().fields().methods().build());
                log.debugf("Register Permission class for reflection: %s", (Object)permissionClass);
            }
        } else {
            classNameToPermCheck = Map.of();
        }
        if (!registerClassSecurityCheckBuildItems.isEmpty()) {
            ClassSecurityCheckStorageBuildItem.ClassStorageBuilder classStorageBuilder = new ClassSecurityCheckStorageBuildItem.ClassStorageBuilder();
            registerClassSecurityCheckBuildItems.forEach(item -> {
                SecurityCheck securityCheck;
                DotName securityAnnotationName = item.securityAnnotationInstance.name();
                if (DotNames.DENY_ALL.equals((Object)securityAnnotationName)) {
                    securityCheck = recorder.denyAll();
                } else if (DotNames.PERMIT_ALL.equals((Object)securityAnnotationName)) {
                    securityCheck = recorder.permitAll();
                } else if (DotNames.AUTHENTICATED.equals((Object)securityAnnotationName)) {
                    securityCheck = recorder.authenticated();
                } else if (DotNames.ROLES_ALLOWED.equals((Object)securityAnnotationName)) {
                    String[] allowedRoles = item.securityAnnotationInstance.value().asStringArray();
                    securityCheck = SecurityProcessor.computeRolesAllowedCheck(cache, hasRolesAllowedCheckWithConfigExp, keyIndex, recorder, allowedRoles);
                } else if (DotNames.PERMISSIONS_ALLOWED.equals((Object)securityAnnotationName)) {
                    securityCheck = Objects.requireNonNull((SecurityCheck)classNameToPermCheck.get(item.className));
                } else {
                    throw new IllegalStateException("Found unknown security annotation: " + securityAnnotationName);
                }
                classStorageBuilder.addSecurityCheck(item.className, (Object)securityCheck);
            });
            classSecurityCheckStorageProducer.produce((BuildItem)classStorageBuilder.build());
        }
        if (!rolesAllowedConfigExpResolverBuildItems.isEmpty()) {
            registerRolesAllowedConfigSource = true;
            for (RolesAllowedConfigExpResolverBuildItem item2 : rolesAllowedConfigExpResolverBuildItems) {
                recorder.recordRolesAllowedConfigExpression(item2.getRoleConfigExpr(), keyIndex.getAndIncrement(), item2.getConfigValueRecorder());
            }
        } else {
            registerRolesAllowedConfigSource = hasRolesAllowedCheckWithConfigExp.get();
        }
        if (hasRolesAllowedCheckWithConfigExp.get()) {
            configExpSecurityCheckProducer.produce((BuildItem)new ConfigExpRolesAllowedSecurityCheckBuildItem());
        }
        if (registerRolesAllowedConfigSource) {
            configBuilderProducer.produce((BuildItem)new RunTimeConfigBuilderBuildItem(QuarkusSecurityRolesAllowedConfigBuilder.class.getName()));
        }
        if (denyUnannotated) {
            HashSet<ClassInfo> allClassesWithSecurityChecks = new HashSet<ClassInfo>(methodToInstanceCollector.keySet().size());
            for (MethodInfo methodInfo3 : methodToInstanceCollector.keySet()) {
                allClassesWithSecurityChecks.add(methodInfo3.declaringClass());
            }
            for (ClassInfo classWithSecurityCheck : allClassesWithSecurityChecks) {
                for (MethodInfo methodInfo4 : classWithSecurityCheck.methods()) {
                    if (!SecurityProcessor.isPublicNonStaticNonConstructor(methodInfo4) || methodToInstanceCollector.containsKey(methodInfo4)) continue;
                    result.put(methodInfo4, recorder.denyAll());
                }
            }
        }
        return result;
    }

    private static SecurityCheck computeRolesAllowedCheck(Map<Set<String>, SecurityCheck> cache, final AtomicBoolean hasRolesAllowedCheckWithConfigExp, final AtomicInteger keyIndex, final SecurityCheckRecorder recorder, final String[] allowedRoles) {
        return cache.computeIfAbsent(SecurityProcessor.getSetForKey(allowedRoles), new Function<Set<String>, SecurityCheck>(){

            @Override
            public SecurityCheck apply(Set<String> allowedRolesSet) {
                int[] configExpressionPositions = SecurityProcessor.configExpressionPositions(allowedRoles);
                if (configExpressionPositions.length > 0) {
                    hasRolesAllowedCheckWithConfigExp.set(true);
                    int[] configKeys = new int[configExpressionPositions.length];
                    for (int i = 0; i < configExpressionPositions.length; ++i) {
                        configKeys[i] = keyIndex.getAndIncrement();
                    }
                    return recorder.rolesAllowedSupplier(allowedRoles, configExpressionPositions, configKeys);
                }
                return recorder.rolesAllowed(allowedRoles);
            }
        });
    }

    public static int[] configExpressionPositions(String[] allowedRoles) {
        HashSet<Integer> expPositions = new HashSet<Integer>();
        for (int i = 0; i < allowedRoles.length; ++i) {
            int exprStart = allowedRoles[i].indexOf("${");
            if (exprStart < 0 || allowedRoles[i].indexOf(125, exprStart + 2) <= 0) continue;
            expPositions.add(i);
        }
        if (expPositions.isEmpty()) {
            return new int[0];
        }
        return expPositions.stream().mapToInt(Integer::intValue).toArray();
    }

    private static Set<String> getSetForKey(String[] allowedRoles) {
        if (allowedRoles.length == 0) {
            return Collections.emptySet();
        }
        if (allowedRoles.length == 1) {
            return Collections.singleton(allowedRoles[0]);
        }
        return new HashSet<String>(Arrays.asList(allowedRoles));
    }

    private static boolean alreadyHasAnnotation(AnnotationInstance alreadyExistingInstance, DotName annotationName) {
        return alreadyExistingInstance.target().kind() == AnnotationTarget.Kind.METHOD && alreadyExistingInstance.name().equals((Object)annotationName);
    }

    static boolean isPublicNonStaticNonConstructor(MethodInfo methodInfo) {
        return Modifier.isPublic(methodInfo.flags()) && !Modifier.isStatic(methodInfo.flags()) && !"<init>".equals(methodInfo.name());
    }

    private static void gatherSecurityAnnotations(IndexView index, DotName dotName, Map<MethodInfo, AnnotationInstance> alreadyCheckedMethods, Map<ClassInfo, AnnotationInstance> classLevelAnnotations, BiConsumer<MethodInfo, AnnotationInstance> putResult) {
        AnnotationTarget target;
        Collection instances = index.getAnnotations(dotName);
        for (AnnotationInstance instance : instances) {
            target = instance.target();
            if (target.kind() != AnnotationTarget.Kind.METHOD) continue;
            MethodInfo methodInfo = target.asMethod();
            if (alreadyCheckedMethods.containsKey(methodInfo)) {
                throw new IllegalStateException("Method " + methodInfo.name() + " of class " + methodInfo.declaringClass() + " is annotated with multiple security annotations");
            }
            alreadyCheckedMethods.put(methodInfo, instance);
            putResult.accept(methodInfo, instance);
        }
        for (AnnotationInstance instance : instances) {
            target = instance.target();
            if (target.kind() != AnnotationTarget.Kind.CLASS) continue;
            List methods = target.asClass().methods();
            AnnotationInstance existingClassInstance = classLevelAnnotations.get(target.asClass());
            if (existingClassInstance == null) {
                classLevelAnnotations.put(target.asClass(), instance);
                for (MethodInfo methodInfo : methods) {
                    AnnotationInstance alreadyExistingInstance = alreadyCheckedMethods.get(methodInfo);
                    if (alreadyExistingInstance != null) continue;
                    putResult.accept(methodInfo, instance);
                }
                continue;
            }
            throw new IllegalStateException("Class " + target.asClass() + " is annotated with multiple security annotations " + instance.name() + " and " + existingClassInstance.name());
        }
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SECURITY);
    }

    @BuildStep
    void registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> beans) {
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SecurityIdentityAssociation.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(IdentityProviderManagerCreator.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SecurityIdentityProxy.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(X509IdentityProvider.class));
    }

    @BuildStep
    AdditionalBeanBuildItem authorizationController(LaunchModeBuildItem launchMode) {
        Class<AuthorizationController> controllerClass = AuthorizationController.class;
        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT && !this.security.authorizationEnabledInDevMode()) {
            controllerClass = DevModeDisabledAuthorizationController.class;
        }
        return AdditionalBeanBuildItem.builder().addBeanClass(controllerClass).build();
    }

    @BuildStep
    void validateStartUpObserversNotSecured(SynthesisFinishedBuildItem synthesisFinished, ValidationPhaseBuildItem validationPhase, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrorProducer) {
        AnnotationStore annotationStore = (AnnotationStore)validationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        synthesisFinished.getObservers().stream().map(ObserverInfo::asObserver).filter(observer -> observer.getObservedType().name().equals((Object)STARTUP_EVENT_NAME)).map(ObserverInfo::getObserverMethod).filter(Objects::nonNull).forEach(mi -> {
            if (SecurityTransformerUtils.hasStandardSecurityAnnotation(annotationStore.getAnnotations((AnnotationTarget)mi)) || SecurityProcessor.hasClassLevelStandardSecurityAnnotation(mi, annotationStore)) {
                ClassInfo declaringClass = mi.declaringClass();
                SecurityTransformerUtils.findFirstStandardSecurityAnnotation(annotationStore.getAnnotations((AnnotationTarget)mi)).or(() -> SecurityTransformerUtils.findFirstStandardSecurityAnnotation(annotationStore.getAnnotations((AnnotationTarget)declaringClass))).map(AnnotationInstance::name).filter(name -> !name.equals((Object)DotNames.PERMIT_ALL)).ifPresent(securityAnnotation -> {
                    String errorMsg = String.format("Method '%s#%s' cannot observe '%s' as the method is secured with the '%s' annotation", declaringClass.name(), mi.name(), STARTUP_EVENT_NAME, securityAnnotation);
                    validationErrorProducer.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new ConfigurationException(errorMsg)}));
                });
            }
        });
    }

    @BuildStep
    void gatherClassSecurityChecks(BuildProducer<RegisterClassSecurityCheckBuildItem> producer, BeanArchiveIndexBuildItem indexBuildItem, List<ClassSecurityCheckAnnotationBuildItem> classAnnotationItems) {
        if (!classAnnotationItems.isEmpty()) {
            IndexView index = indexBuildItem.getIndex();
            classAnnotationItems.stream().map(ClassSecurityCheckAnnotationBuildItem::getClassAnnotation).map(arg_0 -> ((IndexView)index).getAnnotations(arg_0)).flatMap(Collection::stream).filter(ai -> ai.target().kind() == AnnotationTarget.Kind.CLASS).map(ai -> ai.target().asClass()).filter(SecurityTransformerUtils::hasStandardSecurityAnnotation).map(c -> new RegisterClassSecurityCheckBuildItem(c.name(), SecurityTransformerUtils.findFirstStandardSecurityAnnotation(c).get())).forEach(arg_0 -> producer.produce(arg_0));
        }
    }

    private static boolean hasClassLevelStandardSecurityAnnotation(MethodInfo method, AnnotationStore annotationStore) {
        return SecurityProcessor.applyClassLevenInterceptor(method, annotationStore) && SecurityTransformerUtils.hasStandardSecurityAnnotation(annotationStore.getAnnotations((AnnotationTarget)method.declaringClass()));
    }

    private static boolean applyClassLevenInterceptor(MethodInfo method, AnnotationStore store) {
        return !method.isConstructor() && Modifier.isPublic(method.flags()) && !store.hasAnnotation((AnnotationTarget)method, io.quarkus.arc.processor.DotNames.NO_CLASS_INTERCEPTORS);
    }

    static MethodDescription createMethodDescription(MethodInfo additionalSecuredMethod) {
        String[] paramTypes = new String[additionalSecuredMethod.parametersCount()];
        for (int i = 0; i < additionalSecuredMethod.parametersCount(); ++i) {
            paramTypes[i] = ((Type)additionalSecuredMethod.parameterTypes().get(i)).name().toString();
        }
        return new MethodDescription(additionalSecuredMethod.declaringClass().name().toString(), additionalSecuredMethod.name(), paramTypes);
    }

    static class SecurityCheckStorageAppPredicate
    implements Predicate<String> {
        SecurityCheckStorageAppPredicate() {
        }

        @Override
        public boolean test(String s) {
            return s.equals(SecurityCheckStorage.class.getName());
        }
    }

    static class AdditionalSecured {
        final MethodInfo methodInfo;
        final Optional<List<String>> rolesAllowed;

        AdditionalSecured(MethodInfo methodInfo, Optional<List<String>> rolesAllowed) {
            this.methodInfo = methodInfo;
            this.rolesAllowed = rolesAllowed;
        }
    }

    static final class MethodSecurityChecks
    extends SimpleBuildItem {
        Map<MethodInfo, SecurityCheck> securityChecks;

        MethodSecurityChecks(Map<MethodInfo, SecurityCheck> securityChecks) {
            this.securityChecks = securityChecks;
        }
    }
}

