/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.security.StringPermission;
import io.quarkus.security.deployment.DotNames;
import io.quarkus.security.deployment.SecurityProcessor;
import io.quarkus.security.runtime.SecurityCheckRecorder;
import io.quarkus.security.runtime.interceptor.PermissionsAllowedInterceptor;
import io.quarkus.security.spi.PermissionsAllowedMetaAnnotationBuildItem;
import io.quarkus.security.spi.runtime.SecurityCheck;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Modifier;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

interface PermissionSecurityChecks {
    public Map<MethodInfo, SecurityCheck> getMethodSecurityChecks();

    public Map<DotName, SecurityCheck> getClassNameSecurityChecks();

    public Set<String> permissionClasses();

    private static String hashCodeToString(Object object) {
        return ("" + object.hashCode()).replace('-', '_');
    }

    private static String toFieldGetter(String paramExpression) {
        return "get" + paramExpression.substring(0, 1).toUpperCase() + paramExpression.substring(1);
    }

    public record SecMethodAndPermCtorIdx(int methodParamIdx, int constructorParamIdx, String nestedParamExpression, Integer requiredParamIdx) {
        SecMethodAndPermCtorIdx(int methodParamIdx, int constructorParamIdx) {
            this(methodParamIdx, constructorParamIdx, null, null);
        }
    }

    public static final class PermissionConverterGenerator {
        private static final String GENERATED_CLASS_NAME = "io.quarkus.security.runtime.PermissionMethodConverter";
        private final BuildProducer<GeneratedClassBuildItem> generatedClassesProducer;
        private final BuildProducer<ReflectiveClassBuildItem> reflectiveClassesProducer;
        private final SecurityCheckRecorder recorder;
        private final Map<String, RuntimeValue<MethodHandle>> converterNameToMethodHandle = new HashMap<String, RuntimeValue<MethodHandle>>();
        private final IndexView index;
        private ClassCreator classCreator;
        private boolean closed;
        private RuntimeValue<Class<?>> clazz;

        private PermissionConverterGenerator(BuildProducer<GeneratedClassBuildItem> generatedClassesProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassesProducer, SecurityCheckRecorder recorder, IndexView index) {
            this.generatedClassesProducer = generatedClassesProducer;
            this.reflectiveClassesProducer = reflectiveClassesProducer;
            this.recorder = recorder;
            this.index = index;
            this.classCreator = null;
            this.closed = true;
            this.clazz = null;
        }

        private ClassCreator getOrCreateClass() {
            if (this.classCreator == null) {
                this.classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(this.generatedClassesProducer, true)).className(GENERATED_CLASS_NAME).setFinal(true).build();
                this.closed = false;
                this.reflectiveClassesProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{GENERATED_CLASS_NAME}).methods().build());
            }
            return this.classCreator;
        }

        private RuntimeValue<Class<?>> getClazz() {
            if (this.clazz == null) {
                this.clazz = this.recorder.loadClassRuntimeVal(GENERATED_CLASS_NAME);
            }
            return this.clazz;
        }

        private void close() {
            if (!this.closed) {
                this.closed = true;
                this.classCreator.close();
            }
        }

        private Map<String, RuntimeValue<MethodHandle>> getConverterNameToMethodHandle() {
            return this.converterNameToMethodHandle.isEmpty() ? null : Map.copyOf(this.converterNameToMethodHandle);
        }

        private String createConverter(String paramRemainder, MethodInfo securedMethod, int methodParamIdx) {
            String[] nestedParams = paramRemainder.split("\\.");
            String converterName = this.createConverterName(securedMethod);
            try (MethodCreator methodCreator = this.getOrCreateClass().getMethodCreator(converterName, Object.class, new Class[]{Object.class});){
                methodCreator.setModifiers(9);
                ResultHandle paramToConvert = methodCreator.getMethodParam(0);
                Type paramType = securedMethod.parameterType(methodParamIdx);
                ResultHandle result = this.getNestedParam(nestedParams, 0, paramToConvert, methodCreator, paramType, securedMethod, methodParamIdx);
                methodCreator.returnValue(result);
            }
            RuntimeValue methodHandleRuntimeVal = this.recorder.createPermissionMethodConverter(converterName, this.getClazz());
            this.converterNameToMethodHandle.put(converterName, (RuntimeValue<MethodHandle>)methodHandleRuntimeVal);
            return converterName;
        }

        private ResultHandle getNestedParam(String[] nestedParams, int nestedParamIdx, ResultHandle outer, MethodCreator methodCreator, Type outerType, MethodInfo securedMethod, int methodParamIdx) {
            Type newOuterType;
            ResultHandle newOuter;
            if (nestedParamIdx == nestedParams.length) {
                return outer;
            }
            String paramExpression = nestedParams[nestedParamIdx];
            ClassInfo outerClass = this.index.getClassByName(outerType.name());
            if (outerClass == null) {
                throw new IllegalArgumentException("    Method '%s#%s' parameter '%s' cannot be converted to a Permission constructor parameter\n    as required by the '@PermissionsAllowed#params' attribute. Parameter expression references '%s'\n    that has type '%s' which is not a class. Only class methods or fields can be mapped\n    to a Permission constructor parameter.\n".formatted(securedMethod.declaringClass().name(), securedMethod.name(), securedMethod.parameterName(methodParamIdx), paramExpression, outerType.name()));
            }
            MethodInfo method = outerClass.method(paramExpression, new Type[0]);
            if (method == null) {
                method = outerClass.method(PermissionSecurityChecks.toFieldGetter(paramExpression), new Type[0]);
            }
            if (method != null) {
                if (!Modifier.isPublic(method.flags())) {
                    throw new IllegalArgumentException("Method '%s#%s' parameter '%s' cannot be mapped to a Permission constructor parameter,\nbecause expression '%s' specified in the '@PermissionsAllowed#params' attribute is\naccessible from method '%s#%s' which is not a public method.\n".formatted(securedMethod.declaringClass().name(), securedMethod.name(), securedMethod.parameterName(methodParamIdx), paramExpression, method.declaringClass().name(), method.name()));
                }
                newOuter = outerClass.isInterface() ? methodCreator.invokeInterfaceMethod(method, outer, new ResultHandle[0]) : methodCreator.invokeVirtualMethod(method, outer, new ResultHandle[0]);
                newOuterType = method.returnType();
            } else {
                FieldInfo field = outerClass.field(paramExpression);
                if (field == null) {
                    throw new IllegalArgumentException("Method '%s#%s' parameter '%s' cannot be mapped to a Permission constructor parameter,\nbecause expression '%s' specified in the '@PermissionsAllowed#params' attribute does not\nmatch any method or field of the class '%s'.\n".formatted(securedMethod.declaringClass().name(), securedMethod.name(), securedMethod.parameterName(methodParamIdx), paramExpression, outerClass.name()));
                }
                if (!Modifier.isPublic(field.flags())) {
                    throw new IllegalArgumentException("Method '%s#%s' parameter '%s' cannot be mapped to a Permission constructor parameter,\nbecause expression '%s' specified in the '@PermissionsAllowed#params' attribute is only\naccessible from field '%s#%s' which is not a public field. Please declare a getter method.\n".formatted(securedMethod.declaringClass().name(), securedMethod.name(), securedMethod.parameterName(methodParamIdx), paramExpression, field.declaringClass().name(), field.name()));
                }
                newOuter = methodCreator.readInstanceField(field, outer);
                newOuterType = field.type();
            }
            return this.getNestedParam(nestedParams, nestedParamIdx + 1, newOuter, methodCreator, newOuterType, securedMethod, methodParamIdx);
        }

        private String createConverterName(MethodInfo securedMethod) {
            return this.createConverterName(securedMethod, 0);
        }

        private String createConverterName(MethodInfo securedMethod, int idx) {
            String converterName = PermissionSecurityChecks.hashCodeToString(securedMethod.hashCode()) + "_" + idx;
            if (this.converterNameToMethodHandle.containsKey(converterName)) {
                return this.createConverterName(securedMethod, idx + 1);
            }
            return converterName;
        }
    }

    public static final class PermissionSecurityChecksBuilder {
        private static final DotName STRING_PERMISSION = DotName.createSimple(StringPermission.class);
        private static final DotName PERMISSIONS_ALLOWED_INTERCEPTOR = DotName.createSimple(PermissionsAllowedInterceptor.class);
        private final Map<AnnotationTarget, List<List<PermissionKey>>> targetToPermissionKeys = new HashMap<AnnotationTarget, List<List<PermissionKey>>>();
        private final Map<AnnotationTarget, LogicalAndPermissionPredicate> targetToPredicate = new HashMap<AnnotationTarget, LogicalAndPermissionPredicate>();
        private final Map<String, MethodInfo> classSignatureToConstructor = new HashMap<String, MethodInfo>();
        private final SecurityCheckRecorder recorder;
        private final PermissionConverterGenerator paramConverterGenerator;

        public PermissionSecurityChecksBuilder(SecurityCheckRecorder recorder, BuildProducer<GeneratedClassBuildItem> generatedClassesProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassesProducer, IndexView index) {
            this.recorder = recorder;
            this.paramConverterGenerator = new PermissionConverterGenerator(generatedClassesProducer, reflectiveClassesProducer, recorder, index);
        }

        PermissionSecurityChecks build() {
            this.paramConverterGenerator.close();
            HashMap<LogicalAndPermissionPredicate, SecurityCheck> cache = new HashMap<LogicalAndPermissionPredicate, SecurityCheck>();
            final HashMap<MethodInfo, SecurityCheck> methodToCheck = new HashMap<MethodInfo, SecurityCheck>();
            final HashMap<DotName, SecurityCheck> classNameToCheck = new HashMap<DotName, SecurityCheck>();
            for (Map.Entry<AnnotationTarget, LogicalAndPermissionPredicate> targetToPredicate : this.targetToPredicate.entrySet()) {
                SecurityCheck check = cache.computeIfAbsent(targetToPredicate.getValue(), this::createSecurityCheck);
                AnnotationTarget annotationTarget = targetToPredicate.getKey();
                if (annotationTarget.kind() == AnnotationTarget.Kind.CLASS) {
                    DotName className = annotationTarget.asClass().name();
                    classNameToCheck.put(className, check);
                    continue;
                }
                MethodInfo securedMethod = annotationTarget.asMethod();
                methodToCheck.put(securedMethod, check);
            }
            return new PermissionSecurityChecks(){

                @Override
                public Map<MethodInfo, SecurityCheck> getMethodSecurityChecks() {
                    return Map.copyOf(methodToCheck);
                }

                @Override
                public Map<DotName, SecurityCheck> getClassNameSecurityChecks() {
                    return Map.copyOf(classNameToCheck);
                }

                @Override
                public Set<String> permissionClasses() {
                    return classSignatureToConstructor.keySet();
                }
            };
        }

        PermissionSecurityChecksBuilder createPermissionPredicates() {
            HashMap<PermissionCacheKey, PermissionWrapper> permissionCache = new HashMap<PermissionCacheKey, PermissionWrapper>();
            for (Map.Entry<AnnotationTarget, List<List<PermissionKey>>> entry : this.targetToPermissionKeys.entrySet()) {
                AnnotationTarget securedTarget = entry.getKey();
                LogicalAndPermissionPredicate predicate = new LogicalAndPermissionPredicate();
                for (List<PermissionKey> permissionKeys : entry.getValue()) {
                    boolean inclusive = this.isInclusive(permissionKeys);
                    if (inclusive) {
                        for (PermissionKey permissionKey : permissionKeys) {
                            PermissionWrapper permission = this.createPermission(permissionKey, securedTarget, permissionCache);
                            if (permission.isComputed()) {
                                predicate.markAsComputed();
                            }
                            predicate.and(new LogicalOrPermissionPredicate().or(permission));
                        }
                        continue;
                    }
                    LogicalOrPermissionPredicate orPredicate = new LogicalOrPermissionPredicate();
                    predicate.and(orPredicate);
                    for (PermissionKey permissionKey : permissionKeys) {
                        PermissionWrapper permission = this.createPermission(permissionKey, securedTarget, permissionCache);
                        if (permission.isComputed()) {
                            predicate.markAsComputed();
                        }
                        orPredicate.or(permission);
                    }
                }
                this.targetToPredicate.put(securedTarget, predicate);
            }
            return this;
        }

        private boolean isInclusive(List<PermissionKey> permissionKeys) {
            if (permissionKeys.isEmpty()) {
                return false;
            }
            return permissionKeys.get((int)0).inclusive;
        }

        PermissionSecurityChecksBuilder validatePermissionClasses(IndexView index) {
            for (List<List<PermissionKey>> keyLists : this.targetToPermissionKeys.values()) {
                for (List<PermissionKey> keyList : keyLists) {
                    for (PermissionKey key : keyList) {
                        if (this.classSignatureToConstructor.containsKey(key.classSignature())) continue;
                        ClassInfo clazz = index.getClassByName(key.clazz.name());
                        Objects.requireNonNull(clazz);
                        if (clazz.constructors().size() != 1) {
                            throw new RuntimeException(String.format("Permission class '%s' has %d constructors, exactly one is allowed", key.classSignature(), clazz.constructors().size()));
                        }
                        MethodInfo constructor = (MethodInfo)clazz.constructors().get(0);
                        if (constructor.parametersCount() == 0 || !io.quarkus.arc.processor.DotNames.STRING.equals((Object)constructor.parameterType(0).name())) {
                            throw new RuntimeException(String.format("Permission constructor '%s' first argument must be '%s'", clazz.name().toString(), String.class.getName()));
                        }
                        this.classSignatureToConstructor.put(key.classSignature(), constructor);
                    }
                }
            }
            return this;
        }

        PermissionSecurityChecksBuilder gatherPermissionsAllowedAnnotations(List<AnnotationInstance> instances, Map<MethodInfo, AnnotationInstance> alreadyCheckedMethods, Map<ClassInfo, AnnotationInstance> alreadyCheckedClasses, List<AnnotationInstance> additionalClassInstances, Predicate<MethodInfo> hasAdditionalSecurityAnnotations) {
            instances.sort(new Comparator<AnnotationInstance>(){

                @Override
                public int compare(AnnotationInstance o1, AnnotationInstance o2) {
                    if (o1.target().kind() != o2.target().kind()) {
                        return o1.target().kind() == AnnotationTarget.Kind.METHOD ? -1 : 1;
                    }
                    return 0;
                }
            });
            ArrayList<PermissionKey> cache = new ArrayList<PermissionKey>();
            HashMap classMethodToPermissionKeys = new HashMap();
            for (AnnotationInstance instance : instances) {
                ClassInfo clazz;
                AnnotationTarget target = instance.target();
                if (target.kind() == AnnotationTarget.Kind.METHOD) {
                    MethodInfo methodInfo = target.asMethod();
                    if (alreadyCheckedMethods.containsKey(methodInfo) || hasAdditionalSecurityAnnotations.test(methodInfo)) {
                        throw new IllegalStateException(String.format("Method %s of class %s is annotated with multiple security annotations", methodInfo.name(), methodInfo.declaringClass()));
                    }
                    PermissionSecurityChecksBuilder.gatherPermissionKeys(instance, methodInfo, cache, this.targetToPermissionKeys);
                    continue;
                }
                if (target.kind() != AnnotationTarget.Kind.CLASS || PermissionSecurityChecksBuilder.isPermissionsAllowedInterceptor(clazz = target.asClass()) || clazz.isAnnotation()) continue;
                AnnotationInstance existingClassInstance = alreadyCheckedClasses.get(clazz);
                if (existingClassInstance == null) {
                    for (MethodInfo methodInfo : clazz.methods()) {
                        boolean noMethodLevelPermissionsAllowed;
                        if (!SecurityProcessor.isPublicNonStaticNonConstructor(methodInfo) || hasAdditionalSecurityAnnotations.test(methodInfo)) continue;
                        boolean noMethodLevelSecurityAnnotation = !alreadyCheckedMethods.containsKey(methodInfo);
                        boolean bl = noMethodLevelPermissionsAllowed = !this.targetToPermissionKeys.containsKey(methodInfo);
                        if (!noMethodLevelSecurityAnnotation || !noMethodLevelPermissionsAllowed) continue;
                        PermissionSecurityChecksBuilder.gatherPermissionKeys(instance, methodInfo, cache, classMethodToPermissionKeys);
                    }
                    continue;
                }
                throw new IllegalStateException(String.format("Class %s is annotated with multiple security annotations %s and %s", clazz, instance.name(), existingClassInstance.name()));
            }
            this.targetToPermissionKeys.putAll(classMethodToPermissionKeys);
            for (AnnotationInstance instance : additionalClassInstances) {
                PermissionSecurityChecksBuilder.gatherPermissionKeys(instance, instance.target(), cache, this.targetToPermissionKeys);
            }
            ArrayList<AnnotationInstance> targetInstances = new ArrayList<AnnotationInstance>(instances);
            targetInstances.addAll(additionalClassInstances);
            this.targetToPermissionKeys.keySet().forEach(at -> {
                if (at.kind() == AnnotationTarget.Kind.CLASS) {
                    ClassInfo classInfo = at.asClass();
                    alreadyCheckedClasses.put(classInfo, PermissionSecurityChecksBuilder.getAnnotationInstance(classInfo, (List<AnnotationInstance>)targetInstances));
                } else {
                    MethodInfo methodInfo = at.asMethod();
                    AnnotationInstance methodLevelAnn = PermissionSecurityChecksBuilder.getAnnotationInstance(methodInfo, (List<AnnotationInstance>)targetInstances);
                    if (methodLevelAnn != null) {
                        alreadyCheckedMethods.put(methodInfo, methodLevelAnn);
                    } else {
                        ClassInfo classInfo = methodInfo.declaringClass();
                        alreadyCheckedClasses.put(classInfo, PermissionSecurityChecksBuilder.getAnnotationInstance(classInfo, (List<AnnotationInstance>)targetInstances));
                    }
                }
            });
            return this;
        }

        static boolean isPermissionsAllowedInterceptor(ClassInfo clazz) {
            return PERMISSIONS_ALLOWED_INTERCEPTOR.equals((Object)clazz.name()) || clazz.name().toString().endsWith("PermissionsAllowedInterceptor");
        }

        static ArrayList<AnnotationInstance> getPermissionsAllowedInstances(IndexView index, PermissionsAllowedMetaAnnotationBuildItem item) {
            ArrayList<AnnotationInstance> instances = PermissionSecurityChecksBuilder.getPermissionsAllowedInstances(index);
            if (!item.getTransitiveInstances().isEmpty()) {
                instances.addAll(item.getTransitiveInstances());
            }
            return instances;
        }

        static ArrayList<AnnotationInstance> getPermissionsAllowedInstances(IndexView index) {
            return new ArrayList<AnnotationInstance>(index.getAnnotationsWithRepeatable(DotNames.PERMISSIONS_ALLOWED, index));
        }

        static PermissionsAllowedMetaAnnotationBuildItem movePermFromMetaAnnToMetaTarget(IndexView index) {
            List<AnnotationInstance> permissionsAllowed = PermissionSecurityChecksBuilder.getPermissionsAllowedInstances(index).stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.CLASS).filter(ai -> ai.target().asClass().isAnnotation()).toList();
            ArrayList metaAnnotationNames = new ArrayList();
            List newInstances = permissionsAllowed.stream().flatMap(instanceOnMetaAnn -> {
                DotName metaAnnotationName = instanceOnMetaAnn.target().asClass().name();
                metaAnnotationNames.add(metaAnnotationName);
                return index.getAnnotations(metaAnnotationName).stream().map(ai -> AnnotationInstance.create((DotName)DotNames.PERMISSIONS_ALLOWED, (AnnotationTarget)ai.target(), (List)instanceOnMetaAnn.values()));
            }).toList();
            return new PermissionsAllowedMetaAnnotationBuildItem(newInstances, metaAnnotationNames);
        }

        private static AnnotationInstance getAnnotationInstance(ClassInfo classInfo, List<AnnotationInstance> annotationInstances) {
            return annotationInstances.stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.CLASS).filter(ai -> ai.target().asClass().name().equals((Object)classInfo.name())).findFirst().orElseThrow();
        }

        private static AnnotationInstance getAnnotationInstance(MethodInfo methodInfo, List<AnnotationInstance> annotationInstances) {
            return annotationInstances.stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD).filter(ai -> ai.target().asMethod().name().equals(methodInfo.name())).findFirst().orElse(null);
        }

        private static <T extends AnnotationTarget> void gatherPermissionKeys(AnnotationInstance instance, T annotationTarget, List<PermissionKey> cache, Map<T, List<List<PermissionKey>>> targetToPermissionKeys) {
            String[] stringArray;
            HashMap permissionToActions = new HashMap();
            for (String permissionToAction : instance.value().asStringArray()) {
                if (permissionToAction.contains(":")) {
                    String[] permissionToActionArr = permissionToAction.split(":");
                    if (permissionToActionArr.length != 2) {
                        throw new RuntimeException(String.format("PermissionsAllowed value '%s' contains more than one separator '%2$s', expected format is 'permissionName%2$saction'", permissionToAction, ":"));
                    }
                    String permissionName = permissionToActionArr[0];
                    String action = permissionToActionArr[1];
                    if (permissionToActions.containsKey(permissionName)) {
                        ((Set)permissionToActions.get(permissionName)).add(action);
                        continue;
                    }
                    HashSet<String> actions = new HashSet<String>();
                    actions.add(action);
                    permissionToActions.put(permissionName, actions);
                    continue;
                }
                if (permissionToActions.containsKey(permissionToAction)) continue;
                permissionToActions.put(permissionToAction, new HashSet());
            }
            if (permissionToActions.isEmpty()) {
                if (annotationTarget.kind() == AnnotationTarget.Kind.METHOD) {
                    throw new RuntimeException(String.format("Method '%s' was annotated with '@PermissionsAllowed', but no valid permission was provided", annotationTarget.asMethod().name()));
                }
                throw new RuntimeException(String.format("Class '%s' was annotated with '@PermissionsAllowed', but no valid permission was provided", annotationTarget.asClass().name()));
            }
            ArrayList<PermissionKey> orPermissions = new ArrayList<PermissionKey>();
            if (instance.value("params") == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "<<autodetected>>";
            } else {
                stringArray = instance.value("params").asStringArray();
            }
            String[] params = stringArray;
            Type classType = instance.value("permission") == null ? Type.create((DotName)STRING_PERMISSION, (Type.Kind)Type.Kind.CLASS) : instance.value("permission").asClass();
            boolean inclusive = instance.value("inclusive") != null && instance.value("inclusive").asBoolean();
            for (Map.Entry permissionToAction : permissionToActions.entrySet()) {
                PermissionKey key = new PermissionKey((String)permissionToAction.getKey(), (Set)permissionToAction.getValue(), params, classType, inclusive);
                int i = cache.indexOf(key);
                if (i == -1) {
                    orPermissions.add(key);
                    cache.add(key);
                    continue;
                }
                orPermissions.add(cache.get(i));
            }
            targetToPermissionKeys.computeIfAbsent(annotationTarget, at -> new ArrayList()).add(List.copyOf(orPermissions));
        }

        private SecurityCheck createSecurityCheck(LogicalAndPermissionPredicate andPredicate) {
            SecurityCheck securityCheck;
            boolean isSinglePermissionGroup;
            boolean bl = isSinglePermissionGroup = andPredicate.operands.size() == 1;
            if (isSinglePermissionGroup) {
                boolean isSinglePermission;
                LogicalOrPermissionPredicate orPredicate = andPredicate.operands.iterator().next();
                boolean bl2 = isSinglePermission = orPredicate.operands.size() == 1;
                if (isSinglePermission) {
                    PermissionWrapper permissionWrapper = orPredicate.operands.iterator().next();
                    securityCheck = this.recorder.permissionsAllowed(permissionWrapper.computedPermission, permissionWrapper.permission);
                } else {
                    securityCheck = andPredicate.atLeastOnePermissionIsComputed ? this.recorder.permissionsAllowed(orPredicate.asComputedPermissions(this.recorder), null) : this.recorder.permissionsAllowed(null, orPredicate.asPermissions());
                }
            } else if (andPredicate.atLeastOnePermissionIsComputed) {
                ArrayList<List<Function<Object[], Permission>>> computedPermissionGroups = new ArrayList<List<Function<Object[], Permission>>>();
                for (LogicalOrPermissionPredicate permissionGroup : andPredicate.operands) {
                    computedPermissionGroups.add(permissionGroup.asComputedPermissions(this.recorder));
                }
                securityCheck = this.recorder.permissionsAllowedGroups(computedPermissionGroups, null);
            } else {
                ArrayList<List<RuntimeValue<Permission>>> permissionGroups = new ArrayList<List<RuntimeValue<Permission>>>();
                for (LogicalOrPermissionPredicate permissionGroup : andPredicate.operands) {
                    permissionGroups.add(permissionGroup.asPermissions());
                }
                securityCheck = this.recorder.permissionsAllowedGroups(null, permissionGroups);
            }
            return securityCheck;
        }

        private PermissionWrapper createPermission(PermissionKey permissionKey, AnnotationTarget securedTarget, Map<PermissionCacheKey, PermissionWrapper> cache) {
            MethodInfo constructor = this.classSignatureToConstructor.get(permissionKey.classSignature());
            return cache.computeIfAbsent(new PermissionCacheKey(permissionKey, securedTarget, constructor, this.paramConverterGenerator), new Function<PermissionCacheKey, PermissionWrapper>(){

                @Override
                public PermissionWrapper apply(PermissionCacheKey permissionCacheKey) {
                    if (permissionCacheKey.computed) {
                        return new PermissionWrapper(this.createComputedPermission(permissionCacheKey), null);
                    }
                    RuntimeValue<Permission> permission = permissionCacheKey.isStringPermission() ? this.createStringPermission(permissionCacheKey.permissionKey) : this.createCustomPermission(permissionCacheKey);
                    return new PermissionWrapper(null, permission);
                }
            });
        }

        private Function<Object[], Permission> createComputedPermission(PermissionCacheKey permissionCacheKey) {
            return this.recorder.createComputedPermission(permissionCacheKey.permissionKey.name, permissionCacheKey.permissionKey.classSignature(), permissionCacheKey.permissionKey.actions(), permissionCacheKey.passActionsToConstructor, permissionCacheKey.methodParamIndexes(), permissionCacheKey.methodParamConverters, this.paramConverterGenerator.getConverterNameToMethodHandle());
        }

        private RuntimeValue<Permission> createCustomPermission(PermissionCacheKey permissionCacheKey) {
            return this.recorder.createPermission(permissionCacheKey.permissionKey.name, permissionCacheKey.permissionKey.classSignature(), permissionCacheKey.permissionKey.actions(), permissionCacheKey.passActionsToConstructor);
        }

        private RuntimeValue<Permission> createStringPermission(PermissionKey permissionKey) {
            if (permissionKey.notAutodetectParams()) {
                throw new IllegalArgumentException(String.format("'%s' must have autodetected params", STRING_PERMISSION));
            }
            return this.recorder.createStringPermission(permissionKey.name, permissionKey.actions());
        }

        private static String matchNestedParamByName(ClassInfo clazz, String constructorParamName) {
            MethodInfo method = clazz.method(constructorParamName, new Type[0]);
            if (method != null && Modifier.isPublic(method.flags())) {
                return constructorParamName;
            }
            String getter = PermissionSecurityChecks.toFieldGetter(constructorParamName);
            method = clazz.method(getter, new Type[0]);
            if (method != null && Modifier.isPublic(method.flags())) {
                return getter;
            }
            FieldInfo field = clazz.field(constructorParamName);
            if (field != null && Modifier.isPublic(field.flags())) {
                return field.name();
            }
            return null;
        }

        private static int[] getMethodParamIndexes(SecMethodAndPermCtorIdx[] matches) {
            int[] result = new int[matches.length];
            for (int i = 0; i < matches.length; ++i) {
                result[i] = matches[i].methodParamIdx();
            }
            return result;
        }

        private static final class LogicalAndPermissionPredicate {
            private final Set<LogicalOrPermissionPredicate> operands = new HashSet<LogicalOrPermissionPredicate>();
            private boolean atLeastOnePermissionIsComputed = false;

            private LogicalAndPermissionPredicate() {
            }

            private void and(LogicalOrPermissionPredicate orPermissionPredicate) {
                this.operands.add(orPermissionPredicate);
            }

            private void markAsComputed() {
                if (!this.atLeastOnePermissionIsComputed) {
                    this.atLeastOnePermissionIsComputed = true;
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogicalAndPermissionPredicate that = (LogicalAndPermissionPredicate)o;
                return this.operands.equals(that.operands);
            }

            public int hashCode() {
                return Objects.hash(this.operands);
            }
        }

        private static final class PermissionKey {
            private final String name;
            private final Set<String> actions;
            private final String[] params;
            private final String[] paramsRemainder;
            private final Type clazz;
            private final boolean inclusive;

            private PermissionKey(String name, Set<String> actions, String[] params, Type clazz, boolean inclusive) {
                this.name = name;
                this.clazz = clazz;
                this.inclusive = inclusive;
                this.actions = !actions.isEmpty() ? actions : null;
                if (params == null || params.length == 0) {
                    this.params = new String[0];
                    this.paramsRemainder = null;
                } else {
                    this.params = new String[params.length];
                    String[] remainder = new String[params.length];
                    boolean requiresConverter = false;
                    for (int i = 0; i < params.length; ++i) {
                        String securedMethodParamName;
                        int firstDot = params[i].indexOf(46);
                        if (firstDot == -1) {
                            this.params[i] = params[i];
                            continue;
                        }
                        requiresConverter = true;
                        this.params[i] = securedMethodParamName = params[i].substring(0, firstDot);
                        remainder[i] = params[i].substring(firstDot + 1);
                    }
                    this.paramsRemainder = requiresConverter ? remainder : null;
                }
            }

            private String classSignature() {
                return this.clazz.name().toString();
            }

            private boolean notAutodetectParams() {
                return this.params.length != 1 || !"<<autodetected>>".equals(this.params[0]);
            }

            private String[] actions() {
                return this.actions == null ? null : this.actions.toArray(new String[0]);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PermissionKey that = (PermissionKey)o;
                return this.name.equals(that.name) && Objects.equals(this.actions, that.actions) && Arrays.equals(this.params, that.params) && this.clazz.equals((Object)that.clazz) && this.inclusive == that.inclusive && Arrays.equals(this.paramsRemainder, that.paramsRemainder);
            }

            public int hashCode() {
                int result = Objects.hash(this.name, this.actions, this.clazz, this.inclusive);
                result = 31 * result + Arrays.hashCode(this.params);
                if (this.paramsRemainder != null) {
                    result = 67 * result + Arrays.hashCode(this.paramsRemainder);
                }
                return result;
            }
        }

        private static final class PermissionWrapper {
            private final Function<Object[], Permission> computedPermission;
            private final RuntimeValue<Permission> permission;

            private PermissionWrapper(Function<Object[], Permission> computedPermission, RuntimeValue<Permission> permission) {
                this.computedPermission = computedPermission;
                this.permission = permission;
            }

            private boolean isComputed() {
                return this.permission == null;
            }
        }

        private static final class LogicalOrPermissionPredicate {
            private final Set<PermissionWrapper> operands = new HashSet<PermissionWrapper>();

            private LogicalOrPermissionPredicate() {
            }

            private LogicalOrPermissionPredicate or(PermissionWrapper permission) {
                this.operands.add(permission);
                return this;
            }

            private List<Function<Object[], Permission>> asComputedPermissions(SecurityCheckRecorder recorder) {
                ArrayList<Function> computedPermissions = new ArrayList<Function>();
                for (PermissionWrapper wrapper : this.operands) {
                    if (wrapper.isComputed()) {
                        computedPermissions.add(wrapper.computedPermission);
                        continue;
                    }
                    computedPermissions.add(recorder.toComputedPermission(wrapper.permission));
                }
                return List.copyOf(computedPermissions);
            }

            private List<RuntimeValue<Permission>> asPermissions() {
                ArrayList<RuntimeValue<Permission>> permissions = new ArrayList<RuntimeValue<Permission>>();
                for (PermissionWrapper wrapper : this.operands) {
                    Objects.requireNonNull(wrapper.permission);
                    permissions.add(wrapper.permission);
                }
                return List.copyOf(permissions);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogicalOrPermissionPredicate that = (LogicalOrPermissionPredicate)o;
                return this.operands.equals(that.operands);
            }

            public int hashCode() {
                return Objects.hash(this.operands);
            }
        }

        private static final class PermissionCacheKey {
            private final int[] methodParamIndexes;
            private final PermissionKey permissionKey;
            private final boolean computed;
            private final boolean passActionsToConstructor;
            private final String[] methodParamConverters;

            private PermissionCacheKey(PermissionKey permissionKey, AnnotationTarget securedTarget, MethodInfo constructor, PermissionConverterGenerator paramConverterGenerator) {
                if (PermissionCacheKey.isComputed(permissionKey, constructor)) {
                    int foundIx;
                    boolean isSecondParamStringArr;
                    if (securedTarget.kind() != AnnotationTarget.Kind.METHOD) {
                        throw new IllegalArgumentException("@PermissionAllowed instance that accepts method arguments must be placed on a method");
                    }
                    MethodInfo securedMethod = securedTarget.asMethod();
                    this.permissionKey = permissionKey;
                    this.computed = true;
                    boolean bl = isSecondParamStringArr = !PermissionCacheKey.secondParamIsNotStringArr(constructor);
                    this.passActionsToConstructor = isSecondParamStringArr ? (foundIx = PermissionCacheKey.findSecuredMethodParamIndex(securedMethod, constructor, 1, permissionKey.paramsRemainder, permissionKey.params, -1, paramConverterGenerator.index).methodParamIdx()) == -1 : false;
                    SecMethodAndPermCtorIdx[] matches = PermissionCacheKey.matchPermCtorParamIdxBasedOnNameMatch(securedMethod, constructor, this.passActionsToConstructor, permissionKey.params, permissionKey.paramsRemainder, paramConverterGenerator.index);
                    this.methodParamIndexes = PermissionSecurityChecksBuilder.getMethodParamIndexes(matches);
                    this.methodParamConverters = PermissionCacheKey.getMethodParamConverters(paramConverterGenerator, matches, securedMethod, this.methodParamIndexes);
                    if (permissionKey.notAutodetectParams()) {
                        PermissionCacheKey.validateParamsDeclaredByUserMatched(matches, permissionKey.params, permissionKey.paramsRemainder, securedMethod, constructor);
                    }
                } else {
                    this.methodParamIndexes = null;
                    this.methodParamConverters = null;
                    this.permissionKey = permissionKey;
                    this.computed = false;
                    this.passActionsToConstructor = constructor.parametersCount() == 2;
                }
            }

            private static void validateParamsDeclaredByUserMatched(SecMethodAndPermCtorIdx[] matches, String[] params, String[] nestedParamExpressions, MethodInfo securedMethod, MethodInfo constructor) {
                int i = 0;
                while (i < params.length) {
                    int aI = i++;
                    boolean paramMapped = Arrays.stream(matches).map(SecMethodAndPermCtorIdx::requiredParamIdx).filter(Objects::nonNull).anyMatch(mIdx -> mIdx == aI);
                    if (paramMapped) continue;
                    String paramName = nestedParamExpressions == null || nestedParamExpressions[aI] == null ? params[i] : params[i] + "." + nestedParamExpressions[aI];
                    throw new RuntimeException("Parameter '%s' specified via @PermissionsAllowed#params on secured method '%s#%s'\ncannot be matched to any constructor '%s' parameter. Please make sure that both\nsecured method and constructor has formal parameter with name '%1$s'.\n".formatted(paramName, securedMethod.declaringClass().name(), securedMethod.name(), constructor.declaringClass().name().toString()));
                }
                if (nestedParamExpressions != null) {
                    block1: for (i = 0; i < nestedParamExpressions.length; ++i) {
                        if (nestedParamExpressions[i] == null) continue;
                        String nestedParamExp = nestedParamExpressions[i];
                        for (SecMethodAndPermCtorIdx match : matches) {
                            if (nestedParamExp.equals(match.nestedParamExpression())) continue block1;
                        }
                        throw new IllegalArgumentException("@PermissionsAllowed annotation placed on method '%s#%s' has 'params' attribute\n'%s' that cannot be matched to any Permission '%s' constructor parameter\n".formatted(securedMethod.declaringClass().name(), securedMethod.name(), params[i] + "." + nestedParamExp, constructor.declaringClass().name()));
                    }
                }
            }

            private static String[] getMethodParamConverters(PermissionConverterGenerator paramConverterGenerator, SecMethodAndPermCtorIdx[] matches, MethodInfo securedMethod, int[] methodParamIndexes) {
                String[] converters = new String[methodParamIndexes.length];
                boolean requireConverter = false;
                for (SecMethodAndPermCtorIdx match : matches) {
                    if (match.nestedParamExpression() == null) continue;
                    requireConverter = true;
                    converters[match.constructorParamIdx()] = paramConverterGenerator.createConverter(match.nestedParamExpression(), securedMethod, match.methodParamIdx());
                }
                if (requireConverter) {
                    return converters;
                }
                return null;
            }

            private static SecMethodAndPermCtorIdx[] matchPermCtorParamIdxBasedOnNameMatch(MethodInfo securedMethod, MethodInfo constructor, boolean passActionsToConstructor, String[] requiredMethodParams, String[] requiredParamsRemainder, IndexView index) {
                int nonMethodParams = passActionsToConstructor ? 2 : 1;
                SecMethodAndPermCtorIdx[] matches = new SecMethodAndPermCtorIdx[constructor.parametersCount() - nonMethodParams];
                for (int i = nonMethodParams; i < constructor.parametersCount(); ++i) {
                    SecMethodAndPermCtorIdx match;
                    matches[i - nonMethodParams] = match = PermissionCacheKey.findSecuredMethodParamIndex(securedMethod, constructor, i, requiredParamsRemainder, requiredMethodParams, nonMethodParams, index);
                    if (match.methodParamIdx() != -1) continue;
                    String constructorParamName = constructor.parameterName(i);
                    throw new RuntimeException(String.format("No '%s' formal parameter name matches '%s' Permission constructor parameter name '%s'", securedMethod.name(), constructor.declaringClass().name().toString(), constructorParamName));
                }
                return matches;
            }

            private static SecMethodAndPermCtorIdx findSecuredMethodParamIndex(MethodInfo securedMethod, MethodInfo constructor, int constructorIx, String[] requiredParamsRemainder, String[] requiredParams, int nonMethodParams, IndexView index) {
                boolean constructorParamNameMatches;
                String methodParamName;
                int i;
                String constructorParamName = constructor.parameterName(constructorIx);
                int constructorParamIdx = constructorIx - nonMethodParams;
                if (requiredParams != null && requiredParams.length != 0) {
                    for (i = 0; i < securedMethod.parametersCount(); ++i) {
                        methodParamName = securedMethod.parameterName(i);
                        constructorParamNameMatches = constructorParamName.equals(methodParamName);
                        for (int i1 = 0; i1 < requiredParams.length; ++i1) {
                            int lastDotIdx;
                            String lastExpression;
                            String requiredParamRemainder;
                            boolean methodParamNameMatches = methodParamName.equals(requiredParams[i1]);
                            if (!methodParamNameMatches) continue;
                            if (constructorParamNameMatches) {
                                return new SecMethodAndPermCtorIdx(i, constructorParamIdx, null, i1);
                            }
                            if (requiredParamsRemainder == null || (requiredParamRemainder = requiredParamsRemainder[i1]) == null || !constructorParamName.equals(lastExpression = (lastDotIdx = requiredParamRemainder.lastIndexOf(46)) == -1 ? requiredParamRemainder : requiredParamRemainder.substring(lastDotIdx + 1))) continue;
                            return new SecMethodAndPermCtorIdx(i, constructorParamIdx, requiredParamRemainder, i1);
                        }
                    }
                }
                for (i = 0; i < securedMethod.parametersCount(); ++i) {
                    methodParamName = securedMethod.parameterName(i);
                    constructorParamNameMatches = constructorParamName.equals(methodParamName);
                    if (!constructorParamNameMatches) continue;
                    return new SecMethodAndPermCtorIdx(i, constructorParamIdx);
                }
                for (i = 0; i < securedMethod.parametersCount(); ++i) {
                    String nestedParamName;
                    ClassInfo clazz;
                    methodParamName = securedMethod.parameterName(i);
                    Type paramType = securedMethod.parameterType(i);
                    if (paramType.kind() != Type.Kind.CLASS || (clazz = index.getClassByName(paramType.name())) == null || (nestedParamName = PermissionSecurityChecksBuilder.matchNestedParamByName(clazz, constructorParamName)) == null) continue;
                    return new SecMethodAndPermCtorIdx(i, constructorParamIdx, nestedParamName, null);
                }
                return new SecMethodAndPermCtorIdx(-1, constructorParamIdx);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PermissionCacheKey that = (PermissionCacheKey)o;
                return this.computed == that.computed && this.passActionsToConstructor == that.passActionsToConstructor && Arrays.equals(this.methodParamIndexes, that.methodParamIndexes) && this.permissionKey.equals(that.permissionKey) && Arrays.equals(this.methodParamConverters, that.methodParamConverters);
            }

            public int hashCode() {
                int result = Objects.hash(this.permissionKey, this.computed, this.passActionsToConstructor);
                result = 31 * result + Arrays.hashCode(this.methodParamIndexes);
                if (this.methodParamConverters != null) {
                    result = 65 + result + Arrays.hashCode(this.methodParamConverters);
                }
                return result;
            }

            private int[] methodParamIndexes() {
                return Objects.requireNonNull(this.methodParamIndexes);
            }

            private boolean isStringPermission() {
                return PermissionCacheKey.isStringPermission(this.permissionKey);
            }

            private static boolean isComputed(PermissionKey permissionKey, MethodInfo constructor) {
                return permissionKey.notAutodetectParams() || constructor.parametersCount() > 2 || constructor.parametersCount() == 2 && PermissionCacheKey.secondParamIsNotStringArr(constructor);
            }

            private static boolean secondParamIsNotStringArr(MethodInfo constructor) {
                return constructor.parametersCount() < 2 || constructor.parameterType(1).kind() != Type.Kind.ARRAY || !constructor.parameterType(1).asArrayType().constituent().name().equals((Object)io.quarkus.arc.processor.DotNames.STRING);
            }

            private static boolean isStringPermission(PermissionKey permissionKey) {
                return STRING_PERMISSION.equals((Object)permissionKey.clazz.name());
            }
        }
    }
}

