/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.security.deployment.SecurityProcessor;
import io.quarkus.security.spi.runtime.MethodDescription;
import jakarta.annotation.security.RolesAllowed;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

final class AdditionalRolesAllowedTransformer
implements Predicate<MethodInfo>,
Consumer<AnnotationTransformation.TransformationContext> {
    private static final DotName ROLES_ALLOWED = DotName.createSimple((String)RolesAllowed.class.getName());
    private final Set<MethodDescription> methods;
    private final AnnotationValue[] rolesAllowed;

    AdditionalRolesAllowedTransformer(Collection<MethodDescription> methods, List<String> rolesAllowed) {
        this.methods = Set.copyOf(methods);
        this.rolesAllowed = (AnnotationValue[])rolesAllowed.stream().map(s -> AnnotationValue.createStringValue((String)"", (String)s)).toArray(AnnotationValue[]::new);
    }

    @Override
    public boolean test(MethodInfo methodInfo) {
        MethodDescription method = SecurityProcessor.createMethodDescription(methodInfo);
        return this.methods.contains(method);
    }

    @Override
    public void accept(AnnotationTransformation.TransformationContext ctx) {
        AnnotationInstance rolesAllowedInstance = AnnotationInstance.create((DotName)ROLES_ALLOWED, (AnnotationTarget)ctx.declaration().asMethod(), (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])this.rolesAllowed)});
        ctx.add(rolesAllowedInstance);
    }
}

