/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.jpa.common.deployment;

import io.quarkus.arc.processor.DotNames;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.request.TrustedAuthenticationRequest;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.security.jpa.PasswordType;
import io.quarkus.security.jpa.RolesValue;
import io.quarkus.security.jpa.common.deployment.JpaSecurityDefinition;
import io.quarkus.security.jpa.common.deployment.PanacheEntityPredicateBuildItem;
import io.quarkus.security.jpa.common.runtime.JpaIdentityProviderUtil;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Type;
import org.wildfly.security.password.Password;

public final class JpaSecurityIdentityUtil {
    private static final DotName DOTNAME_SET = DotName.createSimple((String)Set.class.getName());
    private static final DotName DOTNAME_COLLECTION = DotName.createSimple((String)Collection.class.getName());
    private static final DotName DOTNAME_ROLES_VALUE = DotName.createSimple((String)RolesValue.class.getName());

    private JpaSecurityIdentityUtil() {
    }

    public static void buildIdentity(Index index, JpaSecurityDefinition jpaSecurityDefinition, AnnotationValue passwordTypeValue, AnnotationValue passwordProviderValue, PanacheEntityPredicateBuildItem panacheEntityPredicate, FieldDescriptor passwordProviderField, MethodCreator outerMethod, ResultHandle userVar, BytecodeCreator innerMethod) {
        ResultHandle storedPassword;
        PasswordType passwordType = passwordTypeValue != null ? PasswordType.valueOf((String)passwordTypeValue.asEnum()) : PasswordType.MCF;
        try (BytecodeCreator trueBranch = innerMethod.ifNull(userVar).trueBranch();){
            ResultHandle exceptionInstance = trueBranch.newInstance(MethodDescriptor.ofConstructor(AuthenticationFailedException.class, (Class[])new Class[0]), new ResultHandle[0]);
            trueBranch.invokeStaticMethod(JpaSecurityIdentityUtil.passwordActionMethod(), new ResultHandle[]{trueBranch.load((Enum)passwordType)});
            trueBranch.throwException(exceptionInstance);
        }
        ResultHandle pass = jpaSecurityDefinition.password.readValue(innerMethod, userVar);
        if (passwordType == PasswordType.CUSTOM && passwordProviderValue == null) {
            throw new RuntimeException("Missing password provider for password type: " + passwordType);
        }
        switch (passwordType) {
            case CUSTOM: {
                String passwordProviderClassStr = passwordProviderValue.asString();
                String passwordProviderMethod = "getPassword";
                ResultHandle passwordProviderInstanceField = innerMethod.readInstanceField(passwordProviderField, outerMethod.getThis());
                BytecodeCreator trueBranch = innerMethod.ifNull(passwordProviderInstanceField).trueBranch();
                ResultHandle passwordProviderInstance = trueBranch.newInstance(MethodDescriptor.ofConstructor((String)passwordProviderClassStr, (String[])new String[0]), new ResultHandle[0]);
                trueBranch.writeInstanceField(passwordProviderField, outerMethod.getThis(), passwordProviderInstance);
                trueBranch.close();
                ResultHandle objectToInvokeOn = innerMethod.readInstanceField(passwordProviderField, outerMethod.getThis());
                storedPassword = innerMethod.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)passwordProviderClassStr, (String)passwordProviderMethod, Password.class, (Object[])new Object[]{String.class}), objectToInvokeOn, new ResultHandle[]{pass});
                break;
            }
            case CLEAR: {
                storedPassword = innerMethod.invokeStaticMethod(JpaSecurityIdentityUtil.getUtilMethod("getClearPassword"), new ResultHandle[]{pass});
                break;
            }
            case MCF: {
                storedPassword = innerMethod.invokeStaticMethod(JpaSecurityIdentityUtil.getUtilMethod("getMcfPassword"), new ResultHandle[]{pass});
                break;
            }
            default: {
                throw new RuntimeException("Unknown password type: " + passwordType);
            }
        }
        ResultHandle builder = innerMethod.invokeStaticMethod(MethodDescriptor.ofMethod(JpaIdentityProviderUtil.class, (String)"checkPassword", QuarkusSecurityIdentity.Builder.class, (Class[])new Class[]{Password.class, UsernamePasswordAuthenticationRequest.class}), new ResultHandle[]{storedPassword, outerMethod.getMethodParam(1)});
        AssignableResultHandle builderVar = innerMethod.createVariable(QuarkusSecurityIdentity.Builder.class);
        innerMethod.assign(builderVar, builder);
        JpaSecurityIdentityUtil.setupRoles(index, jpaSecurityDefinition, panacheEntityPredicate, userVar, builderVar, innerMethod);
    }

    public static void buildTrustedIdentity(Index index, JpaSecurityDefinition jpaSecurityDefinition, PanacheEntityPredicateBuildItem panacheEntityPredicate, MethodCreator outerMethod, ResultHandle userVar, BytecodeCreator innerMethod) {
        try (BytecodeCreator trueBranch = innerMethod.ifNull(userVar).trueBranch();){
            trueBranch.returnValue(trueBranch.loadNull());
        }
        ResultHandle builder = innerMethod.invokeStaticMethod(MethodDescriptor.ofMethod(JpaIdentityProviderUtil.class, (String)"trusted", QuarkusSecurityIdentity.Builder.class, (Class[])new Class[]{TrustedAuthenticationRequest.class}), new ResultHandle[]{outerMethod.getMethodParam(1)});
        AssignableResultHandle builderVar = innerMethod.createVariable(QuarkusSecurityIdentity.Builder.class);
        innerMethod.assign(builderVar, builder);
        JpaSecurityIdentityUtil.setupRoles(index, jpaSecurityDefinition, panacheEntityPredicate, userVar, builderVar, innerMethod);
    }

    static AnnotationTarget getSingleAnnotatedElement(Index index, DotName annotation) {
        List annotations = index.getAnnotations(annotation);
        if (annotations.isEmpty()) {
            return null;
        }
        if (annotations.size() > 1) {
            throw new RuntimeException("You can only annotate one field or method with @" + annotation);
        }
        return ((AnnotationInstance)annotations.get(0)).target();
    }

    private static void setupRoles(Index index, JpaSecurityDefinition jpaSecurityDefinition, PanacheEntityPredicateBuildItem panacheEntityPredicate, ResultHandle userVar, AssignableResultHandle builderVar, BytecodeCreator innerMethod) {
        ResultHandle role = jpaSecurityDefinition.roles.readValue(innerMethod, userVar);
        boolean handledRole = false;
        Type rolesType = jpaSecurityDefinition.roles.type();
        switch (rolesType.kind()) {
            case ARRAY: {
                break;
            }
            case CLASS: {
                if (!rolesType.name().equals((Object)DotNames.STRING)) break;
                innerMethod.invokeStaticMethod(MethodDescriptor.ofMethod(JpaIdentityProviderUtil.class, (String)"addRoles", Void.TYPE, (Class[])new Class[]{QuarkusSecurityIdentity.Builder.class, String.class}), new ResultHandle[]{builderVar, role});
                handledRole = true;
                break;
            }
            case PARAMETERIZED_TYPE: {
                JpaSecurityDefinition.FieldOrMethod rolesFieldOrMethod;
                DotName roleType = rolesType.name();
                if (!roleType.equals((Object)DotNames.LIST) && !roleType.equals((Object)DOTNAME_COLLECTION) && !roleType.equals((Object)DOTNAME_SET)) break;
                Type elementType = (Type)rolesType.asParameterizedType().arguments().get(0);
                String elementClassName = elementType.name().toString();
                String elementClassTypeDescriptor = "L" + elementClassName.replace('.', '/') + ";";
                if (!elementType.name().equals((Object)DotNames.STRING)) {
                    ClassInfo roleClass = index.getClassByName(elementType.name());
                    if (roleClass == null) {
                        throw new RuntimeException("The role element type must be indexed by Jandex: " + elementType);
                    }
                    AnnotationTarget annotatedRolesValue = JpaSecurityIdentityUtil.getSingleAnnotatedElement(index, DOTNAME_ROLES_VALUE);
                    rolesFieldOrMethod = JpaSecurityDefinition.getFieldOrMethod(index, roleClass, annotatedRolesValue, panacheEntityPredicate.isPanache(roleClass));
                    if (rolesFieldOrMethod == null) {
                        throw new RuntimeException("Missing @RoleValue annotation on (non-String) role element type: " + elementType);
                    }
                } else {
                    rolesFieldOrMethod = null;
                }
                JpaSecurityIdentityUtil.foreach(innerMethod, role, elementClassTypeDescriptor, (creator, var) -> {
                    Object roleElement = rolesFieldOrMethod != null ? rolesFieldOrMethod.readValue((BytecodeCreator)creator, (ResultHandle)var) : var;
                    creator.invokeStaticMethod(MethodDescriptor.ofMethod(JpaIdentityProviderUtil.class, (String)"addRoles", Void.TYPE, (Class[])new Class[]{QuarkusSecurityIdentity.Builder.class, String.class}), new ResultHandle[]{builderVar, roleElement});
                });
                handledRole = true;
            }
        }
        if (!handledRole) {
            throw new RuntimeException("Unsupported @Roles field/getter type: " + rolesType);
        }
        innerMethod.returnValue(innerMethod.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusSecurityIdentity.Builder.class, (String)"build", QuarkusSecurityIdentity.class, (Class[])new Class[0]), (ResultHandle)builderVar, new ResultHandle[0]));
    }

    private static void foreach(BytecodeCreator bytecodeCreator, ResultHandle iterable, String type, BiConsumer<BytecodeCreator, AssignableResultHandle> body) {
        ResultHandle iterator = bytecodeCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), iterable, new ResultHandle[0]);
        try (BytecodeCreator loop = bytecodeCreator.createScope();){
            ResultHandle hasNextValue = loop.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), iterator, new ResultHandle[0]);
            BranchResult hasNextBranch = loop.ifNonZero(hasNextValue);
            try (BytecodeCreator hasNext = hasNextBranch.trueBranch();){
                ResultHandle next = hasNext.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), iterator, new ResultHandle[0]);
                AssignableResultHandle var = hasNext.createVariable(type);
                hasNext.assign(var, next);
                body.accept(hasNext, var);
                hasNext.continueScope(loop);
            }
            try (BytecodeCreator doesNotHaveNext = hasNextBranch.falseBranch();){
                doesNotHaveNext.breakScope(loop);
            }
        }
    }

    private static MethodDescriptor getUtilMethod(String passwordProviderMethod) {
        return MethodDescriptor.ofMethod(JpaIdentityProviderUtil.class, (String)passwordProviderMethod, Password.class, (Class[])new Class[]{String.class});
    }

    private static MethodDescriptor passwordActionMethod() {
        return MethodDescriptor.ofMethod(JpaIdentityProviderUtil.class, (String)"passwordAction", Void.TYPE, (Class[])new Class[]{PasswordType.class});
    }
}

