/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.jpa.common.runtime;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.request.TrustedAuthenticationRequest;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusPrincipal;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import java.security.Principal;
import java.security.spec.InvalidKeySpecException;
import java.util.List;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.util.ModularCrypt;
import org.wildfly.security.provider.util.ProviderUtil;

public class JpaIdentityProviderUtil {
    private JpaIdentityProviderUtil() {
    }

    public static QuarkusSecurityIdentity.Builder checkPassword(Password storedPassword, UsernamePasswordAuthenticationRequest request) {
        PasswordCredential storedPasswordCredential = new PasswordCredential(storedPassword);
        PasswordGuessEvidence sentPasswordEvidence = new PasswordGuessEvidence(request.getPassword().getPassword());
        if (!storedPasswordCredential.verify(ProviderUtil.INSTALLED_PROVIDERS, (Evidence)sentPasswordEvidence)) {
            throw new AuthenticationFailedException();
        }
        QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
        builder.setPrincipal((Principal)new QuarkusPrincipal(request.getUsername()));
        builder.addCredential((Credential)request.getPassword());
        return builder;
    }

    public static QuarkusSecurityIdentity.Builder trusted(TrustedAuthenticationRequest request) {
        QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
        builder.setPrincipal((Principal)new QuarkusPrincipal(request.getPrincipal()));
        return builder;
    }

    public static void addRoles(QuarkusSecurityIdentity.Builder builder, String roles) {
        if (roles.indexOf(44) != -1) {
            for (String role : roles.split(",")) {
                builder.addRole(role.trim());
            }
        } else {
            builder.addRole(roles.trim());
        }
    }

    public static <T> T getSingleUser(List<T> results) {
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new AuthenticationFailedException();
        }
        return results.get(0);
    }

    public static Password getClearPassword(String pass) {
        return ClearPassword.createRaw((String)"clear", (char[])pass.toCharArray());
    }

    public static Password getMcfPassword(String pass) {
        try {
            return ModularCrypt.decode((String)pass);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }
}

