/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.jpa.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.panache.common.deployment.PanacheEntityClassesBuildItem;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TrustedAuthenticationRequest;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.security.jpa.Password;
import io.quarkus.security.jpa.PasswordProvider;
import io.quarkus.security.jpa.PasswordType;
import io.quarkus.security.jpa.Roles;
import io.quarkus.security.jpa.RolesValue;
import io.quarkus.security.jpa.UserDefinition;
import io.quarkus.security.jpa.Username;
import io.quarkus.security.jpa.deployment.JpaSecurityDefinition;
import io.quarkus.security.jpa.runtime.JpaIdentityProvider;
import io.quarkus.security.jpa.runtime.JpaTrustedIdentityProvider;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.hibernate.Session;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.annotations.NaturalId;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Type;

class QuarkusSecurityJpaProcessor {
    static final DotName DOTNAME_OBJECT = DotName.createSimple((String)Object.class.getName());
    private static final DotName DOTNAME_STRING = DotName.createSimple((String)String.class.getName());
    private static final DotName DOTNAME_LIST = DotName.createSimple((String)List.class.getName());
    private static final DotName DOTNAME_SET = DotName.createSimple((String)Set.class.getName());
    private static final DotName DOTNAME_COLLECTION = DotName.createSimple((String)Collection.class.getName());
    private static final DotName DOTNAME_NATURAL_ID = DotName.createSimple((String)NaturalId.class.getName());
    private static final DotName DOTNAME_USER_DEFINITION = DotName.createSimple((String)UserDefinition.class.getName());
    private static final DotName DOTNAME_USERNAME = DotName.createSimple((String)Username.class.getName());
    private static final DotName DOTNAME_PASSWORD = DotName.createSimple((String)Password.class.getName());
    private static final DotName DOTNAME_ROLES = DotName.createSimple((String)Roles.class.getName());
    private static final DotName DOTNAME_ROLES_VALUE = DotName.createSimple((String)RolesValue.class.getName());

    QuarkusSecurityJpaProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SECURITY_JPA);
    }

    @BuildStep
    void configureJpaAuthConfig(ApplicationIndexBuildItem index, BuildProducer<UnremovableBeanBuildItem> unremovable, BuildProducer<GeneratedBeanBuildItem> beanProducer, List<PanacheEntityClassesBuildItem> panacheEntityClasses) throws Exception {
        List userDefinitions = index.getIndex().getAnnotations(DOTNAME_USER_DEFINITION);
        if (userDefinitions.size() > 1) {
            throw new RuntimeException("You can only annotate one class with @UserDefinition");
        }
        if (!userDefinitions.isEmpty()) {
            ClassInfo userDefinitionClass = ((AnnotationInstance)userDefinitions.get(0)).target().asClass();
            AnnotationTarget annotatedUsername = this.getSingleAnnotatedElement(index.getIndex(), DOTNAME_USERNAME);
            AnnotationTarget annotatedPassword = this.getSingleAnnotatedElement(index.getIndex(), DOTNAME_PASSWORD);
            AnnotationTarget annotatedRoles = this.getSingleAnnotatedElement(index.getIndex(), DOTNAME_ROLES);
            Set<String> panacheEntities = this.collectPanacheEntities(panacheEntityClasses);
            JpaSecurityDefinition jpaSecurityDefinition = new JpaSecurityDefinition(index.getIndex(), userDefinitionClass, this.isPanache(userDefinitionClass, panacheEntities), annotatedUsername, annotatedPassword, annotatedRoles);
            AnnotationInstance passAnnotation = jpaSecurityDefinition.password.annotation(DOTNAME_PASSWORD);
            AnnotationValue passwordType = passAnnotation.value();
            AnnotationValue customPasswordProvider = passAnnotation.value("provider");
            this.generateIdentityProvider(index.getIndex(), jpaSecurityDefinition, passwordType, customPasswordProvider, beanProducer, panacheEntities);
            this.generateTrustedIdentityProvider(index.getIndex(), jpaSecurityDefinition, beanProducer, panacheEntities);
        }
    }

    private boolean isPanache(ClassInfo annotatedClass, Set<String> panacheEntities) {
        return panacheEntities.contains(annotatedClass.name().toString());
    }

    private Set<String> collectPanacheEntities(List<PanacheEntityClassesBuildItem> panacheEntityClassesBuildItems) {
        HashSet<String> modelClasses = new HashSet<String>();
        for (PanacheEntityClassesBuildItem panacheEntityClasses : panacheEntityClassesBuildItems) {
            modelClasses.addAll(panacheEntityClasses.getEntityClasses());
        }
        return modelClasses;
    }

    private AnnotationTarget getSingleAnnotatedElement(Index index, DotName annotation) {
        List annotations = index.getAnnotations(annotation);
        if (annotations.isEmpty()) {
            return null;
        }
        if (annotations.size() > 1) {
            throw new RuntimeException("You can only annotate one field or method with @" + annotation);
        }
        return ((AnnotationInstance)annotations.get(0)).target();
    }

    private void generateIdentityProvider(Index index, JpaSecurityDefinition jpaSecurityDefinition, AnnotationValue passwordTypeValue, AnnotationValue passwordProviderValue, BuildProducer<GeneratedBeanBuildItem> beanProducer, Set<String> panacheClasses) {
        GeneratedBeanGizmoAdaptor gizmoAdaptor = new GeneratedBeanGizmoAdaptor(beanProducer);
        String name = jpaSecurityDefinition.annotatedClass.name() + "__JpaIdentityProviderImpl";
        try (ClassCreator classCreator = ClassCreator.builder().className(name).superClass(JpaIdentityProvider.class).classOutput((ClassOutput)gizmoAdaptor).build();){
            classCreator.addAnnotation(Singleton.class);
            FieldDescriptor passwordProviderField = ((FieldCreator)classCreator.getFieldCreator("passwordProvider", PasswordProvider.class).setModifiers(2)).getFieldDescriptor();
            try (MethodCreator methodCreator = classCreator.getMethodCreator("authenticate", SecurityIdentity.class, new Class[]{EntityManager.class, UsernamePasswordAuthenticationRequest.class});){
                ResultHandle objectToInvokeOn;
                String passwordProviderMethod;
                Object passwordProviderClassStr;
                PasswordType passwordType;
                methodCreator.setModifiers(1);
                ResultHandle username = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(UsernamePasswordAuthenticationRequest.class, (String)"getUsername", String.class, (Class[])new Class[0]), methodCreator.getMethodParam(1), new ResultHandle[0]);
                AnnotationInstance naturalIdAnnotation = jpaSecurityDefinition.username.annotation(DOTNAME_NATURAL_ID);
                ResultHandle user = this.lookupUserById(jpaSecurityDefinition, name, methodCreator, username, naturalIdAnnotation);
                String declaringClassName = jpaSecurityDefinition.annotatedClass.name().toString();
                String declaringClassTypeDescriptor = "L" + declaringClassName.replace('.', '/') + ";";
                AssignableResultHandle userVar = methodCreator.createVariable(declaringClassTypeDescriptor);
                methodCreator.assign(userVar, methodCreator.checkCast(user, declaringClassName));
                try (BytecodeCreator trueBranch = methodCreator.ifNull((ResultHandle)userVar).trueBranch();){
                    ResultHandle exceptionInstance = trueBranch.newInstance(MethodDescriptor.ofConstructor(AuthenticationFailedException.class, (Class[])new Class[0]), new ResultHandle[0]);
                    trueBranch.throwException(exceptionInstance);
                }
                ResultHandle pass = jpaSecurityDefinition.password.readValue((BytecodeCreator)methodCreator, userVar);
                PasswordType passwordType2 = passwordType = passwordTypeValue != null ? PasswordType.valueOf((String)passwordTypeValue.asEnum()) : PasswordType.MCF;
                if (passwordType == PasswordType.CUSTOM && passwordProviderValue == null) {
                    throw new RuntimeException("Missing password provider for password type: " + passwordType);
                }
                switch (passwordType) {
                    case CUSTOM: {
                        passwordProviderClassStr = passwordProviderValue.asString();
                        passwordProviderMethod = "getPassword";
                        ResultHandle passwordProviderInstanceField = methodCreator.readInstanceField(passwordProviderField, methodCreator.getThis());
                        BytecodeCreator trueBranch = methodCreator.ifNull(passwordProviderInstanceField).trueBranch();
                        ResultHandle passwordProviderInstance = trueBranch.newInstance(MethodDescriptor.ofConstructor((String)passwordProviderClassStr, (String[])new String[0]), new ResultHandle[0]);
                        trueBranch.writeInstanceField(passwordProviderField, trueBranch.getThis(), passwordProviderInstance);
                        trueBranch.close();
                        objectToInvokeOn = methodCreator.readInstanceField(passwordProviderField, methodCreator.getThis());
                        break;
                    }
                    case CLEAR: {
                        passwordProviderClassStr = name;
                        passwordProviderMethod = "getClearPassword";
                        objectToInvokeOn = methodCreator.getThis();
                        break;
                    }
                    case MCF: {
                        passwordProviderClassStr = name;
                        passwordProviderMethod = "getMcfPassword";
                        objectToInvokeOn = methodCreator.getThis();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown password type: " + passwordType);
                    }
                }
                ResultHandle storedPassword = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)passwordProviderClassStr, (String)passwordProviderMethod, org.wildfly.security.password.Password.class, (Object[])new Object[]{String.class}), objectToInvokeOn, new ResultHandle[]{pass});
                ResultHandle builder = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)name, (String)"checkPassword", QuarkusSecurityIdentity.Builder.class, (Object[])new Object[]{org.wildfly.security.password.Password.class, UsernamePasswordAuthenticationRequest.class}), methodCreator.getThis(), new ResultHandle[]{storedPassword, methodCreator.getMethodParam(1)});
                AssignableResultHandle builderVar = methodCreator.createVariable(QuarkusSecurityIdentity.Builder.class);
                methodCreator.assign(builderVar, builder);
                this.setupRoles(index, jpaSecurityDefinition, panacheClasses, name, methodCreator, userVar, builderVar);
            }
        }
    }

    private void generateTrustedIdentityProvider(Index index, JpaSecurityDefinition jpaSecurityDefinition, BuildProducer<GeneratedBeanBuildItem> beanProducer, Set<String> panacheClasses) {
        GeneratedBeanGizmoAdaptor gizmoAdaptor = new GeneratedBeanGizmoAdaptor(beanProducer);
        String name = jpaSecurityDefinition.annotatedClass.name() + "__JpaTrustedIdentityProviderImpl";
        try (ClassCreator classCreator = ClassCreator.builder().className(name).superClass(JpaTrustedIdentityProvider.class).classOutput((ClassOutput)gizmoAdaptor).build();){
            classCreator.addAnnotation(Singleton.class);
            try (MethodCreator methodCreator = classCreator.getMethodCreator("authenticate", SecurityIdentity.class, new Class[]{EntityManager.class, TrustedAuthenticationRequest.class});){
                methodCreator.setModifiers(1);
                ResultHandle username = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(TrustedAuthenticationRequest.class, (String)"getPrincipal", String.class, (Class[])new Class[0]), methodCreator.getMethodParam(1), new ResultHandle[0]);
                AnnotationInstance naturalIdAnnotation = jpaSecurityDefinition.username.annotation(DOTNAME_NATURAL_ID);
                ResultHandle user = this.lookupUserById(jpaSecurityDefinition, name, methodCreator, username, naturalIdAnnotation);
                String declaringClassName = jpaSecurityDefinition.annotatedClass.name().toString();
                String declaringClassTypeDescriptor = "L" + declaringClassName.replace('.', '/') + ";";
                AssignableResultHandle userVar = methodCreator.createVariable(declaringClassTypeDescriptor);
                methodCreator.assign(userVar, methodCreator.checkCast(user, declaringClassName));
                try (BytecodeCreator trueBranch = methodCreator.ifNull((ResultHandle)userVar).trueBranch();){
                    trueBranch.returnValue(trueBranch.loadNull());
                }
                ResultHandle builder = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)name, (String)"trusted", QuarkusSecurityIdentity.Builder.class, (Object[])new Object[]{TrustedAuthenticationRequest.class}), methodCreator.getThis(), new ResultHandle[]{methodCreator.getMethodParam(1)});
                AssignableResultHandle builderVar = methodCreator.createVariable(QuarkusSecurityIdentity.Builder.class);
                methodCreator.assign(builderVar, builder);
                this.setupRoles(index, jpaSecurityDefinition, panacheClasses, name, methodCreator, userVar, builderVar);
            }
        }
    }

    private void setupRoles(Index index, JpaSecurityDefinition jpaSecurityDefinition, Set<String> panacheClasses, String name, MethodCreator methodCreator, AssignableResultHandle userVar, AssignableResultHandle builderVar) {
        ResultHandle role = jpaSecurityDefinition.roles.readValue((BytecodeCreator)methodCreator, userVar);
        boolean handledRole = false;
        Type rolesType = jpaSecurityDefinition.roles.type();
        switch (rolesType.kind()) {
            case ARRAY: {
                break;
            }
            case CLASS: {
                if (!rolesType.name().equals((Object)DOTNAME_STRING)) break;
                methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)name, (String)"addRoles", Void.TYPE, (Object[])new Object[]{QuarkusSecurityIdentity.Builder.class, String.class}), methodCreator.getThis(), new ResultHandle[]{builderVar, role});
                handledRole = true;
                break;
            }
            case PARAMETERIZED_TYPE: {
                JpaSecurityDefinition.FieldOrMethod rolesFieldOrMethod;
                DotName roleType = rolesType.name();
                if (!roleType.equals((Object)DOTNAME_LIST) && !roleType.equals((Object)DOTNAME_COLLECTION) && !roleType.equals((Object)DOTNAME_SET)) break;
                Type elementType = (Type)rolesType.asParameterizedType().arguments().get(0);
                String elementClassName = elementType.name().toString();
                String elementClassTypeDescriptor = "L" + elementClassName.replace('.', '/') + ";";
                if (!elementType.name().equals((Object)DOTNAME_STRING)) {
                    ClassInfo roleClass = index.getClassByName(elementType.name());
                    if (roleClass == null) {
                        throw new RuntimeException("The role element type must be indexed by Jandex: " + elementType);
                    }
                    AnnotationTarget annotatedRolesValue = this.getSingleAnnotatedElement(index, DOTNAME_ROLES_VALUE);
                    rolesFieldOrMethod = JpaSecurityDefinition.getFieldOrMethod(index, roleClass, annotatedRolesValue, this.isPanache(roleClass, panacheClasses));
                    if (rolesFieldOrMethod == null) {
                        throw new RuntimeException("Missing @RoleValue annotation on (non-String) role element type: " + elementType);
                    }
                } else {
                    rolesFieldOrMethod = null;
                }
                this.foreach(methodCreator, role, elementClassTypeDescriptor, (creator, var) -> {
                    Object roleElement = rolesFieldOrMethod != null ? rolesFieldOrMethod.readValue((BytecodeCreator)creator, (AssignableResultHandle)var) : var;
                    creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)name, (String)"addRoles", Void.TYPE, (Object[])new Object[]{QuarkusSecurityIdentity.Builder.class, String.class}), methodCreator.getThis(), new ResultHandle[]{builderVar, roleElement});
                });
                handledRole = true;
            }
        }
        if (!handledRole) {
            throw new RuntimeException("Unsupported @Roles field/getter type: " + rolesType);
        }
        methodCreator.returnValue(methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(QuarkusSecurityIdentity.Builder.class, (String)"build", QuarkusSecurityIdentity.class, (Class[])new Class[0]), (ResultHandle)builderVar, new ResultHandle[0]));
    }

    private ResultHandle lookupUserById(JpaSecurityDefinition jpaSecurityDefinition, String name, MethodCreator methodCreator, ResultHandle username, AnnotationInstance naturalIdAnnotation) {
        ResultHandle user;
        if (naturalIdAnnotation != null) {
            ResultHandle session = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(EntityManager.class, (String)"unwrap", Object.class, (Class[])new Class[]{Class.class}), methodCreator.getMethodParam(0), new ResultHandle[]{methodCreator.loadClassFromTCCL(Session.class)});
            ResultHandle naturalIdLoadAccess = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Session.class, (String)"bySimpleNaturalId", SimpleNaturalIdLoadAccess.class, (Class[])new Class[]{Class.class}), methodCreator.checkCast(session, Session.class), new ResultHandle[]{methodCreator.loadClassFromTCCL(jpaSecurityDefinition.annotatedClass.name().toString())});
            user = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(SimpleNaturalIdLoadAccess.class, (String)"load", Object.class, (Class[])new Class[]{Object.class}), naturalIdLoadAccess, new ResultHandle[]{username});
        } else {
            String hql = "FROM " + jpaSecurityDefinition.annotatedClass.simpleName() + " WHERE " + jpaSecurityDefinition.username.name() + " = :name";
            ResultHandle query = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(EntityManager.class, (String)"createQuery", Query.class, (Class[])new Class[]{String.class}), methodCreator.getMethodParam(0), new ResultHandle[]{methodCreator.load(hql)});
            ResultHandle query2 = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Query.class, (String)"setParameter", Query.class, (Class[])new Class[]{String.class, Object.class}), query, new ResultHandle[]{methodCreator.load("name"), username});
            user = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)name, (String)"getSingleUser", Object.class, (Object[])new Object[]{Query.class}), methodCreator.getThis(), new ResultHandle[]{query2});
        }
        return user;
    }

    private void foreach(MethodCreator method, ResultHandle iterable, String type, BiConsumer<BytecodeCreator, AssignableResultHandle> body) {
        ResultHandle iterator = method.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterable.class, (String)"iterator", Iterator.class, (Class[])new Class[0]), iterable, new ResultHandle[0]);
        try (BytecodeCreator loop = method.createScope();){
            ResultHandle hasNextValue = loop.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"hasNext", Boolean.TYPE, (Class[])new Class[0]), iterator, new ResultHandle[0]);
            BranchResult hasNextBranch = loop.ifNonZero(hasNextValue);
            try (BytecodeCreator hasNext = hasNextBranch.trueBranch();){
                ResultHandle next = hasNext.invokeInterfaceMethod(MethodDescriptor.ofMethod(Iterator.class, (String)"next", Object.class, (Class[])new Class[0]), iterator, new ResultHandle[0]);
                AssignableResultHandle var = hasNext.createVariable(type);
                hasNext.assign(var, next);
                body.accept(hasNext, var);
                hasNext.continueScope(loop);
            }
            try (BytecodeCreator doesNotHaveNext = hasNextBranch.falseBranch();){
                doesNotHaveNext.breakScope(loop);
            }
        }
    }
}

