/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.jpa.reactive.runtime;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Inject;
import jakarta.persistence.NonUniqueResultException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.hibernate.FlushMode;
import org.hibernate.reactive.mutiny.Mutiny;
import org.jboss.logging.Logger;

public abstract class JpaReactiveIdentityProvider
implements IdentityProvider<UsernamePasswordAuthenticationRequest> {
    private static final Logger LOG = Logger.getLogger(JpaReactiveIdentityProvider.class);
    @Inject
    Mutiny.SessionFactory sessionFactory;

    public Class<UsernamePasswordAuthenticationRequest> getRequestType() {
        return UsernamePasswordAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(final UsernamePasswordAuthenticationRequest request, AuthenticationRequestContext context) {
        return this.sessionFactory.withSession((Function)new Function<Mutiny.Session, Uni<SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(Mutiny.Session session) {
                session.setFlushMode(FlushMode.MANUAL);
                session.setDefaultReadOnly(true);
                return JpaReactiveIdentityProvider.this.authenticate(session, request).onFailure((Predicate)new Predicate<Throwable>(){

                    @Override
                    public boolean test(Throwable throwable) {
                        return throwable instanceof SecurityException || throwable instanceof NonUniqueResultException;
                    }
                }).transform((Function)new Function<Throwable, Throwable>(){

                    @Override
                    public Throwable apply(Throwable throwable) {
                        LOG.debug((Object)"Authentication failed", throwable);
                        return new AuthenticationFailedException(throwable);
                    }
                });
            }
        });
    }

    public abstract Uni<SecurityIdentity> authenticate(Mutiny.Session var1, UsernamePasswordAuthenticationRequest var2);
}

