/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.jpa.runtime;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.security.jpa.runtime.AbstractJpaIdentityProvider;
import io.smallrye.mutiny.Uni;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.jboss.logging.Logger;

public abstract class JpaIdentityProvider
extends AbstractJpaIdentityProvider
implements IdentityProvider<UsernamePasswordAuthenticationRequest> {
    private static Logger log = Logger.getLogger(JpaIdentityProvider.class);
    @Inject
    EntityManagerFactory entityManagerFactory;

    public Class<UsernamePasswordAuthenticationRequest> getRequestType() {
        return UsernamePasswordAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(final UsernamePasswordAuthenticationRequest request, AuthenticationRequestContext context) {
        return context.runBlocking((Supplier)new Supplier<SecurityIdentity>(){

            @Override
            public SecurityIdentity get() {
                EntityManager em = JpaIdentityProvider.this.entityManagerFactory.createEntityManager();
                ((Session)em).setHibernateFlushMode(FlushMode.MANUAL);
                ((Session)em).setDefaultReadOnly(true);
                try {
                    SecurityIdentity securityIdentity = JpaIdentityProvider.this.authenticate(em, request);
                    return securityIdentity;
                }
                catch (SecurityException e) {
                    log.debug((Object)"Authentication failed", (Throwable)e);
                    throw new AuthenticationFailedException();
                }
                finally {
                    em.close();
                }
            }
        });
    }

    public abstract SecurityIdentity authenticate(EntityManager var1, UsernamePasswordAuthenticationRequest var2);
}

