/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.jpa.runtime;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.TrustedAuthenticationRequest;
import io.quarkus.security.jpa.runtime.AbstractJpaIdentityProvider;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.function.Supplier;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.jboss.logging.Logger;

public abstract class JpaTrustedIdentityProvider
extends AbstractJpaIdentityProvider
implements IdentityProvider<TrustedAuthenticationRequest> {
    private static Logger log = Logger.getLogger(JpaTrustedIdentityProvider.class);
    @Inject
    EntityManagerFactory entityManagerFactory;

    public Class<TrustedAuthenticationRequest> getRequestType() {
        return TrustedAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(final TrustedAuthenticationRequest request, AuthenticationRequestContext context) {
        return context.runBlocking((Supplier)new Supplier<SecurityIdentity>(){

            @Override
            public SecurityIdentity get() {
                EntityManager em = JpaTrustedIdentityProvider.this.entityManagerFactory.createEntityManager();
                ((Session)em).setHibernateFlushMode(FlushMode.MANUAL);
                ((Session)em).setDefaultReadOnly(true);
                try {
                    SecurityIdentity securityIdentity = JpaTrustedIdentityProvider.this.authenticate(em, request);
                    return securityIdentity;
                }
                catch (SecurityException e) {
                    log.debug((Object)"Authentication failed", (Throwable)e);
                    throw new AuthenticationFailedException();
                }
                finally {
                    em.close();
                }
            }
        });
    }

    public abstract SecurityIdentity authenticate(EntityManager var1, TrustedAuthenticationRequest var2);
}

