/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.webauthn.WebAuthnAuthenticationMechanism;
import io.quarkus.security.webauthn.WebAuthnController;
import io.quarkus.security.webauthn.WebAuthnRunTimeConfig;
import io.quarkus.security.webauthn.WebAuthnSecurity;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.security.PersistentLoginManager;
import io.vertx.core.Handler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import java.lang.annotation.Annotation;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class WebAuthnRecorder {
    private static final Logger log = Logger.getLogger(WebAuthnRecorder.class);
    final RuntimeValue<HttpConfiguration> httpConfiguration;
    final RuntimeValue<WebAuthnRunTimeConfig> config;
    static volatile String encryptionKey;

    public WebAuthnRecorder(RuntimeValue<HttpConfiguration> httpConfiguration, RuntimeValue<WebAuthnRunTimeConfig> config) {
        this.httpConfiguration = httpConfiguration;
        this.config = config;
    }

    public void setupRoutes(BeanContainer beanContainer, RuntimeValue<Router> routerValue, String prefix) {
        WebAuthnSecurity security = (WebAuthnSecurity)beanContainer.instance(WebAuthnSecurity.class, new Annotation[0]);
        WebAuthnAuthenticationMechanism authMech = (WebAuthnAuthenticationMechanism)beanContainer.instance(WebAuthnAuthenticationMechanism.class, new Annotation[0]);
        IdentityProviderManager identityProviderManager = (IdentityProviderManager)beanContainer.instance(IdentityProviderManager.class, new Annotation[0]);
        WebAuthnController controller = new WebAuthnController(security, (WebAuthnRunTimeConfig)this.config.getValue(), identityProviderManager, authMech);
        Router router = (Router)routerValue.getValue();
        BodyHandler bodyHandler = BodyHandler.create();
        router.post(prefix + "webauthn/login").handler((Handler)bodyHandler).handler(controller::login);
        router.post(prefix + "webauthn/register").handler((Handler)bodyHandler).handler(controller::register);
        router.post(prefix + "webauthn/callback").handler((Handler)bodyHandler).handler(controller::callback);
        router.get(prefix + "webauthn/webauthn.js").handler(controller::javascript);
        router.get(prefix + "webauthn/logout").handler(controller::logout);
    }

    public Supplier<WebAuthnAuthenticationMechanism> setupWebAuthnAuthenticationMechanism() {
        return new Supplier<WebAuthnAuthenticationMechanism>(){

            @Override
            public WebAuthnAuthenticationMechanism get() {
                String key;
                if (!((HttpConfiguration)WebAuthnRecorder.this.httpConfiguration.getValue()).encryptionKey.isPresent()) {
                    if (encryptionKey != null) {
                        key = encryptionKey;
                    } else {
                        byte[] data = new byte[32];
                        new SecureRandom().nextBytes(data);
                        key = encryptionKey = Base64.getEncoder().encodeToString(data);
                        log.warn((Object)("Encryption key was not specified for persistent WebAuthn auth, using temporary key " + key));
                    }
                } else {
                    key = (String)((HttpConfiguration)WebAuthnRecorder.this.httpConfiguration.getValue()).encryptionKey.get();
                }
                WebAuthnRunTimeConfig config = (WebAuthnRunTimeConfig)WebAuthnRecorder.this.config.getValue();
                PersistentLoginManager loginManager = new PersistentLoginManager(key, config.cookieName, config.sessionTimeout.toMillis(), config.newCookieInterval.toMillis());
                Object loginPage = config.loginPage.startsWith("/") ? config.loginPage : "/" + config.loginPage;
                return new WebAuthnAuthenticationMechanism(loginManager, (String)loginPage);
            }
        };
    }
}

