/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.vertx.ext.auth.webauthn.Attestation;
import io.vertx.ext.auth.webauthn.AuthenticatorAttachment;
import io.vertx.ext.auth.webauthn.AuthenticatorTransport;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import io.vertx.ext.auth.webauthn.UserVerification;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigRoot(name="webauthn", phase=ConfigPhase.RUN_TIME)
public class WebAuthnRunTimeConfig {
    @ConfigItem
    public Optional<String> origin;
    @ConfigItem(defaultValueDocumentation="USB,NFC,BLE,INTERNAL")
    public Optional<List<AuthenticatorTransport>> transports;
    @ConfigItem
    public RelyingPartyConfig relyingParty;
    @ConfigItem
    public Optional<AuthenticatorAttachment> authenticatorAttachment;
    @ConfigItem(defaultValueDocumentation="false")
    public Optional<Boolean> requireResidentKey;
    @ConfigItem(defaultValueDocumentation="REQUIRED")
    public Optional<UserVerification> userVerification;
    @ConfigItem(defaultValueDocumentation="60s")
    public Optional<Duration> timeout;
    @ConfigItem(defaultValueDocumentation="NONE")
    public Optional<Attestation> attestation;
    @ConfigItem(defaultValueDocumentation="ES256,RS256")
    public Optional<List<PublicKeyCredential>> pubKeyCredParams;
    @ConfigItem(defaultValueDocumentation="64")
    public OptionalInt challengeLength;
    @ConfigItem(defaultValue="/login.html")
    public String loginPage;
    @ConfigItem(defaultValue="PT30M")
    public Duration sessionTimeout;
    @ConfigItem(defaultValue="PT1M")
    public Duration newCookieInterval;
    @ConfigItem(defaultValue="quarkus-credential")
    public String cookieName;

    @ConfigGroup
    public static class RelyingPartyConfig {
        @ConfigItem
        public Optional<String> id;
        @ConfigItem(defaultValue="Quarkus server")
        public String name;
    }
}

