/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.vertx.ext.auth.webauthn.Attestation;
import io.vertx.ext.auth.webauthn.AuthenticatorAttachment;
import io.vertx.ext.auth.webauthn.AuthenticatorTransport;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import io.vertx.ext.auth.webauthn.UserVerification;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigMapping(prefix="quarkus.webauthn")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface WebAuthnRunTimeConfig {
    public Optional<String> origin();

    @ConfigDocDefault(value="USB,NFC,BLE,INTERNAL")
    public Optional<List<AuthenticatorTransport>> transports();

    public RelyingPartyConfig relyingParty();

    public Optional<AuthenticatorAttachment> authenticatorAttachment();

    @ConfigDocDefault(value="false")
    public Optional<Boolean> requireResidentKey();

    @ConfigDocDefault(value="DISCOURAGED")
    public Optional<UserVerification> userVerification();

    @ConfigDocDefault(value="60s")
    public Optional<Duration> timeout();

    @ConfigDocDefault(value="NONE")
    public Optional<Attestation> attestation();

    @ConfigDocDefault(value="ES256,RS256")
    public Optional<List<PublicKeyCredential>> pubKeyCredParams();

    @ConfigDocDefault(value="64")
    public OptionalInt challengeLength();

    @WithDefault(value="/login.html")
    public String loginPage();

    @WithDefault(value="PT30M")
    public Duration sessionTimeout();

    @WithDefault(value="PT1M")
    public Duration newCookieInterval();

    @WithDefault(value="quarkus-credential")
    public String cookieName();

    @WithDefault(value="_quarkus_webauthn_challenge")
    public String challengeCookieName();

    @WithDefault(value="_quarkus_webauthn_username")
    public String challengeUsernameCookieName();

    @WithDefault(value="strict")
    public CookieSameSite cookieSameSite();

    @WithDefault(value="/")
    public Optional<String> cookiePath();

    @WithDefault(value="false")
    public boolean enableCallbackEndpoint();

    @ConfigGroup
    public static interface RelyingPartyConfig {
        public Optional<String> id();

        @WithDefault(value="Quarkus server")
        public String name();
    }

    public static enum CookieSameSite {
        STRICT,
        LAX,
        NONE;

    }
}

