/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TrustedAuthenticationRequest;
import io.quarkus.security.webauthn.WebAuthnAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.quarkus.vertx.http.runtime.security.PersistentLoginManager;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class WebAuthnAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final Logger log = Logger.getLogger(WebAuthnAuthenticationMechanism.class);
    private PersistentLoginManager loginManager;
    private String loginPage;

    WebAuthnAuthenticationMechanism(PersistentLoginManager loginManager, String loginPage) {
        this.loginManager = loginManager;
        this.loginPage = loginPage;
    }

    public Uni<SecurityIdentity> authenticate(final RoutingContext context, IdentityProviderManager identityProviderManager) {
        final PersistentLoginManager.RestoreResult result = this.loginManager.restore(context);
        if (result != null) {
            context.put(HttpAuthenticationMechanism.class.getName(), (Object)this);
            Uni ret = identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new TrustedAuthenticationRequest(result.getPrincipal()), (RoutingContext)context));
            return ret.onItem().invoke((Consumer)new Consumer<SecurityIdentity>(){

                @Override
                public void accept(SecurityIdentity securityIdentity) {
                    WebAuthnAuthenticationMechanism.this.loginManager.save(securityIdentity, context, result, context.request().isSSL());
                }
            });
        }
        return Uni.createFrom().nullItem();
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        log.debugf("Serving login form %s for %s", (Object)this.loginPage, (Object)context);
        return WebAuthnAuthenticationMechanism.getRedirect(context, this.loginPage);
    }

    static Uni<ChallengeData> getRedirect(RoutingContext exchange, String location) {
        String loc = exchange.request().scheme() + "://" + exchange.request().authority() + location;
        return Uni.createFrom().item((Object)new ChallengeData(302, (CharSequence)"Location", loc));
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return new HashSet<Class<? extends AuthenticationRequest>>(Arrays.asList(WebAuthnAuthenticationRequest.class, TrustedAuthenticationRequest.class));
    }

    public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
        return Uni.createFrom().item((Object)new HttpCredentialTransport(HttpCredentialTransport.Type.COOKIE, "webauthn"));
    }

    public PersistentLoginManager getLoginManager() {
        return this.loginManager;
    }
}

