/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import com.webauthn4j.credential.CredentialRecordImpl;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.authenticator.EC2COSEKey;
import com.webauthn4j.data.attestation.authenticator.EdDSACOSEKey;
import com.webauthn4j.data.attestation.authenticator.RSACOSEKey;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.util.Base64UrlUtil;
import io.vertx.ext.auth.impl.Codec;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.EdECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Set;
import java.util.UUID;

public class WebAuthnCredentialRecord
extends CredentialRecordImpl {
    private String username;

    public WebAuthnCredentialRecord(String username, AttestationObject attestationObject, CollectedClientData clientData, AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, Set<AuthenticatorTransport> transports) {
        super(attestationObject, clientData, clientExtensions, transports);
        this.username = username;
    }

    private WebAuthnCredentialRecord(String username, long counter, AttestedCredentialData attestedCredentialData) {
        super(null, null, null, null, counter, attestedCredentialData, null, null, null, null);
        this.username = username;
    }

    public long getCounter() {
        return super.getCounter();
    }

    public String getUsername() {
        return this.username;
    }

    public String getCredentialID() {
        return Base64UrlUtil.encodeToString((byte[])this.getAttestedCredentialData().getCredentialId());
    }

    public RequiredPersistedData getRequiredPersistedData() {
        return new RequiredPersistedData(this.getUsername(), this.getCredentialID(), this.getAttestedCredentialData().getAaguid().getValue(), this.getAttestedCredentialData().getCOSEKey().getPublicKey().getEncoded(), this.getAttestedCredentialData().getCOSEKey().getAlgorithm().getValue(), this.getCounter());
    }

    public static WebAuthnCredentialRecord fromRequiredPersistedData(RequiredPersistedData persistedData) {
        EC2COSEKey coseKey;
        long counter = persistedData.counter();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(persistedData.publicKey);
        COSEAlgorithmIdentifier coseAlgorithm = COSEAlgorithmIdentifier.create((long)persistedData.publicKeyAlgorithm);
        try {
            switch (coseAlgorithm.getKeyType()) {
                case EC2: {
                    coseKey = EC2COSEKey.create((ECPublicKey)((ECPublicKey)KeyFactory.getInstance("EC").generatePublic(x509EncodedKeySpec)), (COSEAlgorithmIdentifier)coseAlgorithm);
                    break;
                }
                case OKP: {
                    coseKey = EdDSACOSEKey.create((EdECPublicKey)((EdECPublicKey)KeyFactory.getInstance("EdDSA").generatePublic(x509EncodedKeySpec)), (COSEAlgorithmIdentifier)coseAlgorithm);
                    break;
                }
                case RSA: {
                    coseKey = RSACOSEKey.create((RSAPublicKey)((RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(x509EncodedKeySpec)), (COSEAlgorithmIdentifier)coseAlgorithm);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid cose algorithm: " + String.valueOf(coseAlgorithm));
                }
            }
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalArgumentException("Invalid public key", e);
        }
        byte[] credentialId = Codec.base64UrlDecode((String)persistedData.credentialId());
        AAGUID aaguid = new AAGUID(persistedData.aaguid());
        AttestedCredentialData attestedCredentialData = new AttestedCredentialData(aaguid, credentialId, (COSEKey)coseKey);
        return new WebAuthnCredentialRecord(persistedData.username(), counter, attestedCredentialData);
    }

    public record RequiredPersistedData(String username, String credentialId, UUID aaguid, byte[] publicKey, long publicKeyAlgorithm, long counter) {
        public String getPublicKeyPEM() {
            return "-----BEGIN PUBLIC KEY-----\n" + Base64.getEncoder().encodeToString(this.publicKey) + "\n-----END PUBLIC KEY-----\n";
        }
    }
}

