/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import com.webauthn4j.data.PublicKeyCredentialCreationOptions;
import com.webauthn4j.data.PublicKeyCredentialRequestOptions;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.webauthn.WebAuthnCredentialRecord;
import io.quarkus.security.webauthn.WebAuthnSecurity;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.util.function.Supplier;

public class WebAuthnController {
    private WebAuthnSecurity security;

    public WebAuthnController(WebAuthnSecurity security) {
        this.security = security;
    }

    public void wellKnown(RoutingContext ctx) {
        try {
            ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(new JsonObject().put("origins", this.security.getAllowedOrigins(ctx)).encode());
        }
        catch (IllegalArgumentException e) {
            ctx.fail(400, (Throwable)e);
        }
        catch (RuntimeException e) {
            ctx.fail((Throwable)e);
        }
    }

    public void registerOptionsChallenge(RoutingContext ctx) {
        try {
            String username = ctx.queryParams().get("username");
            String displayName = ctx.queryParams().get("displayName");
            this.withContext(() -> this.security.getRegisterChallenge(username, displayName, ctx)).map(challenge -> this.security.toJsonString((PublicKeyCredentialCreationOptions)challenge)).subscribe().with(challenge -> WebAuthnController.ok(ctx, challenge), arg_0 -> ((RoutingContext)ctx).fail(arg_0));
        }
        catch (IllegalArgumentException e) {
            ctx.fail(400, (Throwable)e);
        }
        catch (RuntimeException e) {
            ctx.fail((Throwable)e);
        }
    }

    private <T> Uni<T> withContext(Supplier<Uni<T>> uni) {
        ManagedContext requestContext = Arc.container().requestContext();
        requestContext.activate();
        InjectableContext.ContextState contextState = requestContext.getState();
        return uni.get().eventually(() -> requestContext.destroy(contextState));
    }

    public void loginOptionsChallenge(RoutingContext ctx) {
        try {
            String username = ctx.queryParams().get("username");
            this.withContext(() -> this.security.getLoginChallenge(username, ctx)).map(challenge -> this.security.toJsonString((PublicKeyCredentialRequestOptions)challenge)).subscribe().with(challenge -> WebAuthnController.ok(ctx, challenge), arg_0 -> ((RoutingContext)ctx).fail(arg_0));
        }
        catch (IllegalArgumentException e) {
            ctx.fail(400, (Throwable)e);
        }
        catch (RuntimeException e) {
            ctx.fail((Throwable)e);
        }
    }

    public void login(RoutingContext ctx) {
        try {
            JsonObject webauthnResp = ctx.getBodyAsJson();
            this.withContext(() -> this.security.login(webauthnResp, ctx)).onItem().call(record -> this.security.storage().update(record.getCredentialID(), record.getCounter())).subscribe().with(record -> {
                this.security.rememberUser(record.getUsername(), ctx);
                WebAuthnController.ok(ctx);
            }, x -> ctx.fail(400, x));
        }
        catch (IllegalArgumentException e) {
            ctx.fail(400, (Throwable)e);
        }
        catch (RuntimeException e) {
            ctx.fail((Throwable)e);
        }
    }

    public void register(RoutingContext ctx) {
        try {
            String username = ctx.queryParams().get("username");
            JsonObject webauthnResp = ctx.getBodyAsJson();
            this.withContext(() -> this.security.register(username, webauthnResp, ctx)).onItem().call(record -> this.security.storage().create((WebAuthnCredentialRecord)((Object)record))).subscribe().with(record -> {
                this.security.rememberUser(record.getUsername(), ctx);
                WebAuthnController.ok(ctx);
            }, x -> ctx.fail(400, x));
        }
        catch (IllegalArgumentException e) {
            ctx.fail(400, (Throwable)e);
        }
        catch (RuntimeException e) {
            ctx.fail((Throwable)e);
        }
    }

    public void logout(RoutingContext ctx) {
        this.security.logout(ctx);
        ctx.redirect("/");
    }

    private static void ok(RoutingContext ctx, String json) {
        ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(json);
    }

    private static void ok(RoutingContext ctx) {
        ctx.response().setStatusCode(204).end();
    }

    public void javascript(RoutingContext ctx) {
        ctx.response().sendFile("webauthn.js");
    }
}

