/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.SecurityIdentity;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;

public class QuarkusSecurityIdentity
implements SecurityIdentity {
    private final Principal principal;
    private final Set<String> roles;
    private final Set<Credential> credentials;
    private final Map<String, Object> attributes;
    private final List<Function<Permission, CompletionStage<Boolean>>> permissionCheckers;

    private QuarkusSecurityIdentity(Builder builder) {
        this.principal = builder.principal;
        this.roles = Collections.unmodifiableSet(builder.roles);
        this.credentials = Collections.unmodifiableSet(builder.credentials);
        this.attributes = Collections.unmodifiableMap(builder.attributes);
        this.permissionCheckers = Collections.unmodifiableList(builder.permissionCheckers);
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean isAnonymous() {
        return false;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public <T extends Credential> T getCredential(Class<T> credentialType) {
        for (Credential i : this.credentials) {
            if (!credentialType.isAssignableFrom(i.getClass())) continue;
            return (T)i;
        }
        return null;
    }

    public Set<Credential> getCredentials() {
        return this.credentials;
    }

    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public CompletionStage<Boolean> checkPermission(Permission permission) {
        if (this.permissionCheckers.isEmpty()) {
            return CompletableFuture.completedFuture(true);
        }
        ArrayList<CompletableFuture<Boolean>> results = new ArrayList<CompletableFuture<Boolean>>(this.permissionCheckers.size());
        for (Function<Permission, CompletionStage<Boolean>> checker : this.permissionCheckers) {
            CompletionStage<Boolean> res = checker.apply(permission);
            if (res == null) continue;
            results.add(res.toCompletableFuture());
        }
        if (results.isEmpty()) {
            return CompletableFuture.completedFuture(true);
        }
        if (results.size() == 1) {
            return (CompletionStage)results.get(0);
        }
        CompletionStage<Boolean> ret = (CompletionStage<Boolean>)results.get(0);
        for (int i = 1; i < results.size(); ++i) {
            ret = ret.thenCombine((CompletionStage)results.get(i), new BiFunction<Boolean, Boolean, Boolean>(){

                @Override
                public Boolean apply(Boolean aBoolean, Boolean aBoolean2) {
                    if (aBoolean == null) {
                        return aBoolean2;
                    }
                    if (aBoolean2 == null) {
                        return aBoolean;
                    }
                    return aBoolean != false || aBoolean2 != false;
                }
            });
        }
        return ret;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        Principal principal;
        Set<String> roles = new HashSet<String>();
        Set<Credential> credentials = new HashSet<Credential>();
        Map<String, Object> attributes = new HashMap<String, Object>();
        List<Function<Permission, CompletionStage<Boolean>>> permissionCheckers = new ArrayList<Function<Permission, CompletionStage<Boolean>>>();
        boolean built = false;

        public Builder setPrincipal(Principal principal) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.principal = principal;
            return this;
        }

        public Builder addRole(String role) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.roles.add(role);
            return this;
        }

        public Builder addRoles(Set<String> roles) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.roles.addAll(roles);
            return this;
        }

        public Builder addCredential(Credential credential) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.credentials.add(credential);
            return this;
        }

        public Builder addCredentials(Set<Credential> credentials) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.credentials.addAll(credentials);
            return this;
        }

        public Builder addAttribute(String key, Object value) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.attributes.put(key, value);
            return this;
        }

        public Builder addAttributes(Map<String, Object> attributes) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.attributes.putAll(attributes);
            return this;
        }

        public Builder addPermissionChecker(Function<Permission, CompletionStage<Boolean>> function) {
            if (this.built) {
                throw new IllegalStateException();
            }
            this.permissionCheckers.add(function);
            return this;
        }

        public QuarkusSecurityIdentity build() {
            this.built = true;
            return new QuarkusSecurityIdentity(this);
        }
    }
}

