/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import java.security.Principal;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;

@RequestScoped
public class SecurityIdentityAssociation
implements CurrentIdentityAssociation {
    private volatile SecurityIdentity identity;
    @Inject
    IdentityProviderManager identityProviderManager;

    @Produces
    @RequestScoped
    Principal principal() {
        return new Principal(){

            @Override
            public String getName() {
                return SecurityIdentityAssociation.this.getIdentity().getPrincipal().getName();
            }
        };
    }

    public SecurityIdentity setIdentity(@Observes SecurityIdentity identity) {
        SecurityIdentity old = this.identity;
        this.identity = identity;
        return old;
    }

    public SecurityIdentity getIdentity() {
        if (this.identity == null) {
            this.identity = (SecurityIdentity)this.identityProviderManager.authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE).toCompletableFuture().join();
        }
        return this.identity;
    }
}

